# Data Normalizer

Slouží k normalizaci dat v poli. Oproti options resolveru méně validuje a více se snaží udělat řád z chaosu.

## Normalizace dat

Metoda `normalizeData` upraví dle předané definice `$propertyDefinition` předaná data `$data`. Výsledkem je pole, které splňuje následující:

* Má klíč pro každý klíč, který je uveden v `$propertyDefinition`.
* Neobsahuje klíče, které nejsou uvedeny v `$propertyDefinition` (ale jsou třeba v `$data`).
* Hodnoty pod jednotlivými klíči odpovídají požadovanému formátu z `$propertyDefinition`.

## Použití

### Příklad volání
```php
<?php

(new \Dalten\DataNormalizer\DataNormalizer())->normalizeData(['test' => 'int'], ['test' => '15', 'a' => 'b']);
// => ['test' => 15]
```

### Podporované datové typy
* int
* float
* string
* bool
* array
* serialized_array – převede serializované php pole na pole a výsledek přetypuje na `array`
* json_array – převede json string na asociativní pole
* int[] – pole prvků typu `string`
* string[] – pole prvku typu `string`
* date – převede hodnotu na `\DatetimeImmutable` (pokud se nezdaří, vyhodí `\InvalidArgumentException`)

### Přípustné hodnoty null

Pokud pole může nabývat i hodnoty `null`, je nutné na začátek jeho typu (v `$propertyDefinition`) přidat `?`. Tj. pro pole s typem `int`, které může nabývat hodnoty `null` je správný zápis typu `?int`.

```php
<?php

$dataNormalizer = new \Dalten\DataNormalizer\DataNormalizer();
$dataNormalizer->normalizeData(['test' => 'int'], []); // ['test' => 0]

$dataNormalizer->normalizeData(['test' => '?int'], []); // ['test' => null]
```

### Datové hodnoty

Pro hodnoty s datem (a časem) je určen datový typ `date`. Převádí předaný text na `\DateTimeImmutable`. Pokud to není možné a pole není nullable, pak vyhodí potomka `\InvalidArgumentException`, konkrétně `\Dalten\DataNormalizer\Error\UnknownDataType` nebo `\Dalten\DataNormalizer\Error\ImpossibleValueConversion`.
