<?php

namespace Dalten\DataNormalizer\Error;

class ImpossibleValueConversion extends \InvalidArgumentException implements DataNormalizerError
{
    private string $invalidPropertyName;
    private string $expectedDataType;

    public static function becauseValueCannotBeConvertedToExpectedDataType(string $expectedDataType, \Throwable $previous = null): self
    {
        $ex = new self(
            sprintf('Hodnotu nelze převést na %s', $expectedDataType), 0, $previous
        );
        $ex->expectedDataType = $expectedDataType;

        return $ex;
    }

    public static function becauseValueIsInvalidForChosenDataType(string $expectedDataType, \Throwable $previous = null): self
    {
        $ex = new self(
            sprintf('Neplatná hodnota pro typ proměnné %s', $expectedDataType),
            0, $previous
        );
        $ex->expectedDataType = $expectedDataType;

        return $ex;
    }

    public function withPropertyName(string $propertyName): void
    {
        $this->invalidPropertyName = $propertyName;
    }

    public function getInvalidPropertyName(): ?string
    {
        return $this->invalidPropertyName ?? null;
    }

    /** @return ?string název typu stejný jako u definice properties */
    public function getExpectedDataType(): ?string
    {
        return $this->expectedDataType ?? null;
    }
}
