<?php

namespace Dalten\DataNormalizer\Error;

class UnknownDataType extends \InvalidArgumentException implements DataNormalizerError
{
    private string $propertyName;
    private string $invalidValueType;

    public static function becauseDataTypeIsNotKnown(string $invalidValueType,
        \Throwable $previous = null): self
    {
        $ex = new self(
            sprintf('Neznámý datový typ "%s".', $invalidValueType), 0, $previous
        );
        $ex->invalidValueType = $invalidValueType;

        return $ex;
    }

    public function getPropertyName(): ?string
    {
        return $this->propertyName ?? null;
    }

    public function getInvalidValueType(): ?string
    {
        return $this->invalidValueType ?? null;
    }

    public function withPropertyName(string $propertyName): void
    {
        $this->propertyName = $propertyName;
    }
}
