<?php /** @noinspection ALL */

$finder = PhpCsFixer\Finder::create()->in('src');

$config = new PhpCsFixer\Config();

return $config->setRules([
    '@Symfony' => true,
    '@Symfony:risky' => true,
    '@PHP70Migration' => true,
    '@PHP70Migration:risky' => true,
    '@PHP71Migration' => true,
    '@PHP71Migration:risky' => true,
    '@PHP73Migration' => true,
    '@PHP74Migration' => true,
    '@PHP74Migration:risky' => true,
    '@PHPUnit60Migration:risky' => true,
    '@PHPUnit75Migration:risky' => true,
    '@PHPUnit84Migration:risky' => true,
])
    ->setFinder($finder)
    ->setIndent("\t")
    ->setLineEnding(PHP_EOL)
    ->setRiskyAllowed(true)
    ->setCacheFile(__DIR__ . DIRECTORY_SEPARATOR . '.php_cs.cache');
