% Specifikace exportního rozhraní programu iRest

verze kódu 1.5.1 (dokumentace z 23.11.2021)

# Úvod {#uvod}

Exportní rozhraní slouží k exportování nabídek na realitní weby klientů programu iRest.

Rozhraní je založeno na protokolu [XML-RPC](https://en.wikipedia.org/wiki/XML-RPC). Program iRest je z pohledu
protokolu klientem, realitní web pak serverem. Pro webovou část poskytujeme funkční implementaci ke které poskytujeme 
databázové schéma a číselníky.

Tato dokumentace obsahuje [popis metod](#metody), [struktury předávaných dat](#struktura-dat) a dokumentaci [postupu pro zprovoznění rozhraní](#zprovozneni).

V dokumentaci jsou důsledně používána tato pojmenování XML-RPC typů:

 - struktura = struct
 - pole = array
 - člen = member
 - hodnota = value
 - řetězec = string
 - celé číslo = integer
 - desetinné číslo = double

## Zprovoznění exportního rozhraní {#zprovozneni}

Ke zprovoznění exportního rozhraní potřebujete webový hosting s databází MySQL (nebo kompatibilní) s podporou programovacího jazyka PHP a to minimálně ve verzi 7.2.

Exportní rozhraní vystavte na veřejně přístupnou URL, kterou si zadáte do programu iRest společně s přihlašovacími údaji (ve výchozím nastavení je to přihlašovací jméno `x_web` a heslo `x_web`) .

Kroky pro zprovoznění exportního rozhraní jsou následující:

1) založení databáze pro exportní rozhraní a web
2) import databázového schématu a obsahu pracovních tabulek webu ze souboru `prazdna_db_webu.sql` a adresní databáze ze souboru `adresy.sql`
3) instalace samotného exportního rozhraní a instalace jeho závislostí (přes `composer install` nebo ručně) - knihovny PhpXmlRpc a composer/ca-bundle
4) nastavení přístupových údajů pro databázi a cesty pro stahování obrázků v souboru `import.php` (respektive v míste, odkud se inicializuje třída `\Dalten\Import\Runner`)
5) samotný import nabídek z Irestu pro ověření funkčnosti rozhraní

V závislosti na technickém řešení vašeho webu se mohou jednotlivé kroky mírně lišit.

Pro zobrazení netextových dat nabídek doporučujeme využít číselníky (tabulky `variables` a `variables_list_values`) a adresní databázi. 

Samotná struktura databáze zatím zdokumentovaná není, nicméně je celkem přímočará.
