# Struktura dat

Popis údajů, které se dají poslat, je vlastně popisem formuláře na jejich zadávání. V tomto formuláři můžete najít
následující typy políček:

- select - výběrníček, je možné vybrat pouze jednu možnost, odesílá se její hodnota
- multicheckbox - výběrníček, je možné vybrat z více možností (zaškrtávacími políčky), posílá se zakódované jako řetězec, kde nula
  nebo jednička na dané pozici určuje, zda je možnost zaškrtnutá. Pořadí možností se počítá od nuly.
- checkbox - zaškrtávací políčko, posílá se hodnota `1` pokud je zaškrtnuto jinak `0`
- memo - dlouhé textové pole (víceřádkové)
- short_text - krátké textové pole (jednořádkové)
- int - celočíselné pole
- int_metry - celočíselné pole, údaj je v metrech
- int_metry_ctverecni - celočíselné pole, údaj je v metrech čtverečních
- int_metry_krychlove - celočíselné pole, údaj je v metrech krychlových
- float - pole na zadání desetinného čísla
- date - datum, posílá se jako řetězec ve tvaru `YYYY-MM-DD`
- time - čas, posílá jako řetězec ve tvaru `HH:MM`
- ano/ne - výběrníček *Ano/Ne*, ano se posílá jako `1`, ne jako `0`
- ano/ne/? - výběrníček *Ano/Ne/?*, ano se posílá jako `1`, ne jako `0`, ? jako `-1`
- ano/ne + plocha - podobné pole jako ano/ne. Pokud má hodnotu `1`, pak je v poli se stejným názvem a příponou
 `_plocha` (např. `nemovitost_balkon_plocha` pro `nemovitost_balkon`) uvedena plocha. 
 Plocha nemusí být vyplněna. 
 (tj. Může být uvedeno že nemovitost má balkon a zároveň nemusí být specifikována jeho plocha.)
- mena - pole na výběr měny, možnosti jsou `1`=Kč, `2`=USD, `3`=EUR

Ukázka dekódování multicheckboxu:

```php
/**
 * Převede textovou reprezentaci multicheckboxu na pole.
 *
 * @param string $field Hodnota multiCheckbox pole.
 *
 * @return array Pole zaškrtnutých možností.
 */
function multiCheckboxToArray($field) {
    return array_keys(array_filter(str_split($value)));
}

$array = multiCheckboxToArray($data['nemovitost_odpad']);

// např.: multiCheckboxToArray('0101') => array(1, 3)
```

Ukázka zjištění, zda je konkrétní hodnota zaškrtnuta:

```php
/**
 * Vrací je-li v poli $data zaškrtnuté pole $fieldName jako multicheckbox na hodnotě $value.
 *
 * @param string $field Hodnota multiCheckbox pole.
 * @param int    $value Hodnota zašktávátka.
 *
 * @return bool Je to tak?
 */
function isMultiChecked($field, $value) {
    if (substr($field, $value, 1)==1) {
		return true;
	}
	return false;
}

$mameKanalizaci = isMultiChecked($data['nemovitost_odpad'], 0);
```

## Překlad údajů {#preklad}

Některá pole nabídky (`nemovitost_titulek`, `nemovitost_popis_zakladni`, `nemovitost_popis_detailni`,
`nemovitost_cena_poznamka`, `nemovitost_vybaveni_kancelari_popis`, `nemovitost_vybaveno_popis`) a projektu
(`projekt_nazev`, `projekt_zakladni_popis`, `projekt_popis`, `projekt_lokalita`, `projekt_etapy`) je možno v iRestu
přeložit do cizích jazyků. Na web se překlad odesílá tak, že se za název přeloženého políčka dodá kód jazyka,
tj. například titulek přeložený do angličtiny má název `nemovitost_titulek_en`. Tyto sloupce musí být přidané do
databáze.

## Nabídka {#nabidka}

Údaje, které je možno poslat, se liší podle typu nemovitosti (`nemovitost_typ`).

### Společné údaje {#spolecne-udaje}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_titulek` | short_text | **Titulek**
`nemovitost_popis_zakladni` | short_text | **Základní popis**
`nemovitost_popis_detailni` | memo | **Detailní popis**
`nemovitost_typ` | select | **Typ nemovitosti**
&nbsp; | 4 | Byty
&nbsp; | 6 | Domy a vily
&nbsp; | 10 | Chaty a rekreační objekty
&nbsp; | 1 | Zemědělské objekty
&nbsp; | 3 | Pozemky
&nbsp; | 11 | Malé objekty, garáže
&nbsp; | 9 | Komerční prostory
&nbsp; | 2 | Komerční objekty
&nbsp; | 5 | Historické objekty
&nbsp; | 7 | Hotely, penziony a restaurace
&nbsp; | 8 | Nájemní domy
`zakazka_typ` | select | **Typ zakázky**
&nbsp; | 1 | Prodej
&nbsp; | 2 | Pronájem
&nbsp; | 3 | ~~Prodej nebo pronájem~~
`zakazka_stav` | select | **Stav zakázky**
&nbsp; | 10 | příprava
&nbsp; | 20 | aktivní
&nbsp; | 30 | rezervace
&nbsp; | 40 | realizováno
&nbsp; | 41 | realizováno jinou RK
&nbsp; | 50 | zrušeno
`zakazka_typ_smlouvy` | select | **Typ smlouvy**
&nbsp; | 10 | exkluzivní
&nbsp; | 20 | neexkluzivní
&nbsp; | 30 | coexkluzivní
&nbsp; | 40 | bez smlouvy
`nemovitost_video_prohlidka` | short_text | **URL video prohlídky (vč. http://)**
`nemovitost_virtualni_prohlidka` | short_text | **Virtuální prohlídka (360°)**
`nemovitost_energeticky_stitek_priloha` | short_text | **Příloha energetického štítku** (cesta k souboru)
`zobrazit_panorama` | checkbox | **Zobrazit panoráma?**
`web_nemovitosti_url` | short_text | **URL samostatné webové prezentace nemovitosti**

### Cena

Z iRestu se vždy posílají všechny položky, o tom, zda se použije cena prodeje nebo pronájmu rozhoduje položka <code>zakazka_typ</code>.<br>

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_cena_prodej` | float | **Cena prodej**
`nemovitost_cena_prodej_jednotka` | select | **Jednotka prodej**
&nbsp; | 1 | za nemovitost
&nbsp; | 3 | za m2
`nemovitost_cena_pronajem` | float | **Cena pronájem**
`nemovitost_cena_pronajem_jednotka` | select | **Jednotka pronájem**
&nbsp; | 2 | za měsíc
&nbsp; | 4 | za m2/měsíc
&nbsp; | 5 | za m2/rok
&nbsp; | 6 | za rok
&nbsp; | 7 | za den
`nemovitost_cena_poznamka` | short_text | **Poznámka k ceně**
`nemovitost_mena` | select | **Měna**
&nbsp; | 1 | CZK
&nbsp; | 2 | USD
&nbsp; | 3 | EUR

[zpět na obsah](#TOC)

### Byty

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_dispozice` | select | **Dispozice**
&nbsp; | 1 | Garsoniéra
&nbsp; | 2 | 1+kk
&nbsp; | 9 | 1+1
&nbsp; | 3 | 2+kk
&nbsp; | 10 | 2+1
&nbsp; | 4 | 3+kk
&nbsp; | 11 | 3+1
&nbsp; | 5 | 4+kk
&nbsp; | 12 | 4+1
&nbsp; | 6 | 5+kk
&nbsp; | 13 | 5+1
&nbsp; | 7 | 6+kk
&nbsp; | 14 | 6+1
&nbsp; | 8 | 7+kk
&nbsp; | 15 | 7+1
&nbsp; | 16 | Atypický
&nbsp; | 17 | Jiný
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_vlastnictvi` | select | **Vlastnictví**
&nbsp; | 1 | Osobní
&nbsp; | 2 | Družstevní
&nbsp; | 4 | Obecní
&nbsp; | 5 | Státní
&nbsp; | 6 | U majitele
&nbsp; | 3 | Jiný druh
&nbsp; | 7 | ~~Jiné~~
`nemovitost_podlazi_cislo` | int | **Číslo podlaží v domě**
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`pocet_mist_k_parkovani` | int | **Počet míst k parkování**
`nemovitost_plocha_celkova` | int_metry_ctverecni | **Celková plocha**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_vlastni_pozemek` | int_metry_ctverecni | **Vlastní pozemek**
`nemovitost_balkon` | ano/ne + plocha | **Balkon**
`nemovitost_lodzie` | ano/ne + plocha | **Lodžie**
`nemovitost_terasa` | ano/ne + plocha | **Terasa**
`nemovitost_sklep` | ano/ne + plocha | **Sklep**
`nemovitost_garaz` | ano/ne + plocha | **Garáž**
`nemovitost_druh_bytu` | select | **Druh bytu**
&nbsp; | 1 | Byt v rodinném domě
&nbsp; | 2 | V nájemním domě (činžovním)
&nbsp; | 3 | V panelovém domě
&nbsp; | 4 | V penzionu
&nbsp; | 5 | Jiný
`nemovitost_vytah` | ano/ne/? | **Výtah**
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_bezbarierovy` | ano/ne/? | **Bezbariérový byt**
`nemovitost_pudni_vestavba` | ano/ne/? | **Půdní vestavba / nástavba**
`nemovitost_pocet_podlazi_pod_zemi` | int | **Počet podlaží pod zemí**
`nemovitost_konstrukcni_prvky` | memo | **Konstrukční prvky**
`nemovitost_vyska_stropu` | float | **Výška stropu**
`nemovitost_vybaveno` | ano/ne/? | **Vybaveno**
`nemovitost_vybaveno_popis` | memo | **Popis vybavení**
`nemovitost_datum_nastehovani` | date | **K nastěhování**
`nemovitost_rok_rekonstrukce` | int | **Rok rekonstrukce**
`nemovitost_rok_kolaudace` | int | **Rok kolaudace**
`nemovitost_rok_vystavby` | int | **Rok výstavby**
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_obcanska_vybavenost` | multicheckbox | **Občanská vybavenost**
&nbsp; | 0 | Škola
&nbsp; | 1 | Školka
&nbsp; | 2 | Zdravotnická zařízení
&nbsp; | 3 | Pošta
&nbsp; | 4 | Supermarket
&nbsp; | 5 | Kompletní síť obchodů a služeb
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Domy

Pole | Typ/Hodnota | Popis
:----|--:|:------
`nemovitost_poloha_objektu` | select | **Poloha objektu**
&nbsp; | 1 | Řadový
&nbsp; | 2 | Rohový
&nbsp; | 3 | V bloku
&nbsp; | 4 | Samostatný
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_pocet_pokoju` | select | **Počet pokojů**
&nbsp; | 1 | 1 pokoj
&nbsp; | 2 | 2 pokoje
&nbsp; | 3 | 3 pokoje
&nbsp; | 4 | 4 pokoje
&nbsp; | 5 | 5 a více pokojů
&nbsp; | 6 | Atypický
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`pocet_mist_k_parkovani` | int | **Počet míst k parkování**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_plocha_zahrada` | int_metry_ctverecni | **Plocha zahrady**
`nemovitost_plocha_dalsi_zelene` | int_metry_ctverecni | **Další zelené plochy**
`nemovitost_plocha_uzitna_podkrovi` | int_metry_ctverecni | **Užitná plocha v podkroví**
`nemovitost_plocha_uzitna_prizemi` | int_metry_ctverecni | **Užitná plocha v přízemí**
`nemovitost_plocha_vnejsich_komunikaci` | int_metry_ctverecni | **Plocha vnějších komunikací**
`nemovitost_balkon` | ano/ne + plocha | **Balkon**
`nemovitost_lodzie` | ano/ne + plocha | **Lodžie**
`nemovitost_terasa` | ano/ne + plocha | **Terasa**
`nemovitost_sklep` | ano/ne + plocha | **Sklep**
`nemovitost_garaz` | ano/ne + plocha | **Garáž**
`nemovitost_bazen` | ano/ne + plocha | **Bazén**
`nemovitost_vlastnictvi` | select | **Vlastnictví**
&nbsp; | 1 | Osobní
&nbsp; | 2 | Družstevní
&nbsp; | 4 | Obecní
&nbsp; | 5 | Státní
&nbsp; | 6 | U majitele
&nbsp; | 3 | Jiný druh
&nbsp; | 7 | ~~Jiné~~
`nemovitost_pocet_podlazi_pod_zemi` | int | **Počet podlaží pod zemí**
`nemovitost_bytu_celkem` | int | **Počet bytů celkem**
`nemovitost_stromy` | ano/ne/? | **Stromy**
`nemovitost_vybaveno` | ano/ne/? | **Vybaveno**
`nemovitost_vybaveno_popis` | memo | **Popis vybavení**
`nemovitost_datum_nastehovani` | date | **K nastěhování**
`nemovitost_rok_rekonstrukce` | int | **Rok rekonstrukce**
`nemovitost_rok_kolaudace` | int | **Rok kolaudace**
`nemovitost_rok_vystavby` | int | **Rok výstavby**
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_obcanska_vybavenost` | multicheckbox | **Občanská vybavenost**
&nbsp; | 0 | Škola
&nbsp; | 1 | Školka
&nbsp; | 2 | Zdravotnická zařízení
&nbsp; | 3 | Pošta
&nbsp; | 4 | Supermarket
&nbsp; | 5 | Kompletní síť obchodů a služeb
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Chaty a chalupy

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_typ_rekreacniho_objektu` | select | **Typ objektu**
&nbsp; | 1 | Chata
&nbsp; | 2 | Chalupa
`nemovitost_poloha_objektu` | select | **Poloha objektu**
&nbsp; | 1 | Řadový
&nbsp; | 2 | Rohový
&nbsp; | 3 | V bloku
&nbsp; | 4 | Samostatný
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_pocet_pokoju` | select | **Počet pokojů**
&nbsp; | 1 | 1 pokoj
&nbsp; | 2 | 2 pokoje
&nbsp; | 3 | 3 pokoje
&nbsp; | 4 | 4 pokoje
&nbsp; | 5 | 5 a více pokojů
&nbsp; | 6 | Atypický
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_bazen` | ano/ne + plocha | **Bazén**
`nemovitost_sklep` | ano/ne + plocha | **Sklep**
`nemovitost_garaz` | ano/ne + plocha | **Garáž**
`nemovitost_pocet_mist` | int | **Počet parkovacích míst**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Zemědělské objekty {#zemedelske-objekty}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`pocet_mist_k_parkovani` | int | **Počet míst k parkování**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_plocha_uzitna_podkrovi` | int_metry_ctverecni | **Užitná plocha v podkroví**
`nemovitost_plocha_uzitna_prizemi` | int_metry_ctverecni | **Užitná plocha v přízemí**
`nemovitost_plocha_vnejsich_komunikaci` | int_metry_ctverecni | **Plocha vnějších komunikací**
`nemovitost_plocha_zahrada` | int_metry_ctverecni | **Plocha zahrady**
`nemovitost_plocha_dalsi_zelene` | int_metry_ctverecni | **Další zelené plochy**
`nemovitost_pocet_podlazi_pod_zemi` | int | **Počet podlaží pod zemí**
`nemovitost_bytu_celkem` | int | **Počet bytů celkem**
`nemovitost_pocet_bytu_volnych` | int | **Počet bytů volných**
`nemovitost_stromy` | ano/ne/? | **Stromy**
`nemovitost_datum_nastehovani` | date | **K nastěhování**
`nemovitost_rok_rekonstrukce` | int | **Rok rekonstrukce**
`nemovitost_rok_kolaudace` | int | **Rok kolaudace**
`nemovitost_rok_vystavby` | int | **Rok výstavby**
`nemovitost_vybaveno` | ano/ne/? | **Vybaveno**
`nemovitost_vybaveno_popis` | memo | **Popis vybavení**
`nemovitost_dalsi_nebytove_prostory` | multicheckbox | **Další nebytové prostory**
&nbsp; | 0 | Garáž
&nbsp; | 1 | Dvojgaráž
&nbsp; | 2 | Přístřešek
`nemovitost_ostatni` | multicheckbox | **Ostatní**
&nbsp; | 0 | Plot
&nbsp; | 1 | Bezbariérový přístup
&nbsp; | 2 | Bazén
&nbsp; | 3 | Garáž
&nbsp; | 4 | Výtah
&nbsp; | 5 | Parkoviště
&nbsp; | 6 | Ostraha
&nbsp; | 7 | Ostraha - PCO
&nbsp; | 8 | Recepce
&nbsp; | 9 | Vrátnice
&nbsp; | 10 | Stravování
&nbsp; | 11 | Sociální zařízení
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_sirka` | float | **Šířka**
`nemovitost_delka` | float | **Délka**
`nemovitost_vyska` | float | **Výška**
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Pozemky

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_druh_pozemku` | select | **Druh pozemku**
&nbsp; | 1 | Pro komerční výstavbu
&nbsp; | 2 | Pro bydlení
&nbsp; | 3 | Zemědělská
&nbsp; | 4 | Les
&nbsp; | 5 | Trvalý travní porost
&nbsp; | 6 | Zahrada
&nbsp; | 7 | Ostatní
`nemovitost_plocha_celkova` | int_metry_ctverecni | **Celková plocha**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_komunikace` | select | **Komunikace**
&nbsp; | 1 | Betonová
&nbsp; | 2 | Dlážděná
&nbsp; | 3 | Asfaltová
&nbsp; | 4 | Neupravená
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_obcanska_vybavenost` | multicheckbox | **Občanská vybavenost**
&nbsp; | 0 | Škola
&nbsp; | 1 | Školka
&nbsp; | 2 | Zdravotnická zařízení
&nbsp; | 3 | Pošta
&nbsp; | 4 | Supermarket
&nbsp; | 5 | Kompletní síť obchodů a služeb
`nemovitost_umisteni_v_chranenych_lokalitach` | multicheckbox | **Umístění v chráněných lokalitách**
&nbsp; | 0 | Ochranné pásmo
&nbsp; | 1 | Národní park
&nbsp; | 2 | CHKO
`nemovitost_inzenyrske_site` | multicheckbox | **Inženýrské sítě**
&nbsp; | 0 | Vodovod
&nbsp; | 1 | Kanalizace
&nbsp; | 2 | Plyn
&nbsp; | 3 | Elektřina
`nemovitost_charakter_zastavby` | select | **Charakter okolní zástavby**
&nbsp; | 1 | Obytná
&nbsp; | 2 | Obchodní a obytná
&nbsp; | 3 | Obchodní
&nbsp; | 4 | Komerční
&nbsp; | 5 | Průmyslová
&nbsp; | 6 | Venkovská
&nbsp; | 7 | Rekreační
&nbsp; | 8 | Rekreačně nevyužitelná
`nemovitost_druh_stavby` | select | **Druh stavby**
&nbsp; | 1 | Budova/y, hala/y
&nbsp; | 2 | Inženýrské nebo specifické pozemní stavby
&nbsp; | 3 | Rodinný dům, rekreační chalupa, rekreační pozemek
&nbsp; | 4 | Rekreační a zahrádkářská chata
&nbsp; | 5 | Garáž
&nbsp; | 6 | Vedlejší stavba
&nbsp; | 7 | Studna
&nbsp; | 8 | Ostatní
`nemovitost_ostatni_vybavenost` | memo | **Ostatní vybavenost**
`nemovitost_stavba_na_pozemku` | multicheckbox | **Stavba na pozemku**
&nbsp; | 0 | Stavba na pozemku
&nbsp; | 1 | Cena stavby je zahrnuta v ceně pozemku
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Malé objekty, garáže {#male-objekty-garaze}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_typ_maleho_objektu` | select | **Typ objektu**
&nbsp; | 1 | Garáž
&nbsp; | 2 | Ostatní
`nemovitost_poloha_objektu` | select | **Poloha objektu**
&nbsp; | 1 | Řadový
&nbsp; | 2 | Rohový
&nbsp; | 3 | V bloku
&nbsp; | 4 | Samostatný
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_sirka` | float | **Šířka**
`nemovitost_delka` | float | **Délka**
`nemovitost_vyska` | float | **Výška**
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_komunikace` | select | **Komunikace**
&nbsp; | 1 | Betonová
&nbsp; | 2 | Dlážděná
&nbsp; | 3 | Asfaltová
&nbsp; | 4 | Neupravená
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Komerční prostory {#komercni-prostory}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_plocha_kancelari` | int_metry_ctverecni | **Plocha kanceláří**
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_druh_prostor` | select | **Druh prostor**
&nbsp; | 1 | Kanceláře
&nbsp; | 2 | Obchodní
&nbsp; | 3 | Skladovací
&nbsp; | 4 | Jiné
&nbsp; | 5 | Výrobní
`nemovitost_pocet_mist` | int | **Počet parkovacích míst**
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_vlastnictvi` | select | **Vlastnictví**
&nbsp; | 1 | Osobní
&nbsp; | 2 | Družstevní
&nbsp; | 4 | Obecní
&nbsp; | 5 | Státní
&nbsp; | 6 | U majitele
&nbsp; | 3 | Jiný druh
&nbsp; | 7 | ~~Jiné~~
`nemovitost_plocha_nejmensi` | int_metry_ctverecni | **Plocha nejmenší**
`nemovitost_plocha_nejvetsi` | int_metry_ctverecni | **Plocha největší**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_plocha_uzitna_podkrovi` | int_metry_ctverecni | **Užitná plocha v podkroví**
`nemovitost_plocha_uzitna_prizemi` | int_metry_ctverecni | **Užitná plocha v přízemí**
`nemovitost_plocha_skladu` | int_metry_ctverecni | **Plocha skladů**
`nemovitost_balkon` | ano/ne + plocha | **Balkon**
`nemovitost_terasa` | ano/ne + plocha | **Terasa**
`nemovitost_plocha_dilna` | int_metry_ctverecni | **Dílna**
`nemovitost_podlazi_cislo` | int | **Číslo podlaží v domě**
`nemovitost_prodej_vcelku` | select | **Prodej vcelku**
&nbsp; | 1 | Prodej vcelku
&nbsp; | 2 | Prodej po částech
`nemovitost_pocet_kancelari` | int | **Počet kanceláří**
`nemovitost_pocet_podlazi_pod_zemi` | int | **Počet podlaží pod zemí**
`nemovitost_dalsi_nebytove_prostory` | multicheckbox | **Další nebytové prostory**
&nbsp; | 0 | Garáž
&nbsp; | 1 | Dvojgaráž
&nbsp; | 2 | Přístřešek
`nemovitost_datum_nastehovani` | date | **K nastěhování**
`nemovitost_rok_rekonstrukce` | int | **Rok rekonstrukce**
`nemovitost_rok_kolaudace` | int | **Rok kolaudace**
`nemovitost_rok_vystavby` | int | **Rok výstavby**
`nemovitost_vybaveno` | ano/ne/? | **Vybaveno**
`nemovitost_vybaveno_popis` | memo | **Popis vybavení**
`nemovitost_vybaveni_kancelari` | ano/ne/? | **Vybavení kanceláří**
`nemovitost_vybaveni_kancelari_popis` | memo | **Vybavení kanceláří popis**
`nemovitost_socialni_zarizeni` | checkbox | **Sociální zařízení**
`nemovitost_socialni_zarizeni_popis` | memo | **Sociální zařízení popis**
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_komunikace` | select | **Komunikace**
&nbsp; | 1 | Betonová
&nbsp; | 2 | Dlážděná
&nbsp; | 3 | Asfaltová
&nbsp; | 4 | Neupravená
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Komerční objekty {#komercni-objekty}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_ucel_budovy` | select | **Účel budovy**
&nbsp; | 1 | Sklad
&nbsp; | 2 | Výroba
&nbsp; | 3 | Obchodní centrum
&nbsp; | 4 | Nákupní středisko
&nbsp; | 5 | Průmyslový areál
&nbsp; | 7 | Administrativní budova
&nbsp; | 6 | Jiný
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_pocet_mist` | int | **Počet parkovacích míst**
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`nemovitost_plocha_celkova` | int_metry_ctverecni | **Celková plocha**
`nemovitost_plocha_vyrobni` | int_metry_ctverecni | **Výrobní plocha**
`nemovitost_plocha_provozni` | int_metry_ctverecni | **Provozní plocha**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_obestavena` | int_metry_ctverecni | **Obestavěný prostor**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_plocha_vnejsich_komunikaci` | int_metry_ctverecni | **Plocha vnějších komunikací**
`nemovitost_plocha_skladu` | int_metry_ctverecni | **Plocha skladů**
`nemovitost_plocha_obchodni` | int_metry_ctverecni | **Obchodní plocha**
`nemovitost_balkon` | ano/ne + plocha | **Balkon**
`nemovitost_pocet_podlazi_pod_zemi` | int | **Počet podlaží pod zemí**
`nemovitost_datum_nastehovani` | date | **K nastěhování**
`nemovitost_rok_rekonstrukce` | int | **Rok rekonstrukce**
`nemovitost_rok_kolaudace` | int | **Rok kolaudace**
`nemovitost_rok_vystavby` | int | **Rok výstavby**
`nemovitost_vybaveno` | ano/ne/? | **Vybaveno**
`nemovitost_vybaveno_popis` | memo | **Popis vybavení**
`nemovitost_vybaveni_kancelari` | ano/ne/? | **Vybavení kanceláří**
`nemovitost_vybaveni_kancelari_popis` | memo | **Vybavení kanceláří popis**
`nemovitost_socialni_zarizeni` | checkbox | **Sociální zařízení**
`nemovitost_socialni_zarizeni_popis` | memo | **Sociální zařízení popis**
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Historické objekty {#historicke-objekty}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_pocet_pokoju` | select | **Počet pokojů**
&nbsp; | 1 | 1 pokoj
&nbsp; | 2 | 2 pokoje
&nbsp; | 3 | 3 pokoje
&nbsp; | 4 | 4 pokoje
&nbsp; | 5 | 5 a více pokojů
&nbsp; | 6 | Atypický
`nemovitost_pocet_mist` | int | **Počet parkovacích míst**
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`nemovitost_sklep` | ano/ne + plocha | **Sklep**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_plocha_celkova` | int_metry_ctverecni | **Celková plocha**
`nemovitost_plocha_obchodni` | int_metry_ctverecni | **Obchodní plocha**
`nemovitost_plocha_kancelari` | int_metry_ctverecni | **Plocha kanceláří**
`nemovitost_plocha_dilny` | int_metry_ctverecni | **Dílny a provozovny**
`nemovitost_plocha_dalsi_nebytove_prostory` | int_metry_ctverecni | **Další nebytové prostory**
`nemovitost_plocha_zahrada` | int_metry_ctverecni | **Plocha zahrady**
`nemovitost_plocha_dalsi_zelene` | int_metry_ctverecni | **Další zelené plochy**
`nemovitost_plocha_vnejsich_komunikaci` | int_metry_ctverecni | **Plocha vnějších komunikací**
`nemovitost_bazen` | ano/ne + plocha | **Bazén**
`nemovitost_balkon` | ano/ne + plocha | **Balkon**
`nemovitost_terasa` | ano/ne + plocha | **Terasa**
`nemovitost_garaz` | ano/ne + plocha | **Garáž**
`nemovitost_poloha_objektu` | select | **Poloha objektu**
&nbsp; | 1 | Řadový
&nbsp; | 2 | Rohový
&nbsp; | 3 | V bloku
&nbsp; | 4 | Samostatný
`nemovitost_bytu_celkem` | int | **Počet bytů celkem**
`nemovitost_pocet_bytu_volnych` | int | **Počet bytů volných**
`nemovitost_pocet_kancelari` | int | **Počet kanceláří**
`nemovitost_pocet_obchodu` | int | **Počet obchodů**
`nemovitost_pocet_podlazi_pod_zemi` | int | **Počet podlaží pod zemí**
`nemovitost_stromy` | ano/ne/? | **Stromy**
`nemovitost_datum_nastehovani` | date | **K nastěhování**
`nemovitost_rok_rekonstrukce` | int | **Rok rekonstrukce**
`nemovitost_rok_kolaudace` | int | **Rok kolaudace**
`nemovitost_rok_vystavby` | int | **Rok výstavby**
`nemovitost_vybaveno` | ano/ne/? | **Vybaveno**
`nemovitost_vybaveno_popis` | memo | **Popis vybavení**
`nemovitost_dalsi_nebytove_prostory` | multicheckbox | **Další nebytové prostory**
&nbsp; | 0 | Garáž
&nbsp; | 1 | Dvojgaráž
&nbsp; | 2 | Přístřešek
`nemovitost_ostatni` | multicheckbox | **Ostatní**
&nbsp; | 0 | Plot
&nbsp; | 1 | Bezbariérový přístup
&nbsp; | 2 | Bazén
&nbsp; | 3 | Garáž
&nbsp; | 4 | Výtah
&nbsp; | 5 | Parkoviště
&nbsp; | 6 | Ostraha
&nbsp; | 7 | Ostraha - PCO
&nbsp; | 8 | Recepce
&nbsp; | 9 | Vrátnice
&nbsp; | 10 | Stravování
&nbsp; | 11 | Sociální zařízení
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_sirka` | float | **Šířka**
`nemovitost_delka` | float | **Délka**
`nemovitost_vyska` | float | **Výška**
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Hotely, penziony a restaurace {#hotely-penziony-a-restaurace}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_typ_zarizeni` | select | **Typ zařízení**
&nbsp; | 1 | Hotel
&nbsp; | 2 | Penzion
&nbsp; | 3 | Restaurace
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`pocet_mist_k_parkovani` | int | **Počet míst k parkování**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_plocha_celkova` | int_metry_ctverecni | **Celková plocha**
`nemovitost_plocha_obchodni` | int_metry_ctverecni | **Obchodní plocha**
`nemovitost_plocha_kancelari` | int_metry_ctverecni | **Plocha kanceláří**
`nemovitost_plocha_dilny` | int_metry_ctverecni | **Dílny a provozovny**
`nemovitost_plocha_dalsi_nebytove_prostory` | int_metry_ctverecni | **Další nebytové prostory**
`nemovitost_plocha_zahrada` | int_metry_ctverecni | **Plocha zahrady**
`nemovitost_plocha_dalsi_zelene` | int_metry_ctverecni | **Další zelené plochy**
`nemovitost_plocha_vnejsich_komunikaci` | int_metry_ctverecni | **Plocha vnějších komunikací**
`nemovitost_bazen` | ano/ne + plocha | **Bazén**
`nemovitost_balkon` | ano/ne + plocha | **Balkon**
`nemovitost_terasa` | ano/ne + plocha | **Terasa**
`nemovitost_garaz` | ano/ne + plocha | **Garáž**
`nemovitost_poloha_objektu` | select | **Poloha objektu**
&nbsp; | 1 | Řadový
&nbsp; | 2 | Rohový
&nbsp; | 3 | V bloku
&nbsp; | 4 | Samostatný
`nemovitost_bytu_celkem` | int | **Počet bytů celkem**
`nemovitost_pocet_bytu_volnych` | int | **Počet bytů volných**
`nemovitost_pocet_kancelari` | int | **Počet kanceláří**
`nemovitost_pocet_obchodu` | int | **Počet obchodů**
`nemovitost_pocet_podlazi_pod_zemi` | int | **Počet podlaží pod zemí**
`nemovitost_stromy` | ano/ne/? | **Stromy**
`nemovitost_ostatni_nebytove_prosotry_popis` | memo | **Popis ostatních nebytových prostor**
`nemovitost_datum_nastehovani` | date | **K nastěhování**
`nemovitost_rok_rekonstrukce` | int | **Rok rekonstrukce**
`nemovitost_rok_kolaudace` | int | **Rok kolaudace**
`nemovitost_rok_vystavby` | int | **Rok výstavby**
`nemovitost_vybaveno` | ano/ne/? | **Vybaveno**
`nemovitost_vybaveno_popis` | memo | **Popis vybavení**
`nemovitost_dalsi_nebytove_prostory` | multicheckbox | **Další nebytové prostory**
&nbsp; | 0 | Garáž
&nbsp; | 1 | Dvojgaráž
&nbsp; | 2 | Přístřešek
`nemovitost_pocet_volnych_kancelari` | int | **Počet volných kanceláří**
`nemovitost_ostatni` | multicheckbox | **Ostatní**
&nbsp; | 0 | Plot
&nbsp; | 1 | Bezbariérový přístup
&nbsp; | 2 | Bazén
&nbsp; | 3 | Garáž
&nbsp; | 4 | Výtah
&nbsp; | 5 | Parkoviště
&nbsp; | 6 | Ostraha
&nbsp; | 7 | Ostraha - PCO
&nbsp; | 8 | Recepce
&nbsp; | 9 | Vrátnice
&nbsp; | 10 | Stravování
&nbsp; | 11 | Sociální zařízení
`nemovitost_umisteni_objektu` | select | **Umístění objektu**
&nbsp; | 1 | Centrum obce
&nbsp; | 2 | Klidná část obce
&nbsp; | 3 | Rušná část obce
&nbsp; | 4 | Okraj obce
&nbsp; | 5 | Sídliště
&nbsp; | 6 | Polosamota
&nbsp; | 7 | Samota
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_sirka` | float | **Šířka**
`nemovitost_delka` | float | **Délka**
`nemovitost_vyska` | float | **Výška**
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

### Nájemní domy {#najemni-domy}

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`nemovitost_druh_objektu` | select | **Druh objektu**
&nbsp; | 1 | Dřevěná
&nbsp; | 2 | Cihlová
&nbsp; | 3 | Kamenná
&nbsp; | 4 | Montovaná
&nbsp; | 5 | Panelová
&nbsp; | 6 | Skeletová
&nbsp; | 7 | Smíšená
`nemovitost_stav_objektu` | select | **Stav objektu**
&nbsp; | 1 | Velmi dobrý
&nbsp; | 2 | Dobrý
&nbsp; | 3 | Špatný
&nbsp; | 4 | Ve výstavbě (hrubá stavba)
&nbsp; | 5 | Projekt
&nbsp; | 6 | Novostavba
&nbsp; | 7 | Určený k demolici
&nbsp; | 8 | Před rekonstrukcí
&nbsp; | 9 | Po rekonstrukci
`nemovitost_pocet_podlazi` | int | **Počet podlaží objektu**
`pocet_mist_k_parkovani` | int | **Počet míst k parkování**
`nemovitost_plocha_zastavena` | int_metry_ctverecni | **Zastavěná plocha**
`nemovitost_plocha_uzitna` | int_metry_ctverecni | **Užitná plocha**
`nemovitost_plocha_parcely` | int_metry_ctverecni | **Plocha parcely**
`nemovitost_typ_domu` | select | **Typ domu**
&nbsp; | 1 | Přízemní
&nbsp; | 2 | Patrový
`nemovitost_garaz` | ano/ne + plocha | **Garáž**
`nemovitost_energeticky_stitek` | select | **Energetická náročnost budovy**
&nbsp; | 0 | není k dispozici
&nbsp; | 1 | A
&nbsp; | 2 | B
&nbsp; | 3 | C
&nbsp; | 4 | D
&nbsp; | 5 | E
&nbsp; | 6 | F
&nbsp; | 7 | G
`nemovitost_energeticky_stitek_vyhlaska` | select | **podle vyhlášky**
&nbsp; | 2 | 78/2013 Sb.
&nbsp; | 1 | 148/2007 Sb.
`nemovitost_merna_rocni_spotreba` | float | **Měrná vypočtená roční spotřeba energie v kWh/m²/rok**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

[zpět na obsah](#TOC)

## Projekt

Pole | Typ/Hodnota | Popis
:----|------------:|:-----
`projekt_nazev` | short_text | **Název projektu**
`projekt_zakladni_popis` | memo | **Základní popis**
`projekt_popis` | memo | **Popis projektu**
`projekt_lokalita` | memo | **Popis lokality**
`etapy` | memo | **Počet a popis etap projektu**
`projekt_aktivni` | ano/ne | **Aktivní**
`projekt_psc` | short_text | **PSČ**
`developer_nazev` | short_text | **Název společnosti**
`developer_ulice` | short_text | **Ulice**
`developer_mesto` | short_text | **Město**
`developer_psc` | int | **PSČ**
`developer_email` | short_text | **Email**
`developer_telefon` | short_text | **Telefon**
`developer_fax` | short_text | **Fax**
`developer_www` | short_text | **WWW**
`developer_stat` | short_text | **Stát**
`investor_nazev` | short_text | **Název společnosti**
`investor_ulice` | short_text | **Ulice**
`investor_mesto` | short_text | **Město**
`investor_psc` | int | **PSČ**
`investor_email` | short_text | **Email**
`investor_telefon` | short_text | **Telefon**
`investor_fax` | short_text | **Fax**
`investor_www` | short_text | **WWW**
`investor_stat` | short_text | **Stát**
`zakazka_typ_smlouvy` | select | **Typ smlouvy**
&nbsp; | 10 | exkluzivní
&nbsp; | 20 | neexkluzivní
&nbsp; | 30 | coexkluzivní
&nbsp; | 40 | bez smlouvy
`zakladni_vklad` | int | **Základní vklad**
`hypoteka` | ano/ne | **Hypotéka**
`hypotecni_ustav` | short_text | **Hypoteční ústav**
`hypoteka_procenta` | float | **Hypotéka - procenta**
`stavebni_sporeni_procenta` | float | **Stavební spoření - procenta**
`projekt_ov` | ano/ne | **Možnost převedení do OV**
`projekt_zahajeni_stavby` | date | **Datum zahájení stavby**
`projekt_zahajeni_prodeje` | date | **Datum zahájení prodeje**
`projekt_dokonceni_hrube_stavby` | date | **Dokončení hrubé stavby**
`projekt_ukonceni_stavby` | date | **Datum ukončení stavby**
`projekt_k_nastehovani` | date | **K nastěhování**
`projekt_uzemni_rozhodnuti` | date | **Územní rozhodnutí**
`projekt_stavebni_povoleni` | date | **Stavební povolení**
`projekt_kolaudace` | date | **Kolaudace**
`pocet_objektu` | int | **Celkový počet objektů v projektu**
`pocet_bytu` | int | **Byty - počet**
`byty_min_plocha` | int_metry_ctverecni | **Byty - Plocha nejmenšího**
`byty_max_plocha` | int_metry_ctverecni | **Byty - Plocha největšího**
`byty_min_cena` | int | **Byty - minimální cena**
`byty_max_cena` | int | **Byty - maximální cena**
`pocet_kancelari` | int | **Kanceláře - počet**
`kancelare_min_plocha` | int_metry_ctverecni | **Kanceláře - nejměnší**
`kancelare_max_plocha` | int_metry_ctverecni | **Kanceláře - největší **
`kancelare_min_cena` | int | **Kanceláře - minimální cena**
`kancelare_max_cena` | int | **Kanceláře - maximální cena**
`pocet_domu` | int | **Domy - počet**
`domy_min_plocha` | int_metry_ctverecni | **Domy - nejmenší obestavený prostor**
`domy_max_plocha` | int_metry_ctverecni | **Domy - největší obestavený prostor**
`domy_min_cena` | int | **Domy - minimální cena**
`domy_max_cena` | int | **Domy - maximální cena**
`komercni_plochy_pocet` | int | **Komerční plochy - počet**
`komercni_plochy_min_plocha` | int_metry_ctverecni | **Komerční plochy - nejmenší**
`komercni_plochy_max_plocha` | int_metry_ctverecni | **Komerční plochy - největší**
`ostatni_plochy` | short_text | **Ostatní plochy**
`garaze` | ano/ne | **Jsou v objektu garáže**
`pocet_mist_k_parkovani` | int | **Počet míst k parkování**
`zaklady` | short_text | **Základy**
`stropy` | short_text | **Stropy**
`strecha` | short_text | **Střecha**
`krytina` | short_text | **Krytina**
`klempirina` | short_text | **Klempířina**
`vnitrni_omitky` | short_text | **Vnitřní omítky**
`fasadni_omitky` | short_text | **Fasádní omítky**
`vnejsi_obklady` | short_text | **Vnější obklady**
`vnitrni_obklady` | short_text | **Vnitřní obklady**
`schody` | short_text | **Schody**
`dvere` | short_text | **Dveře**
`okna` | short_text | **Okna**
`podlahy` | short_text | **Podlahy**
`kuchynska_linka` | ano/ne | **Kuchyňská linka v ceně**
`nemovitost_topeni` | multicheckbox | **Topení**
&nbsp; | 0 | Lokální - plynové
&nbsp; | 1 | Lokální - tuhá paliva
&nbsp; | 2 | Lokální - elektrické
&nbsp; | 3 | Ústřední - plynové
&nbsp; | 4 | Ústřední - tuhá paliva
&nbsp; | 5 | Ústřední - elektrické
&nbsp; | 6 | Ústřední - dálkové
&nbsp; | 7 | Jiné
`nemovitost_elektrina` | multicheckbox | **Elektřina**
&nbsp; | 0 | 120 V
&nbsp; | 1 | 230 V
&nbsp; | 2 | ~~380 V~~
&nbsp; | 3 | 400 V
`nemovitost_voda` | multicheckbox | **Voda**
&nbsp; | 0 | Zdroj pro celý objekt
&nbsp; | 1 | Dálkový rozvod
&nbsp; | 2 | Rozvod studené a teplé vody
`nemovitost_odpad` | multicheckbox | **Odpad**
&nbsp; | 0 | Kanalizace
&nbsp; | 1 | ČOV pro celý objekt
`nemovitost_plyn` | multicheckbox | **Plyn**
&nbsp; | 0 | Individuální
&nbsp; | 1 | Plynovod
`nemovitost_doprava` | multicheckbox | **Doprava**
&nbsp; | 0 | Vlak
&nbsp; | 1 | Dálnice
&nbsp; | 2 | Silnice
&nbsp; | 3 | MHD
&nbsp; | 4 | Autobus
`nemovitost_telekomunikace` | multicheckbox | **Telekomunikace**
&nbsp; | 0 | Telefon
&nbsp; | 1 | Internet
`nemovitost_ostatni_rozvody` | multicheckbox | **Ostatní rozvody**
&nbsp; | 0 | Satelit
&nbsp; | 1 | Kabelová televize
&nbsp; | 2 | Kabelové rozvody
&nbsp; | 3 | Ostatní rozvody

