<?php
namespace Dalten\Import;
/**
 * Jednoduchá objektová obálka pro vytahování dat HTTP požadavku.
 */
class HttpRequest
{
	protected static $currentRequest;

	protected $_method = '';
	protected $_body = '';
	protected $_POST = array();
	protected $_GET = array();

	/**
	 * Vytvoří obálku HTTP požadavku z Globálních proměnných.
	 *
	 * @return \Dalten\Import\HttpRequest Obálka požadavku.
	 */
	public static function createFromGlobals()
	{
		// singleton - při opakovaném volání vracíme stejný objekt
		if (self::$currentRequest) {
			return self::$currentRequest;
		}

		$self = new self();
		$self->_body = file_get_contents('php://input');
		$self->_method = $_SERVER['REQUEST_METHOD'];
		$self->_GET = $_GET;
		$self->_POST = $_POST;
		self::$currentRequest = $self;

		return $self;
	}

	/**
	 * @return bool Je požadavek metodou GET?
	 */
	public function isGet()
	{
		return $this->_method == 'GET';
	}

	/**
	 * @return bool Je požadavek metodou POST?
	 */
	public function isPost()
	{
		return $this->_method == 'POST';
	}

	/**
	 * Vrátí hodnotu GET parametru požadavku.
	 *
	 * @param string $key     Název parametru.
	 * @param null   $default Výchozí hodnota při nezadaném parametru. Jinak se použije NULL.
	 *
	 * @return null|mixed Hodnota parametru nebo NULL.
	 */
	public function get($key, $default = null)
	{
		if (isset($this->_GET[$key])) {
			return $this->_GET[$key];
		}

		return $default;
	}

	/**
	 * Vrátí hodnotu POST parametru požadavku.
	 *
	 * @param string $key     Název parametru.
	 * @param null   $default Výchozí hodnota při nezadaném parametru. Jinak se použije NULL.
	 *
	 * @return null|mixed Hodnota parametru nebo NULL.
	 */
	public function post($key, $default = null)
	{
		if (isset($this->_POST[$key])) {
			return $this->_POST[$key];
		}

		return $default;
	}

	/**
	 * Vrací tělo požadavku.
	 *
	 * @return string Tělo požadavku (v něm bývá samotné XML-RPC).
	 */
	public function getBody()
	{
		return $this->_body;
	}
}