# Metody

Všechny metody (s vyjímkou metody `version`) příjímají jeden parametr typu struktura.

Všechny metody vrací strukturu s členem `status`, jehož hodnota je v případě úspěchu volání metody rovna `200`.

Všechny metody (s výjimkou metod `version`, `getHash` a `login`) vyžadují přihlášení.

V dokumentaci jsou vstupní a výstupní struktury znázorněny pomocí seznamů. Například popisu struktury:

>  * `status` - status kód, v případě úspěchu 200
>  * `statusMessage` - upřesňující chybová hláška
>  * `output` - výstup metody, při úspěchu obsahuje člen
>     * `version` - verze importního rozhraní

odpovídají následující data vyjádřená jako JSON:

```json
{
    "status": 200,
    "statusMessage": "OK",
    "output" : {
        "version": "1.0"
    }
}
```

## Zjištění verze rozhraní {#zjisteni-verze-rozhrani}

### `version`

Vrací verzi importního rozhraní na webu.

Výstup:

 * `status` - status kód, v případě úspěchu 200
 * `statusMessage` - upřesňující chybová hláška
 * `output` - výstup metody, při úspěchu obsahuje člen
    * `version` - verze importního rozhraní

## Přihlašování {#prihlasovani}

Nejprve se volá metoda `getHash`, která vrátí `session_id` a `hash`. Tyto údaje se použijí k přihlášení pomocí
metody `login`. Při volání dalších metod je nutné předávat `session_id` sloužící k ověření přihlášení.

### `getHash`

Vygeneruje nové `session_id` a `hash` sloužící k přihlášení.

Vstupní parametr:

* `name` - uživatelské jméno k exportnímu účtu

Výstup:

 * `status` - status kód, v případě úspěchu 200
 * `statusMessage` - upřesňující chybová hláška
 * `output` - výstup metody, při úspěchu obsahuje členy
    * `session_id` a
    * `hash`

### `login`

Provede přihlášení.

Vstupní parametr:

* `session_id` - identifikátor přihlášení
* `password` - heslo, posílá se zakódované podle vzorce `md5($heslo . $hash);`, kde `$heslo` je heslo k exportnímu účtu
  a `$hash` je hash získaný z předchozího volání metody `getHash`

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

### `logout`

Provede odhlášení.

Vstupní parametr:

* `session_id` - identifikátor přihlášení

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

## Správa nabídek {#sprava-nabidek}

### `addNabidka`

Nahraje nabídku na web. Pokud nabídka s daným ID existuje, bude aktualizována.

Při nahrávání nabídky dochází ke [stahování obrázků](#sprava-fotografii) z iRestu.

Vstupní parametr:

 * `session_id` - identifikátor přihlášení
 * `nabidka` - data nabídky jako struktura, pro formát viz sekci [struktura dat](#struktura-dat). Navíc obsahuje členy:
    * `id_uzivatel` celé číslo ID makléře nabídky
    * `priloha` pole s informacemi o obrázcích nabídky
    * `dokumenty` pole s informacemi o přiložených dokumentech exportovaných na web.

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

### `delNabidka`

Smaže nabídku z webu.

Vstupní parametr:

* `session_id` - identifikátor přihlášení
* `nabidka_id` - ID nabídky kterou chceme smazat

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

### `listNabidka`

Vypíše všechny nabídky vyexportované na web.

Vstupní parametr:

* `session_id` - identifikátor přihlášení

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška
* `output` - seznam ID nabídek vyexportovaných na web jako řetězec, jednotlivé položky jsou odděleny znakem `|`
* `count` - celkový počet nabídek vyexportovaných na web

## Správa makléřů {#sprava-makleru}

### `addUzivatel`

Nahraje makléře na web. Pokud makléř s daným ID existuje, bude aktualizován.

Při nahrávání makléře se stahuje jeho fotografie.

Vstupní parametr:

 * `session_id` - identifikátor přihlášení
 * `uzivatel` - data makléře jako struktura

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

Struktura makléře obsahuje následující údaje:

Člen | Popis
:---|:---
`id` | ID makléře
`id_pobocka` | ID pobočky pod kterou spadá makléř
`id_uroven` | ID uživatelské úrovně makléře
`email` | exportovaný e-mail
`telefon` | exportovaný telefon
`pevna_linka` | pevná linka
`uzivatel_os_jmeno` | křestní jméno makléře
`uzivatel_os_prostredni_jmeno` | prostřední jméno makléře
`uzivatel_os_prijmeni` | příjmení makléře
`uzivatel_tituly_pred_jmenem` | tituly před jménem
`uzivatel_tituly_za_jmenem`  | tituly za jménem
`foto` | relativní URL fotografie makléře
`moto` | motto makléře
`makler_ico` | IČO makléře
`datova_schranka_id` | ID datové schránky makléře

Pro některé klienty byly rovněž implementovány jiné položky databáze makléřů, tyto zde zdokumentovány nejsou.

### `delUzivatel`

Smaže makléře z webu.

Vstupní parametr:

 * `session_id` - identifikátor přihlášení
 * `uzivatel_id` - ID makléře

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

### `listUzivatel`

Vypíše makléře vyexportované na web.

Vstupní parametr:

* `session_id` - identifikátor přihlášení

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška
* `output` - pole IDček makléřů vyexportovaných na web

## Správa firem {#sprava-firem}

**POZOR!** Tato funkce se používá jen pro některé projekty. Ve výchozím nastavení iRest firmy neexportuje.

### `addFirma`

Nahraje firmu na web. Pokud firma s daným ID existuje, bude aktualizována.

Vstupní parametr:

 * `session_id` - identifikátor přihlášení
 * `firma` - data firmy jako struktura

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

Struktura firmy se liší projekt od projektu, tedy není součástí této dokumentace.

### `delFirma`

Smaže firmu z webu.

Vstupní parametr:

 * `session_id` - identifikátor přihlášení
 * `firma_id` - ID firmy

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

### `listFirma`

Vypíše firmy vyexportované na web.

Vstupní parametr:

* `session_id` - identifikátor přihlášení

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška
* `output` - pole IDček firem vyexportovaných na web

## Správa developerských projektů {#sprava-developerskych-projektu}

**POZOR!** Tuto funkcionalitu mají aktivovanou jenom některé firmy.

V původní verzi iRestu se projekty synchronizovaly automaticky - iRest si pomocí  volání metody `listProjekt` nechal vypsat projekty přítomné na webu. Chybějící pak vyexportoval pomocí metody `addProjekt` a přebývající smazal metodou `delProjekt`.

### `addProjekt`

Nahraje projekt na web. Pokud projekt s daným ID existuje, bude aktualizován.

Při nahrávání projektu dochází ke [stahování obrázků](#sprava-fotografii) z iRestu.

Vstupní parametr:

 * `session_id` - identifikátor přihlášení
 * `projekt` - data projektu jako struktura, pro formát viz sekci [struktura dat](#struktura-dat). Navíc obsahuje členy:
    * `id_uzivatel` celé číslo ID makléře projektu
    * `priloha` pole s informacemi o obrázcích projektu

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

### `delProjekt`

Smaže projekt z webu.

Vstupní parametr:

* `session_id` - identifikátor přihlášení
* `projekt_id` - ID projektu který chceme smazat

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

### `listProjekt`

Vypíše všechny projekty vyexportované na web.

Vstupní parametr:

* `session_id` - identifikátor přihlášení

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška
* `output` - seznam ID projektů vyexportovaných na web jako řetězec, jednotlivé položky jsou odděleny znakem `|`
* `count` - celkový počet projektů vyexportovaných na web

## Správa aktualit {#sprava-aktualit}

### `addAktuality`

Nahraje aktualitu na web. Pokud aktualita s daným ID existuje, bude její text aktualizován.

Vstupní parametr:

 * `session_id` - identifikátor přihlášení
 * `aktualita` - data aktuality jako struktura

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

Struktura aktuality obsahuje následující údaje:

Člen | Popis
:---|:---
`id` | ID makléře
`aktualita_datum` | datum aktuality (jako řetězec ve formátu `YYYY-MM-DD`)
`aktualita_titulek` | titulek aktuality
`aktualita_text` | text aktuality

### `delAktuality`

Smaže aktualitu z webu.

Vstupní parametr:

* `session_id` - identifikátor přihlášení
* `aktualita_id` - ID aktuality kterou chceme smazat

Výstup:

* `status` - status kód, v případě úspěchu 200
* `statusMessage` - upřesňující chybová hláška

## Správa fotografií (příloh) {#sprava-fotografii}

Ka nabídkám a projektům je možné náhrát fotografie. Z iRestu se posílá pole `priloha`, obsahující informace o
přiložených fotografiích.

Pole `priloha` je pole struktur (jedna na každou fotografii) s následujícími členy:

 - `id_parent` - ID nadřazené položky (nabídky/projektu)
 - `typ_parent` - 1 = nabídka, 2 = projekt
 - `typ_prilohy` - 1 = fotografie, 2 = dokumenty
 - `soubor` - relativní cesta k souboru, začíná v kořenovém adresáři a následuje adresář `data`

Při volání metod `addNabidka` a `addProjekt` pak dochází k jejich stahování z iRestu. Stahování fotografií provádí
importní knihovna na straně webu.

K mazání fotek dochází při volání metod `delNabidka` a `delProjekt`, což opět provádí importní knihovna na straně webu.

## Dodatky

Pro úplnost ještě zmiňuji úpravy, které jsme do exportní knihovny zapracovali pouze pro některé klienty:

- správa referencí makléřů pomocí metod `addReferenceUzivatele` a `delReferenceUzivatele`
- nahrávání PDF půdorysů nemovitostí pomocí pole `nemovitost_pudorys_priloha` u nabídek
- nahrávání jiných dokumentů k nabídce pomocí pole `dokumenty` (funguje obdobně jako posílání fotografií nabídek)
- posílání položek `dalsi_pozice` a `oceneni` u uživatele
