<?php
/**
 * Jenreality nepodporujou nulové hodnoty u multicheckboxů, takže je potřeba je odstranit. Zároveň chtějí RUIAN místo UIR.
 */
class Dalten_Export_Jenreality extends Dalten_Export_Sreality
{
    protected function _convert(array $convertedValues, array $originalvalues, $entityName)
    {
        $convertedValues = parent::_convert($convertedValues, $originalvalues, $entityName);

        if (($entityName === 'listing') or ($entityName == 'project')) {
            if (isset($convertedValues['locality_uir_level']) && $convertedValues['locality_uir']) {
                $convertedValues['locality_ruian_level'] = $convertedValues['locality_uir_level'];
                $convertedValues['locality_ruian'] = $convertedValues['locality_uir'];
                unset($convertedValues['locality_uir_level'], $convertedValues['locality_uir']);
            } else {
                $convertedValues['locality_eurostat'] = $originalvalues['nemovitost_uir_stat'];
                $convertedValues['locality_city'] = $originalvalues['nemovitost_uir_obec_text'];
                $convertedValues['locality_region'] = $originalvalues['nemovitost_uir_kraj_text'];
                $convertedValues['locality_district'] = $originalvalues['nemovitost_uir_okres_text'];
            }

            if ($this->_getYoutubeId($originalvalues['nemovitost_video_prohlidka'])) {
                $convertedValues['video_youtube'] = $this->_getYoutubeId($originalvalues['nemovitost_video_prohlidka']);
            }

            if ($this->_getYoutubeId($originalvalues['nemovitost_virtualni_prohlidka'])) {
                $convertedValues['video_youtube'] = $this->_getYoutubeId($originalvalues['nemovitost_virtualni_prohlidka']);
            }

            if ($this->_getMatterportId($originalvalues['nemovitost_virtualni_prohlidka'])) {
                $convertedValues['matterport_url'] = $originalvalues['nemovitost_virtualni_prohlidka'];
            }
        }

        return $convertedValues;
    }

    public function convertEntityValues($name, array $originalValues, $config)
    {
        $values = parent::convertEntityValues($name, $originalValues, $config);

        foreach ($values as $key => $value) {
            if (is_array($value)) {
                // odstraníme hodnotu 0
                $values[$key] = array_values(array_diff($value, ['0']));
                // když je pak celý pole prázdné, tak ho odstraníme
                if (count($values[$key]) == 0) {
                    unset($values[$key]);
                }
            }
        }

        return $values;
    }

    /**
     * Vytáhne ID virtuální prohlíky Matterport.
     *
     * @param string $url Odkaz na YouTube.
     *
     * @return string
     */
    protected function _getMatterportId($url) {
        // https://my.matterport.com/show/?m=pGSH9wuaKZH
        $parsedUrl = parse_url($url);
        if ($parsedUrl['host']=='my.matterport.com' &&  trim($parsedUrl['path'],'/')=='show') {
            $parameters = array();
            parse_str($parsedUrl['query'], $parameters);
            if (!empty($parameters['m'])) {
                return $parameters['m'];
            }
        }
        return '';
    }

    /**
     * Vytáhne VIDEO_ID z odkazu na YouTube.
     *
     * @param string $url Odkaz na YouTube.
     *
     * @return string VIDEO_ID nebo prázdný string.
     */
    protected function _getYoutubeId($url) {
        if (empty($url)) {
            return '';
        }
        $parsedURL = parse_url($url);
        if (isset($parsedURL['host']) && 'youtu.be' == $parsedURL['host']) {
            $matches = array();
            preg_match('~/(.*)~', $parsedURL['path'], $matches);
            if (!empty($matches[1])) {
                return $matches[1];
            }
        } elseif ('www.youtube.com' == $parsedURL['host'] || 'youtube.com' == $parsedURL['host']) {
            $parameters = array();
            $matches = array();
            if (isset($parsedURL['query'])) {
                parse_str($parsedURL['query'], $parameters);
                if (!empty($parameters['v'])) {
                    return $parameters['v'];
                }
            } elseif (preg_match('~/shorts/((\w|-){11})~', $parsedURL['path'], $matches) !== false) {
                return $matches[1];
            }
        }

        return '';
    }

}
