<?php
/**
 * Jednoduchý logger, který vyechuje volání do konzole.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Backend
 */
class Dalten_Export_Api_Backend_Logger_HtmlEcho implements Dalten_Export_Api_Backend_Logger_LoggerInterface
{
	/**
	 * Zaloguje volání vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName Název volané metody.
	 * @param mixed  $data       Data se kterými je metoda volána.
	 */
	public function logRemoteCall($methodName, $data)
	{
		$isCli = php_sapi_name() == "cli";
		$eol = $isCli ? PHP_EOL : '<br/>'.PHP_EOL;
		echo 'METHOD CALL: ', $methodName, ' called @ ', date('j.n.Y H:i:s'), $eol;
		echo 'METHOD DATA: ', $eol, ($isCli ? print_r($data, true) : '<pre>'.htmlspecialchars(print_r($data, true))).'</pre>';
		echo PHP_EOL, '==========', $eol, $eol;
	}

	/**
	 * Zaloguje odpověď vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName  Název volané metody.
	 * @param mixed  $reponseData Odpověď serveru.
	 */
	public function logRemoteResponse($methodName, $reponseData)
	{
		$isCli = php_sapi_name() == "cli";
		$eol = $isCli ? PHP_EOL : '<br/>'.PHP_EOL;
		echo 'SERVER RESPONSE: ', $methodName, ' retrieved @ ', date('j.n.Y H:i:s'), $eol;
		echo 'RESPONSE DATA  :', $eol, ($isCli ? print_r($reponseData, true) : '<pre>'.htmlspecialchars(print_r($reponseData, true))).'</pre>';
		echo $eol, '==========', $eol, $eol;
	}
}