<?php
/**
 * Exportní api pro server Realcity.
 *
 * Nadstavba nad api Srealit, upravuje chování při exportu kategorie Malé objekty/Ostatní.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_RealCity extends Dalten_Export_Api_SrealityLike
{
    /**
     * {@inheritdoc}
     *
     * Akorát vždycky zahashuje heslo pomocí MD5.
     */
    public function openConnection($login, $password, $softwareKey = '', array $additionalParams = array())
    {
        $hash = $this->_backend->getHash($login);

        if (!isset($hash->status) ||  (isset($hash->status) && $hash->status != 200)) {
            return new Dalten_Export_Api_ServerResponse(
                false,
                isset($hash->status) ? $hash->status : 500,
                isset($hash->statusMessage) ? $hash->statusMessage : 'getHash failed.'
            );
        }

        $this->_sessionId = $hash->output->sessionId;
        $this->_hashKey = md5($password) . (string) $softwareKey;

        $response = $this->_backend->login($this->_getSessionId(false));

        return new Dalten_Export_Api_ServerResponse(
            isset($response->status) && $response->status == 200,
            isset($response->status) ? $response->status : 500,
            isset($response->statusMessage) ? $response->statusMessage : 'No response from server'
        );
    }

	/**
	 * {@inheritdoc}
	 */
	public function addListing(
		array $listingData, array $userData, array $images = array(), array $additionalParams = array()
	)
	{
		if ($listingData['nemovitost_typ']==11 && $listingData['nemovitost_typ_maleho_objektu']==2) {
			// Realcity nemají kategorii Malé objekty/Ostatní, změníme to tedy na Malé objekty/Garáž
			$listingData['nemovitost_typ_maleho_objektu'] = 1;
		}
		return parent::addListing($listingData, $userData, $images, $additionalParams);
	}

}
