<?php
/**
 * Export do formátu Hyperrealit.
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_Hyperreality extends Dalten_Export_AbstractExport
{
	/**
	 * Vrací je-li v poli $data zaškrnuté cokoliv z multicheckboxu $fieldName.
	 *
	 * @param array  $data      Pole s daty.
	 * @param string $fieldName Název políčka.
	 *
	 * @return bool Je to tak?
	 */
	private function _isAnyChecked(array $data, $fieldName) {
		if (isset($data[$fieldName])) {
			if (strpos($data[$fieldName], '1')===false) {
				return false;
			}
			return true;
		}
		return false;
	}

	/**
	 * Vrací je-li v poli $data zaškrnutá položka $fieldName.
	 *
	 * @param array  $data      Pole s daty.
	 * @param string $fieldName Název políčka.
	 *
	 * @return bool Je to tak?
	 */
	private function _isChecked(array $data, $fieldName) {
		if (isset($data[$fieldName])) {
			return ($data[$fieldName]==1);
		}
		return false;
	}

	/**
	 * Vrací je-li v poli $data zaškrtnuté pole $fieldName jako multicheckbox na hodnotě $value.
	 *
	 * @param array  $data      Pole s daty.
	 * @param string $fieldName Název políčka.
	 * @param int    $value     Pořadí zašktávátka.
	 *
	 * @return bool Je to tak?
	 */
	private function _isMultiChecked(array $data, $fieldName, $value) {
		if (isset($data[$fieldName])) {
			if (substr($data[$fieldName], $value, 1)==1) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Vybere hlavní plochu.
	 *
	 * @param array $convertedValues Převedené položky.
	 * @param array $originalvalues  Původní položky.
	 *
	 * @return null|float|int Hlavní plocha nebo null pokud ji nejde u tohoto typu najít.
	 */
	protected function _getHlavniPlocha(array $convertedValues, array $originalvalues)
	{
		$plochyTypu = array();
		$plochyTypu[2] = $plochyTypu[3] = $plochyTypu[4] = $plochyTypu[11] = 'nemovitost_plocha_celkova';
		$plochyTypu[1] = $plochyTypu[5] = $plochyTypu[6] = $plochyTypu[8] = $plochyTypu[7] = $plochyTypu[10]  = 'nemovitost_plocha_uzitna';
		$plochyTypu[9] = 'nemovitost_plocha_kancelari';
		$nazevPlochy = $plochyTypu[$originalvalues['nemovitost_typ']];
		if ($nazevPlochy && $originalvalues[$nazevPlochy]) {
			return $originalvalues[$nazevPlochy];
		}
		return null;
	}

	/**
	 * Vrací číselník na převod typů.
	 *
	 * @return array Číselník vykopírovaný ze starého exportu.
	 */
	function _getConversionTable()
	{
		// Tato převodní tabulka je prozatím vykopírovaná.
		$ciselnik = array();
		$ciselnik['typ'][1][0] = array(53,9 ); //Zemědělské objekty
		$ciselnik['typ'][2][1] = array(41,9 ); //Komerční objekty Sklad
		$ciselnik['typ'][2][2] = array(39,9 ); //Komerční objekty Výroba
		$ciselnik['typ'][2][3] = array(38,9 ); //Komerční objekty Obchodní centrum
		$ciselnik['typ'][2][4] = array(9 ); //Komerční objekty Nákupní středisko
		$ciselnik['typ'][2][5] = array(9 ); //Komerční objekty Průmyslový areál
		$ciselnik['typ'][2][6] = array(9 ); //Komerční objekty Jiný
		$ciselnik['typ'][2][7] = array(37,9 ); //Komerční objekty Administrativní budova
		$ciselnik['typ'][3][1] = array(109,13 ); //Pozemky Pro komerční výstavbu
		$ciselnik['typ'][3][2] = array(110,13);  //Pozemky Pro bydlení
		$ciselnik['typ'][3][3] = array(107,13 ); //Pozemky Zemědělská
		$ciselnik['typ'][3][4] = array(111,13 ); //Pozemky Les
		$ciselnik['typ'][3][5] = array(112,13 ); //Pozemky Trvalý travní porost
		$ciselnik['typ'][3][6] = array(55,13 ); //Pozemky Zahrada
		$ciselnik['typ'][3][7] = array(113,13 ); //Pozemky Ostatní

		$ciselnik['typ'][4][1][1] = array(87,6); //Byty Garsoniéra
		$ciselnik['typ'][4][2][1] = array(19,6); //Byty 1+kk
		$ciselnik['typ'][4][3][1] = array(21,6); //Byty 2+kk
		$ciselnik['typ'][4][4][1] = array(23,6); //Byty 3+kk
		$ciselnik['typ'][4][5][1] = array(25,6); //Byty 4+kk
		$ciselnik['typ'][4][6][1] = array(27,6); //Byty 5+kk
		$ciselnik['typ'][4][7][1] = array(27,6); //Byty 6+kk
		$ciselnik['typ'][4][8][1] = array(27,6); //Byty 7+kk
		$ciselnik['typ'][4][9][1] = array(20,6); //Byty 1+1
		$ciselnik['typ'][4][10][1] = array(22,6); //Byty 2+1
		$ciselnik['typ'][4][11][1] = array(24,6); //Byty 3+1
		$ciselnik['typ'][4][12][1] = array(26,6); //Byty 4+1
		$ciselnik['typ'][4][13][1] = array(27,6); //Byty 5+1
		$ciselnik['typ'][4][14][1] = array(27,6); //Byty 6+1
		$ciselnik['typ'][4][15][1] = array(27,6); //Byty 7+1
		$ciselnik['typ'][4][16][1] = array(6); //Byty Atypický
		$ciselnik['typ'][4][17][1] = array(6); //Byty Jiný

		$ciselnik['typ'][4][1][2] = array(88,7); //Byty Garsoniéra
		$ciselnik['typ'][4][2][2] = array(72,7); //Byty 1+kk
		$ciselnik['typ'][4][3][2] = array(74,7); //Byty 2+kk
		$ciselnik['typ'][4][4][2] = array(76,7); //Byty 3+kk
		$ciselnik['typ'][4][5][2] = array(78,7); //Byty 4+kk
		$ciselnik['typ'][4][6][2] = array(80,7); //Byty 5+kk
		$ciselnik['typ'][4][7][2] = array(80,7); //Byty 6+kk
		$ciselnik['typ'][4][8][2] = array(80,7); //Byty 7+kk
		$ciselnik['typ'][4][9][2] = array(73,7); //Byty 1+1
		$ciselnik['typ'][4][10][2] = array(75,7); //Byty 2+1
		$ciselnik['typ'][4][11][2] = array(77,7); //Byty 3+1
		$ciselnik['typ'][4][12][2] = array(79,7); //Byty 4+1
		$ciselnik['typ'][4][13][2] = array(80,7); //Byty 5+1
		$ciselnik['typ'][4][14][2] = array(80,7); //Byty 6+1
		$ciselnik['typ'][4][15][2] = array(80,7); //Byty 7+1
		$ciselnik['typ'][4][16][2] = array(7); //Byty Atypický
		$ciselnik['typ'][4][17][2] = array(7); //Byty Jiný
		$ciselnik['typ'][5][1] = array(108); //Historické objekty Dřevěná
		$ciselnik['typ'][5][2] = array(108); //Historické objekty Cihlová
		$ciselnik['typ'][5][3] = array(108); //Historické objekty Kamenná
		$ciselnik['typ'][5][4] = array(108); //Historické objekty Montovaná
		$ciselnik['typ'][5][5] = array(108); //Historické objekty Panelová
		$ciselnik['typ'][5][6] = array(108); //Historické objekty Skeletová
		$ciselnik['typ'][5][7] = array(108); //Historické objekty Smíšená
		$ciselnik['typ'][6][1] = array(48); //Domy a vily Řadový
		$ciselnik['typ'][6][2] = array(48); //Domy a vily Rohový
		$ciselnik['typ'][6][3] = array(48); //Domy a vily V bloku
		$ciselnik['typ'][6][4] = array(48); //Domy a vily Samostatný
		$ciselnik['typ'][7][1] = array(42,9); //Hotely, penziony a restaurace Hotel
		$ciselnik['typ'][7][2] = array(43,9); //Hotely, penziony a restaurace Penzion
		$ciselnik['typ'][7][3] = array(44,9); //Hotely, penziony a restaurace Restaurace
		$ciselnik['typ'][8][0] = array(17); //Nájemní domy
		$ciselnik['typ'][9][1] = array(37,9); //Komerční prostory Kanceláře
		$ciselnik['typ'][9][2] = array(38,9); //Komerční prostory Obchodní
		$ciselnik['typ'][9][3] = array(41,9); //Komerční prostory Skladovací
		$ciselnik['typ'][9][4] = array(9); //Komerční prostory Jiné
		$ciselnik['typ'][9][5] = array(39,9); //Komerční prostory Výrobní
		$ciselnik['typ'][10][1] = array(51); //Chaty a rekreační objekty Řadový
		$ciselnik['typ'][10][2] = array(51); //Chaty a rekreační objekty Rohový
		$ciselnik['typ'][10][3] = array(51); //Chaty a rekreační objekty V bloku
		$ciselnik['typ'][10][4] = array(51); //Chaty a rekreační objekty Samostatný
		$ciselnik['typ'][11][1] = array(14); //Malé objekty, garáže Řadový
		$ciselnik['typ'][11][2] = array(14); //Malé objekty, garáže Rohový
		$ciselnik['typ'][11][3] = array(14); //Malé objekty, garáže V bloku
		$ciselnik['typ'][11][4] = array(14); //Malé objekty, garáže Samostatný
		return $ciselnik;
	}

	/**
	 * Odvodí podtyp z informací o nemovitosti.
	 *
	 * @param array $originalValues Původní údaje o nemovitosti.
	 *
	 * @return int Jejich kód podtypu.
	 */
	function _getPodtyp(array $originalValues)
	{
		switch ($originalValues['nemovitost_typ']) {
			case 2:
				return $originalValues['nemovitost_ucel_budovy'];
				break;
			case 3:
				return $originalValues['nemovitost_druh_pozemku'];
				break;
			case 4:
				return $originalValues['nemovitost_dispozice'];
				break;
			case 5:
				return $originalValues['nemovitost_druh_objektu'];
				break;
			case 6:
				return $originalValues['nemovitost_poloha_objektu'];
				break;
			case 7:
				return $originalValues['nemovitost_typ_zarizeni'];
				break;
			case 9:
				return $originalValues['nemovitost_druh_prostor'];
				break;
			case 10:
			case 11:
				return $originalValues['nemovitost_poloha_objektu'];
				break;
			default:
				return 0;
				break;
		}
	}

	/**
	 * Přidává před dokončením exportu informace které není schopen přidat Newspeak.
	 *
	 * V tomto exportu se přidává jen podtyp jen nemovitosti.
	 *
	 * @param array  $convertedValues Převedené hodnoty.
	 * @param array  $originalvalues  Původná (nepřevedené hodnoty).
	 * @param string $entityName      Název entity.
	 *
	 * @return array Převedená data.
	 */
	function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if ($entityName == 'advert') {
			$ciselnik = $this->_getConversionTable();
			$podtyp = $this->_getPodtyp($originalvalues);
			$convertedValues['category_id']  = (
			($originalvalues['nemovitost_typ']==4)
				? $ciselnik['typ'][$originalvalues['nemovitost_typ']][$podtyp][$originalvalues['zakazka_typ']][0]
				: $ciselnik['typ'][$originalvalues['nemovitost_typ']][$podtyp][0]
			);
			$convertedValues['area'] = $this->_getHlavniPlocha($convertedValues, $originalvalues);
			$convertedValues['electricity'] = (int) $this->_isAnyChecked($originalvalues, 'nemovitost_elektrina');
			$convertedValues['gas'] = (int) $this->_isAnyChecked($originalvalues, 'nemovitost_plyn');
			$convertedValues['canalization'] = (int) $this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 0);
			if ($originalvalues['nemovitost_typ']==3) {
				// z položky „inženýrské sítě“ bereme info jen pro pozemky
				$convertedValues['electricity'] = (int) $this->_isMultiChecked($originalvalues, 'nemovitost_inzenyrske_site', 3);
				$convertedValues['gas'] = (int) $this->_isMultiChecked($originalvalues, 'nemovitost_inzenyrske_site', 2);
				$convertedValues['canalization'] = (int) $this->_isMultiChecked($originalvalues, 'nemovitost_inzenyrske_site', 1);
			}
		}

		if ($entityName=='broker') {
			$jmenoCele = $originalvalues['uzivatel_os_jmeno'] . (!empty($originalvalues['uzivatel_os_prostredni_jmeno']) ?  ' ' . $originalvalues['uzivatel_os_prostredni_jmeno'] : '') . ' ' . $originalvalues['uzivatel_os_prijmeni'];

			if (!empty($originalvalues['uzivatel_tituly_pred_jmenem'])) {
				$jmenoCele = $originalvalues['uzivatel_tituly_pred_jmenem'] . ' ' . $jmenoCele;
			}

			if (!empty($originalvalues['uzivatel_tituly_za_jmenem'])) {
				$jmenoCele = $jmenoCele . ' ' . $originalvalues['uzivatel_tituly_za_jmenem'];
			}

			$convertedValues['broker_name'] = $jmenoCele;
		}

		return parent::_convert($convertedValues, $originalvalues, $entityName);
	}
}
