<?php

/**
 * Export do formátu Srealit.
 *
 * @category   Dalten
 * @package    Export
 */
class Dalten_Export_Toplakhu extends Dalten_Export_AbstractExport
{
    /**
     * Doplní do převedených hodnot položky locality_uir a locality_uir_level.
     *
     * @param array  $convertedValues Pole převedených hodnot entity.
     * @param array  $originalvalues  Pole původních (nepřevedených) hodnot entity.
     * @param string $entityName      Název entity.
     *
     * @return array Výsledné pole hodnot.
     */
    protected function _convert(array $convertedValues, array $originalvalues, $entityName)
    {
        if ($entityName === 'ad') {
            $dneska=new DateTime();
            $convertedValues['validfrom']=$dneska->format("Ymd");
            $dneska->add(new DateInterval("P90D"));
            $convertedValues['validto']=$dneska->format("Ymd");

			if (isset($convertedValues['heating'])){
				if ($convertedValues['heating']) {
					$pos = strpos($convertedValues['heating'], '1');
					if ($pos === false) {
						$convertedValues['heating'] = 0;
					} else {
						$convertedValues['heating'] = 1;
					}
				}
			}

        }
        return parent::_convert($convertedValues, $originalvalues, $entityName);
    }
}