#!/usr/bin/env php
<?php

if (PHP_SAPI !== 'cli') {
	echo 'This should only be run from console; exiting';
	exit(1);
}

if (count($argv) !== 2) {
	echo 'Usage: validate.php <path/to/import/file.xml>' . PHP_EOL;
	exit(1);
}

if (!is_readable($argv[1])) {
	echo 'The file \'' . $argv[1] . '\' is not readable' . PHP_EOL;
	exit(1);
}

libxml_use_internal_errors(true);

$dom = DOMDocument::load($argv[1]);
if ($dom === false) {
	file_put_contents('php://stderr', 'The file is not an xml file, or contains xml syntax errors; errors:' . PHP_EOL);
	libxml_display_errors();
	exit(1);
}

if ($dom->schemaValidate('./xsd/import.xsd') === false) {
	file_put_contents('php://stderr', 'The file is not valid; errors during validation:' . PHP_EOL);
	libxml_display_errors();
	exit(1);
}

echo 'The file is valid';

// function listing

function libxml_format_error($error) {
	$dict = array(
		LIBXML_ERR_WARNING => 'Warning',
		LIBXML_ERR_ERROR => 'Error',
		LIBXML_ERR_FATAL => 'Fatal error',
	);

	return sprintf(
		"%s: %s; on line %d in %s\n",
		$dict[$error->level],
		trim($error->message),
		$error->line,
		$error->file
	);
}

function libxml_display_errors() {
	$errors = libxml_get_errors();
	foreach ($errors as $key => $error) {
		file_put_contents('php://stderr', libxml_format_error($error));
	}
	libxml_clear_errors();
}


