<?php
/**
 * Převodník adres z UIR do extended RUIAN.
 *
 * Podle typu nemovitosti dopočítá RUIAN kód adresy s fallbackem
 * na starý způsob zadávání (pokud je adresa nepřesná).
 *
 * Tj.hledá ruian_adresa_kod.
 * 
 * Tato verze podporuje sdružená Č.P.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_Irest1RuianAddress implements Dalten_AddressConverter_RealityCz_Interface
{
	private $_db;

	/**
	 * Konstruktor. Nastavuje databázi.
	 *
	 * @param Irest_Database $db Prihlasena adresni databaze.
	 *
	 * @throws Exception Když se nedostane do adresní databáze.
	 */
	function __construct(Irest_Database $db)
	{
		if (!$db->getConnection()) {
			throw new Exception('Prevodniku adres musite predat platne pripojeni do adresni databaze.');
		}
		$this->_db = $db;
	}

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		// když nemáme KU kód, zkusíme ho dopočítat
		// TODO - tohle asi chce pryč
		if (empty($input['nemovitost_ku_kod'])) {
			$input['nemovitost_ku_kod'] = $this->_db->fetchField(
				sprintf(
					'SELECT ku_kod FROM realitycz_cobce2ku WHERE cobce_kod=%d',
					$input['nemovitost_uir_cobce_kod']
				)
			);
		}

		if ($input['nemovitost_typ']==3) {
			// TODO - parcely zatím neumíme
		} else {			
			$coPodminka = ' AND cisor_hod IS NULL'; // nevyplněné č.o. » ptáme se jen na adresy, co ho nemají
			if (!empty($input['nemovitost_uir_co'])) {
				// pokud máme číslo orientační,  rozdělujeme č.o. na číselnou část a písmeno na konci
				$castiCO = array();
				preg_match('~(\d+)([[:alpha:]]?)~', $input['nemovitost_uir_co'], $castiCO);
				$coPodminka = sprintf(' AND cisor_hod=%d', $castiCO[1]);
				if (!empty($castiCO[2])) {
					$coPodminka .=  ' AND cisor_pis='. $this->_db->quoteParam($castiCO[2]) .'';
				} else {
					$coPodminka .= ' AND cisor_pis IS NULL';
				}
			}

			if (!empty($input['nemovitost_uir_evc'])) {
                // kombinace číslo popisné + část obce je unikátní
                $adresaKod = $this->_db->fetchField(
                    sprintf(
                        'SELECT adresa_kod 
						FROM adresa a
						INNER JOIN objekt o ON a.objekt_kod=o.objekt_kod
						WHERE o.cobce_kod=%d AND a.cisdom_hod=%d AND o.cisdom_typ=2' . $coPodminka,
                        $input['nemovitost_uir_cobce_kod'],
                        $input['nemovitost_uir_evc']
                    )
                );

                if ($adresaKod) {
                    $input['ruian_adresa_kod'] = $adresaKod;
                }
            } elseif (!empty($input['nemovitost_uir_cobce_kod']) && !empty($input['nemovitost_uir_cp'])) {
				// kombinace číslo popisné + část obce je unikátní
				$adresaKod = $this->_db->fetchField(
					sprintf(
						'SELECT adresa_kod 
						FROM adresa a
						INNER JOIN objekt o ON a.objekt_kod=o.objekt_kod
						WHERE o.cobce_kod=%d AND a.cisdom_hod=%d AND o.cisdom_typ=1' . $coPodminka,
						$input['nemovitost_uir_cobce_kod'],
						$input['nemovitost_uir_cp']
					)
				);

				if ($adresaKod) {
					$input['ruian_adresa_kod'] = $adresaKod;
				}
				
			} elseif (!empty($input['nemovitost_uir_ulice_kod']) && !empty($input['nemovitost_uir_cp'])) {
				// kombinace ulice + číslo popisné není unikátní
				$mozneAdresy = $this->_db->fetchAll(
					sprintf(
						'SELECT adresa_kod 
						FROM adresa a
						INNER JOIN objekt o ON a.objekt_kod=o.objekt_kod
						WHERE a.ulice_kod=%d AND a.cisdom_hod=%d AND o.cisdom_typ=1' . $coPodminka,
						$input['nemovitost_uir_ulice_kod'],
						$input['nemovitost_uir_cp']
					)
				);

				if (count($mozneAdresy)==1) {
					// proto ukládáme jen když je jednoznačný výsledek
					$input['ruian_adresa_kod'] = $mozneAdresy[0]['adresa_kod'];
				}
			}
		}

		return $input;
	}
}