<?php
/**
 * Class Dalten_AddressConverter_RealsoftSk_Realsoft
 *
 * Převodník, který používá nativní adresní systém Realsoftu.
 */
class Dalten_AddressConverter_RealsoftSk_Realsoft implements Dalten_AddressConverter_RealsoftSk_Interface
{
    protected function _getStateConversion(){
        return array(
            'SK'=>1,
            'CZ'=>2,
            'PL'=>3,
            'HU'=>4,
            'AT'=>5,
            'DE'=>6,
            'ES'=>7,
            'IT'=>8,
            'HR'=>9,
            'TR'=>10,
            'BG'=>11,
            'BE'=>12,
            'CY'=>13,
            'DK'=>14,
            'EE'=>15,
            'FI'=>16,
            'FR'=>17,
            'IE'=>18,
            'LT'=>19,
            'LV'=>20,
            'LU'=>21,
            'MT'=>22,
            'NL'=>23,
            'PT'=>24,
            'RO'=>25,
            'SI'=>26,
            'GB'=>27,
            'SE'=>28,
            'CH'=>29,
            'EG'=>30,
            'US'=>31,
            'GR'=>32,
            'RU'=>33,
            'UA'=>34,
            'MM'=>35,
            'PH'=>36,
            'ID'=>37,
            'KH'=>38,
            'MY'=>39,
            'LK'=>40,
            'TH'=>41,
            'VN'=>42,
            'BR'=>43,
            'CA'=>44,
            'VE'=>46,
            'ME'=>47,
            'DO'=>48,
            'SC'=>49,
            'CV'=>50,
            'RS'=>51,
            'TZ'=>52
        );
    }


    /**
     * Můžeme převést tuto adresu?
     *
     * @param array $input Informace o nemovitosti.
     *
     * @return bool Můžeme převést tuto adresu?
     */
    function canConvertAddress(array $input)
    {
        if ($input['nemovitost_uir_stat']=='SK' && !empty($input['nemovitost_ma_realsoft_adresu'])) {
            return true; // je SK a má realsoft adresu
        }
        $prevodnikStatu = $this->_getStateConversion();
        return $input['nemovitost_uir_stat']!='SK' && isset($prevodnikStatu[$input['nemovitost_uir_stat']]); // je zahraniční a jde převést stát
    }

    /**
     * Převede adresu u nemovitosti do jiného adresního systému.
     *
     * @param array $input Informace o nemovitosti.
     *
     * @return array Informace o nemovitosti s upravenou adresou.
     */
    function convertAddress(array $input)
    {
        $prevodnikStatu = $this->_getStateConversion();
        if (isset($prevodnikStatu[$input['nemovitost_uir_stat']]) && $input['nemovitost_uir_stat']!='SK') {
            // převod jinam než SK se dělá tak, že přeloží stát a zbytek se pošle tak jak je v DB
            $input['nemovitost_uir_stat'] = $prevodnikStatu[$input['nemovitost_uir_stat']];
            $input['street_show'] = 0;
            $input['street_id'] = 0;

            // u těchto nechceme posílat -1
            $input['nemovitost_uir_kraj_kod'] = $input['nemovitost_uir_kraj_kod']>0 ? $input['nemovitost_uir_kraj_kod'] : 0;
            $input['nemovitost_uir_okres_kod'] = $input['nemovitost_uir_okres_kod']>0 ? $input['nemovitost_uir_okres_kod'] : 0;
            $input['nemovitost_uir_obec_kod'] = $input['nemovitost_uir_obec_kod']>0 ? $input['nemovitost_uir_obec_kod'] : 0;

            return $input;
        }

        $input['nemovitost_uir_stat'] = 1;

        $input['street_show'] = empty($input['nemovitost_realsoft_ulice_kod']) ? 0 : 1;
        $input['street_id'] = $input['nemovitost_realsoft_ulice_kod'];
        $input['nemovitost_uir_ulice_text'] = $input['nemovitost_realsoft_ulice_text'];

        $citypartId = intval(substr($input['nemovitost_realsoft_cobce_kod'], -2));

        if ($citypartId) {
            $input['citypart_id'] = $citypartId;
        } else {
            $input['citypart_id'] = 0;
        }

        return $input;
    }
}