<?php

/**
 * Odpověď serveru.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_ServerResponse
{
	/**
	 * Operace byla úspěšná - T/F.
	 *
	 * @var bool
	 */
	private $_wasSuccessful;

	/**
	 * Stavový kód.
	 *
	 * @var string|null
	 */
	private $_code;

	/**
	 * Textová odpověď serveru (obvykle popis chyby).
	 *
	 * @var string
	 */
	private $_message;

	/**
	 * Další výstup serveru.
	 *
	 * @var Dalten_Data_ArrayObject|null
	 */
	private $_output;

	/**
	 * Data ktera poslal server jako odpoved.
	 *
	 * Tato data je potreba uchovat. Budou potreba pri dalsim exportu.
	 *
	 * @var array
	 */
	private $_data = array();

	/**
	 * Konstruktor.
	 *
	 * @param bool         $success Vše se podařilo - T/F.
	 * @param string|null  $code    Stavový kód.
	 * @param string       $message Textová odpověď serveru (obvykle popis chyby).
	 * @param object|array $output  Další výstup serveru.
	 */
	public function __construct($success, $code = null, $message = '', $output = null)
	{
		$this->_wasSuccessful = (bool) $success;
		$this->_code = (string) $code;
		$this->_message = (string) $message;
		$this->_output = new Dalten_Data_ArrayObject($output);
	}

	/**
	 * Byla operace úspěšná?
	 *
	 * @return bool Byla operace úspěšná?
	 */
	public function wasSuccessful()
	{
		return $this->_wasSuccessful;
	}

	/**
	 * Vrátí stavový kód.
	 *
	 * @return string Stavový kód.
	 */
	public function getCode()
	{
		return $this->_code;
	}

	/**
	 * Vrátí textovou odpověď serveru (obvykle popis chyby).
	 *
	 * @return string Textová odpověď serveru (obvykle popis chyby).
	 */
	public function getMessage()
	{
		return $this->_message;
	}

	/**
	 * Vrátí další výstup serveru.
	 *
	 * @return Dalten_Data_ArrayObject|null Další výstup serveru.
	 */
	public function getOutput()
	{
		return $this->_output;
	}

	/**
	 * Nastaví data která jsou potřeba uchovat pro další export inzerátu.
	 *
	 * @param array $data Data která potřebujeme uchovat.
	 *
	 * @return Dalten_Export_Api_ServerResponse
	 */
	public function setData(array $data)
	{
		$this->_data = $data;
		return $this;
	}

	/**
	 * Vátí data která je potřeba uchovat pro další exportování inzerátu.
	 *
	 * @return array
	 */
	public function getData()
	{
		return $this->_data;
	}
}
