<?php

/**
 * Export do formátu Srealit.
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_Toprealitysk extends Dalten_Export_AbstractExport
{
	const TATRANSKA_STRBA = 999001;

	/**
	 * Konstruktor. Nestandartní je jeho poslední parametr - adresář. Adresář je pole s podpoli county, district
	 * a region pro převod na opdovídající adresu v číselníku Topreality.sk. (podívej se do souboru
	 * adresy_toperealitysk.ini a pochopíš)
	 *
	 * @param Serenity_Config_Config                          $codebooks Číselníky
	 * @param Serenity_Config_Config                          $entities  Entity
	 * @param Dalten_Config_Processer_ProcesserInterface|null $processer Obyvkle null
	 * @param array                                           $adresar   Převodní adresář
	 */
	function __construct(Serenity_Config_Config $codebooks,
						 Serenity_Config_Config $entities,
						 Dalten_Config_Processer_ProcesserInterface $processer = null,
						 array $adresar)
	{
		//posílám parametry rodičovi a nestarám se co bylo v nich
		parent::__construct($codebooks, $entities, $processer);
		//beru si jen adresář
		$this->adresar = $adresar;
	}

	/**
	 * Převede ty informace, které není možné ošetřit v ini souboru.
	 *
	 * @param array  $convertedValues Převedené položky
	 * @param array  $originalvalues  Originály
	 * @param string $entityName      Jméno entity
	 *
	 * @return array
	 */
	protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if ($entityName == "obj") {
			if ($originalvalues['nemovitost_uir_cobce_kod'] && $originalvalues['nemovitost_uir_cobce_kod']==$this::TATRANSKA_STRBA) {
				// Když je část obce Tatranská Štrba,
				// tak podstrkáváme Tatranskou Štrbu jako obec.
				$convertedValues['region'] = $originalvalues['nemovitost_uir_cobce_kod'];
			}

			$convertedValues['county'] = (
			isset($this->adresar['county'][$convertedValues['county']])
				? $this->adresar['county'][$convertedValues['county']]
				: 0
			);
			$convertedValues['district'] = (
			isset($this->adresar['district'][$convertedValues['district']])
				? $this->adresar['district'][$convertedValues['district']]
				: 0
			);
			$convertedValues['region'] = (
			isset($this->adresar['region'][$convertedValues['region']])
				? $this->adresar['region'][$convertedValues['region']]
				: 0
			);

			if ($convertedValues['price_unit'] == 999) {
				$convertedValues['price'] = $convertedValues['price'] * 30.5;
				$convertedValues['price_unit'] = 3;
			}

			if ($originalvalues['nemovitost_elektrina']) {
				if (substr($originalvalues['nemovitost_elektrina'], 1, 1)
					and substr($originalvalues['nemovitost_elektrina'], 3, 1)) {
					$convertedValues['electric'] = 2;
				} elseif (substr($originalvalues['nemovitost_elektrina'], 1, 1)) {
					$convertedValues['electric'] = 1;
				} else {
					unset($convertedValues['electric']);
				}

			}

			if ($convertedValues['heating']) {
				$pos = strpos($convertedValues['heating'], '1');
				if ($pos === false) {
					unset($convertedValues['heating']);
				} else {
					$convertedValues['heating'] = $pos + 1;
				}
			}

			if (isset($originalvalues['automatic_detail_url'])) {
				$convertedValues['detail_url'] = $originalvalues['automatic_detail_url'];
			}

			$convertedValues['price']=sprintf('%F', $convertedValues['price']);

			//Pokud nevime s jistotou ze sklep mame nebo nemame, nezobrazujeme sklep (posilame -1).
			if ($originalvalues['nemovitost_sklep']===0) {
				$convertedValues['cellar_area'] = 0;
			} elseif ($originalvalues['nemovitost_sklep']==1) {
				if ($originalvalues['nemovitost_sklep_plocha']>0) {
					$convertedValues['cellar_area'] = $originalvalues['nemovitost_sklep_plocha'];
				} else {
					$convertedValues['cellar_area'] = -1;
				}
			} else {
				$convertedValues['cellar_area'] = -1;
			}

		}


		return $convertedValues;
	}
}