<?php

/**
 * Export do formátu Bazoš.
 *
 * @category   Dalten
 * @package    Export
 */
class Dalten_Export_Bazos extends Dalten_Export_AbstractExport
{
    protected function _convert(array $convertedValues, array $originalvalues, $entityName)
    {
        $convertedValues =  parent::_convert($convertedValues, $originalvalues, $entityName);

        if ($entityName == 'listing') {
            $stitky = [
                1=> 'A - Mimořádně úsporná',
                2=> 'B - Úsporná',
                3=> 'C - Vyhovující',
                4=> 'D - Nevyhovující',
                5=> 'E - Nehospodárná',
                6=> 'F - Velmi nehospodárná',
                7=> 'G - Mimořádně nehospodárná'
            ];

            $vyhlasky = [
                1=> 'č. 148/2007 Sb.',
                2=> 'č. 78/2013 Sb.',
                3=> 'č. 264/2020 Sb.'
            ];

            $stitek = '';
            if (isset($stitky[$originalvalues['nemovitost_energeticky_stitek']])) {
                $stitek .= 'Energetický štítek: ' . $stitky[$originalvalues['nemovitost_energeticky_stitek']];
            }
            if (isset($vyhlasky[$originalvalues['nemovitost_energeticky_stitek_vyhlaska']])) {
                $stitek .= ' dle vyhlášky ' . $vyhlasky[$originalvalues['nemovitost_energeticky_stitek_vyhlaska']];
            }

            $convertedValues['popis'] = $convertedValues['popis'] . PHP_EOL . $stitek;
        }

        return $convertedValues;
    }
}
