<?php
/**
 * Převodník pro Realsoft.sk.
 *
 * Většina logiky je ale v INI souboru.
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_RealsoftSk extends Dalten_Export_AbstractExport
{
	/**
	 * Vrací je-li v poli $data zaškrtnuté pole $fieldName jako multicheckbox na hodnotě $value.
	 *
	 * @param array  $data      Pole s daty.
	 * @param string $fieldName Název políčka.
	 * @param int    $value     Pořadí zašktávátka.
	 *
	 * @return bool Je to tak?
	 */
	private function _isMultiChecked(array $data, $fieldName, $value) {
		if (isset($data[$fieldName])) {
			if (substr($data[$fieldName], $value, 1)==1) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@inheritdoc}
	 */
	protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if ($entityName=='object') {
			$convertedValues['video_id'] = $this->_getYoutubeId($originalvalues['nemovitost_virtualni_prohlidka']);
			if ($this->_getYoutubeId($originalvalues['nemovitost_url_videoprohlidka'])) {
                $convertedValues['video_id'] = $this->_getYoutubeId($originalvalues['nemovitost_url_videoprohlidka']);
            }
			$convertedValues['virtualtour_id'] = '';
			if ($this->_getMatterportId($originalvalues['nemovitost_virtualni_prohlidka'])) {
				$convertedValues['virtualtour_id'] = $originalvalues['nemovitost_virtualni_prohlidka'];
			}
            if ($this->_getMatterportId($originalvalues['nemovitost_url_virtualni_prohlidka'])) {
                $convertedValues['virtualtour_id'] = $originalvalues['nemovitost_url_virtualni_prohlidka'];
            }

			$convertedValues = $this->_convertTopeni($convertedValues, $originalvalues);

			$convertedValues['adv_school'] = // škola nebo školka:
				$this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 0) ||
				$this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 1);

			$convertedValues['adv_hospital'] = $this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 2);
			$convertedValues['adv_bus'] = $this->_isMultiChecked($originalvalues, 'nemovitost_doprava', 3);

			$convertedValues['adv_shopping'] = // supermarket a kompletní síť obchodů a služeb
				$this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 4) ||
				$this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 5);


			$convertedValues['adv_silence'] = $this->_isMultiChecked($originalvalues, 'nemovitost_umisteni_objektu', 2);

		}

		return parent::_convert($convertedValues, $originalvalues, $entityName);
	}

	/**
	 * Vytáhne VIDEO_ID z odkazu na YouTube.
	 *
	 * @param string $url Odkaz na YouTube.
	 *
	 * @return string VIDEO_ID nebo prázdný string.
	 */
	protected function _getYoutubeId($url) {
        if (empty($url)) {
            return '';
        }
        $parsedURL = parse_url($url);
        if (isset($parsedURL['host']) && 'youtu.be' == $parsedURL['host']) {
            $matches = array();
            preg_match('~/(.*)~', $parsedURL['path'], $matches);
            if (!empty($matches[1])) {
                return $matches[1];
            }
        } elseif ('www.youtube.com' == $parsedURL['host'] || 'youtube.com' == $parsedURL['host']) {
            $parameters = array();
            $matches = array();
            if (preg_match('~/shorts/([\w-]+)~', $parsedURL['path'], $matches)==1) {
                return $matches[1];
            } elseif (isset($parsedURL['query'])) {
                parse_str($parsedURL['query'], $parameters);
                if (!empty($parameters['v'])) {
                    return $parameters['v'];
                }
            }
        }

        return '';
    }

	/**
	 * Vytáhne ID virtuální prohlíky Matterport.
	 *
	 * @param string $url Odkaz na YouTube.
	 *
	 * @return string
	 */
	protected function _getMatterportId($url) {
		// https://my.matterport.com/show/?m=pGSH9wuaKZH
		$parsedUrl = parse_url($url);
		if ($parsedUrl['host']=='my.matterport.com' &&  trim($parsedUrl['path'],'/')=='show') {
			$parameters = array();
			parse_str($parsedUrl['query'], $parameters);
			if (!empty($parameters['m'])) {
				return $parameters['m'];
			}
		}
		return '';
	}

	/**
	 * Převede údaje o topení. Rozlišuje mezi ústředním a lokálním.
	 *
	 * @param array $convertedValues Pole převedených hodnot entity.
	 * @param array $originalvalues  Pole původních (nepřevedených) hodnot entity.
	 *
	 * @return mixed Upravené hodnoty s přidaným topením.
	 */
	protected function _convertTopeni($convertedValues, $originalvalues)
	{
		$nemovitost_topeni = $originalvalues['nemovitost_topeni'];

		$convertedValues['heating_local'] = 0;
		$convertedValues['heating_central'] = 0;

		if (substr($nemovitost_topeni, 0, 1)=="1" || substr($nemovitost_topeni, 1, 1)=="1" || substr($nemovitost_topeni, 2, 1)=="1") {
			$convertedValues['heating_local'] = 1;
		}
		if (substr($nemovitost_topeni, 3, 1)=="1" || substr($nemovitost_topeni, 4, 1)=="1" || substr($nemovitost_topeni, 5, 1)=="1" || substr($nemovitost_topeni, 6, 1)=="1") {
			$convertedValues['heating_central'] = 1;
		}

		return $convertedValues;
	}
}
