<?php
/**
 * Export na Ingatlanbazar.hu.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_Ingatlanbazar implements Dalten_Export_Api_CloseableApiInterface,
	Dalten_Export_Api_TransactionApiInterface
{
	private $_backend;
	private $_feedbackEmail;

	/**
	 * Konstruktor.
	 *
	 * @param Dalten_Export_Api_Backend_Ingatlanbazar $backend       Nastavený backend.
	 * @param string                                  $feedbackEmail E-mail pro feedback.
	 */
	public function __construct(Dalten_Export_Api_Backend_Ingatlanbazar $backend, $feedbackEmail)
	{
		$this->_backend = $backend;
		$this->_feedbackEmail = $feedbackEmail;
	}

	/**
	 * Naváže spojení se vzdáleným serverem.
	 *
	 * @param string $login            Přihlašovací jméno.
	 * @param string $password         Heslo.
	 * @param string $softwareKey      Softwarový klíč.
	 * @param array  $additionalParams Pole dalších parametrů.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function openConnection($login, $password, $softwareKey = '', array $additionalParams = array())
	{
		try {
			$this->_backend->addOffice($login, $this->_feedbackEmail);
			return new Dalten_Export_Api_ServerResponse(true);
		} catch (Dalten_Export_Exception_HumanReadable $e) {
			return new Dalten_Export_Api_ServerResponse(false, 0, $e->getMessage());
		} catch (Exception $e) {
			return new Dalten_Export_Api_ServerResponse(false);
		}
	}

	/**
	 * Vyexportuje nabídku.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $userData         Data uživatele (makléře, kterému nabídka patří) ve formátu iRest 1.
	 * @param array $images           Pole fotografií nabídky ve formátu iRest 1.
	 * @param array $additionalParams Údaje které vrací server při exportu a jsou potřeba pro další práci
	 *                                s nabídkou.
	 *                                Data můžou sloužit pro editaci apod...
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru, jestli se export podařil nebo
	 *                                          co selhalo.
	 */
	public function addListing(
		array $listingData, array $userData, array $images = array(), array $additionalParams = array()
	)
	{
		try {
			$this->_backend->appendAd($listingData, $userData, $images);
			$this->_backend->appendAgent($listingData, $userData);
			return new Dalten_Export_Api_ServerResponse(true);
		} catch (Dalten_Export_Exception_HumanReadable $e) {
			return new Dalten_Export_Api_ServerResponse(false, 0, $e->getMessage());
		} catch (Exception $e) {
			return new Dalten_Export_Api_ServerResponse(false);
		}

	}

	/**
	 * Odstraní nabídku ze vzdáleného serveru. Tohle funguje vždycky.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $additionalParams Specifická data pro daný export.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function deleteListing(array $listingData, array $additionalParams = array())
	{
		return new Dalten_Export_Api_ServerResponse(true);
	}

	/**
	 * Vrátí seznam nabídek, které jsou na vzdáleném serveru.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function getListingsList()
	{
		throw new BadMethodCallException('Not yet implemented!');
	}

	/**
	 * Zavírá spojení.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function closeConnection()
	{
		try {
			return new Dalten_Export_Api_ServerResponse(true);
		} catch (Dalten_Export_Exception_HumanReadable $e) {
			return new Dalten_Export_Api_ServerResponse(false, 0, $e->getMessage());
		} catch (Exception $e) {
			return new Dalten_Export_Api_ServerResponse(false);
		}
	}

	/**
	 * Začíná transakci.
	 */
	public function beginTransaction()
	{
		$this->_backend->prepareXml();
	}

	/**
	 * Končí transakci.
	 */
	public function commitTransaction()
	{
		$this->_backend->finishXml();
	}


}
