<?php

/**
 * Export do formátu ARK ČR.
 *
 * @category   Dalten
 * @package    Export
 */
class Dalten_Export_ArkCr extends Dalten_Export_Sreality
{
	/**
	 * Vrací je-li v poli $data zaškrtnuté pole $fieldName jako multicheckbox na hodnotě $value.
	 *
	 * @param array  $data      Pole s daty.
	 * @param string $fieldName Název políčka.
	 * @param int    $value     Pořadí zašktávátka.
	 *
	 * @return bool Je to tak?
	 */
	private function _isMultiChecked(array $data, $fieldName, $value) {
		if (isset($data[$fieldName])) {
			if (substr($data[$fieldName], $value, 1)==1) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Převede položku odpad. Převádíme multichceckbox na enum.
	 *
	 * Pokud je jednoznačně zadána, převedeme, pokud je cokoliv, převedeme na "V dosahu" jinak na není.
	 *
	 * @param array $originalvalues Původní údaje.
	 *
	 * @return int Kód odpadu.
	 */
	protected function _convertGully($originalvalues)
	{
		if (
			$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 0) &&
			!$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 1) &&
			!$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 2)
		) {
			// kanalizace
			return 1;
		} elseif (
			!$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 0) &&
			$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 1) &&
			!$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 2)
		) {
			// čistička
			return 3;
		} elseif (
			!$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 0) &&
			!$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 1) &&
			$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 2)
		) {
			// septik
			return 2;
		}  elseif (
			$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 0) ||
			$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 1) ||
			$this->_isMultiChecked($originalvalues, 'nemovitost_odpad', 2)
		) {
			// v dosahu
			return 5;
		}
		// není
		return 7;
	}

	/**
	 * Převede položku elektřina. Převádíme multichceckbox na enum.
	 *
	 * @param array $originalvalues Původní údaje.
	 *
	 * @return int Kód elektřiny.
	 */
	function _convertElectricity($originalvalues)
	{
		if (
			$this->_isMultiChecked($originalvalues, 'nemovitost_elektrina', 1) &&
			!$this->_isMultiChecked($originalvalues, 'nemovitost_elektrina', 3)
		) {
			// 230V
			return 1;
		} elseif (
			$this->_isMultiChecked($originalvalues, 'nemovitost_elektrina', 1) &&
			$this->_isMultiChecked($originalvalues, 'nemovitost_elektrina', 3)
		) {
			// 230V + 400V
			return 2;
		}
		return 3; // Není
	}

	/**
	 * Převádí číslo podlaží na patro.
	 *
	 * @param $originalvalues
	 *
	 * @return int Kód patra.
	 */
	protected function _convertFloorNumber($originalvalues)
	{
		$cisloPodlazi = intval($originalvalues['nemovitost_podlazi_cislo']);
		if ($cisloPodlazi==1) {
			return 1000; // přízemí
		} elseif ($cisloPodlazi>1 && $cisloPodlazi<21) {
			return $cisloPodlazi-1; // kód patra
		}
		return 999; // Vyšší
	}

	/**
	 * {@inheritdoc}
	 */
	protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if ($entityName === 'listing') {
			$convertedValues['gully'] = $this->_convertGully($originalvalues);
			$convertedValues['electricity'] = $this->_convertElectricity($originalvalues);
			$convertedValues['floor_number'] = $this->_convertFloorNumber($originalvalues);
			$convertedValues['description'] = str_replace(array("\r\n", "\r", "\n"), ' ', $convertedValues['description']);
			$convertedValues['urlestatedetail'] = sprintf('http://www.remax-czech.cz/reality/detail/%d', $originalvalues['id']);
			if (!empty($originalvalues['nemovitost_cena_poplatky']) && $originalvalues['nemovitost_cena_poplatky']>0) {
				$convertedValues['advert_price_text_note'] = $convertedValues['advert_price_text_note'] . ' + poplatky ' . $originalvalues['nemovitost_cena_poplatky'] . ' Kč / měs.';
			}
		}
		return parent::_convert($convertedValues, $originalvalues, $entityName);
	}
}