<?php
/**
 * Převodník z adresního sytému Irestů (UIR) do adresního systému používaného serverem Nehnutelnosti.sk.
 *
 * Protože se krmí soubory je univerzální skrz všecky Iresty.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_NehnutelnostiSk_Universal implements Dalten_AddressConverter_NehnutelnostiSk_Interface
{
	private $_map = array();

	/**
	 * Kontruktor. Nahrává převodní mapu z INI souboru.
	 *
	 * @param string $mapFile Cesta k INI souboru s převodníkem.
	 */
	function __construct($mapFile)
	{
		$this->_map = parse_ini_file($mapFile, true);
	}

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		$obecKod = $input['nemovitost_uir_obec_kod'];

		if (isset($this->_map['obec'][$obecKod])) {
			$input['lokalita'] = $this->_map['obec'][$obecKod];
			if ($this->_formatUlice($input)) {
				$input['ulice'] = $this->_formatUlice($input);
			}
		}
		return $input;
	}

	/**
	 * Zformátuje text ulice.
	 *
	 * @param array $input Data nabídky.
	 *
	 * @return string Zformátovaná ulice, případně se přidává Č.P. nebo Č.O.
	 */
	protected function _formatUlice(array $input)
	{
		$ulice = $input['nemovitost_uir_ulice_text'];
		$cp = $input['nemovitost_uir_cp'];
		$co = $input['nemovitost_uir_co'];
		if (!empty($ulice) && !empty($cp) && !empty($co)) {
			return $ulice . ' ' . $cp . '/' . $co;
		} elseif (!empty($ulice) && !empty($cp)) {
			return $ulice . ' ' . $cp;
		} elseif (!empty($ulice) && !empty($co)) {
			return $ulice . ' ' . $co;
		}
		return '';
	}
}