<?php
/**
 * Šablona XML elementu pro export na Remax/global.
 *
 * Features se převadí z pole číselných kódů na XML, například:
 *
 * <code>
 * array(1, 2, 3)
 * </code>
 * převede na
 *
 * <code>
 * &lt;Features&gt;
 *   &lt;FeatureID FeatureID=&quot;1&quot;/&gt;
 *   &lt;FeatureID FeatureID=&quot;2&quot;/&gt;
 *   &lt;FeatureID FeatureID=&quot;3&quot;/&gt;
 * &lt;/Features&gt;
 * </code>
 *
 * @category Dalten
 * @package  Xml
 */
class Dalten_Xml_Template_Features extends Dalten_Xml_Template_Element
{
	/**
	 * {@inheritdoc}
	 */
	public function fill(SimpleXMLElement $rootElement, array $data)
	{
		if ($this->_hasEmptyValue($data)) {
			return null;
		}

		$features = $data[$this->_variableName];

		if (count($features)==0) {
			return null;
		}

		$features = array_unique($features);

		$container = $rootElement->addChild($this->_name);

		foreach ($features as $featureCode) {
			$container->addChild('FeatureID')->addAttribute('FeatureID', $featureCode);
		}

		return $container;
	}
}