<?php

/**
 * Vytovoří z pole xml soubor podle pravidel idnes.
 */
class Dalten_Export_Api_Backend_Idnes_Xml
{
	/**
	 * Pole dat ze kterých budeme sestavovat xml.
	 *
	 * @var array
	 */
	private $_data = array();

	/**
	 * Hlavička a tělo prázndého xml souboru pro idnes.
	 *
	 * @var string
	 */
	private static $_xmlBody = '<?xml version="1.0" encoding="utf-8"?><nabidka></nabidka>';

	/**
	 * Nastaví objektu hodnoty.
	 *
	 * @param array $data
	 */
	public function __construct(array $data)
	{
		$this->_data = $data;
	}

	/**
	 * Vrátí vytvořené xml.
	 *
	 * @return string
	 */
	public function build()
	{
		$xml = new SimpleXMLElement(self::$_xmlBody);
		foreach ($this->_data as $node => $value) {
			if ($node === 'foto' || $node === 'video') {
				$this->_addMediaFiles($xml, $node, $value);
			} elseif (is_array($value)) {
				foreach ($value as $val) {
					$xml->addChild($node, $val);
				}
			} elseif(is_bool($value)) {
				$xml->addChild($node, $value ? '1' : '0');
			} else {
				$xml->addChild($node, \htmlspecialchars($value, \ENT_COMPAT, 'UTF-8', false));
			}
		}

		return $xml->saveXML();
	}

	/**
	 * Přidá do xml uzly s mediálním soborem.
	 *
	 * @param SimpleXMLElement $xml      Instance xml dokumentu.
	 * @param string           $nodeName Název uzlu který budeme vytvářet.
	 * @param array            $files    Pole souborů, které chceme přidat.
	 */
	private function _addMediaFiles(SimpleXMLElement $xml, $nodeName, $files)
	{
		foreach ($files as $values) {
			$parent = $xml->addChild($nodeName);
			$parent->addChild('ord', $values['ord']);
			$parent->addChild('hash', $values['hash']);
			$parent->addChild('filename', $values['filename']);
		}
	}
}
