<?php
/**
 * Tato třída rozšiřuje základní export o možnost ověření proběhlých exportů.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
interface Dalten_Export_Api_VerifiableApiInterface extends Dalten_Export_Api_ApiInterface
{
	/**
	 * Ověří si v jakém stavu je export nabídky nemovitosti.
	 *
	 * @param array $listingData Data nemovitosti.
	 * @param array $additionalParams Údaje které vrací server při exportu a jsou potřeba pro další práci s nabídkou.
	 *                                Data můžou sloužit pro editaci apod...
	 *
	 * @return Dalten_Export_Api_ServerResponseVerifiable Odpověď serveru obsahující informaci o ověření.
	 */
	public function verifyListing(array $listingData, array $additionalParams);
}
