<?php

/**
 * Jenreality nepodporujou nulové hodnoty u multicheckboxů, takže je potřeba je odstranit. Zároveň chtějí RUIAN místo UIR.
 */
class Dalten_Export_Jenreality extends Dalten_Export_Sreality
{
    protected function _convert(array $convertedValues, array $originalvalues, $entityName)
    {
        $convertedValues = parent::_convert($convertedValues, $originalvalues, $entityName);

        if (($entityName === 'listing') or ($entityName == 'project')) {
            if (isset($convertedValues['locality_uir_level']) && $convertedValues['locality_uir']) {
                $convertedValues['locality_ruian_level'] = $convertedValues['locality_uir_level'];
                $convertedValues['locality_ruian'] = $convertedValues['locality_uir'];
                unset($convertedValues['locality_uir_level'], $convertedValues['locality_uir']);
            } else {
                $convertedValues['locality_eurostat'] = $originalvalues['nemovitost_uir_stat'];
                $convertedValues['locality_city'] = $originalvalues['nemovitost_uir_obec_text'];
                $convertedValues['locality_region'] = $originalvalues['nemovitost_uir_kraj_text'];
                $convertedValues['locality_district'] = $originalvalues['nemovitost_uir_okres_text'];
            }

            $youtubeId = Dalten_Export_Helper_YoutubeIdExtractor::extractYoutubeId($originalvalues['nemovitost_video_prohlidka']);
            if ($youtubeId) {
                $convertedValues['video_youtube'] = $youtubeId;
            }

            $tourYoutubeId = Dalten_Export_Helper_YoutubeIdExtractor::extractYoutubeId($originalvalues['nemovitost_virtualni_prohlidka']);
            if ($tourYoutubeId) {
                $convertedValues['video_youtube'] = $tourYoutubeId;
            }

            $normalizedUrl = Dalten_Export_Helper_MatterportIdExtractor::extractMatterportId($originalvalues['nemovitost_virtualni_prohlidka']);
            if ($normalizedUrl) {
                $convertedValues['matterport_url'] = $normalizedUrl;
            }
        }

        return $convertedValues;
    }

    public function convertEntityValues($name, array $originalValues, $config)
    {
        $values = parent::convertEntityValues($name, $originalValues, $config);

        foreach ($values as $key => $value) {
            if (is_array($value)) {
                // odstraníme hodnotu 0
                $values[$key] = array_values(array_diff($value, ['0']));
                // když je pak celý pole prázdné, tak ho odstraníme
                if (count($values[$key]) == 0) {
                    unset($values[$key]);
                }
            }
        }

        return $values;
    }
}
