<?php

/**
 * Převodník pro Realsoft.sk.
 *
 * Většina logiky je ale v INI souboru.
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_RealsoftSk extends Dalten_Export_AbstractExport
{
    /**
     * Vrací je-li v poli $data zaškrtnuté pole $fieldName jako multicheckbox na hodnotě $value.
     *
     * @param array  $data      Pole s daty.
     * @param string $fieldName Název políčka.
     * @param int    $value     Pořadí zašktávátka.
     *
     * @return bool Je to tak?
     */
    private function _isMultiChecked(array $data, $fieldName, $value)
    {
        if (isset($data[$fieldName])) {
            if (substr($data[$fieldName], $value, 1) == 1) {
                return true;
            }
        }

        return false;
    }

    /**
     * {@inheritdoc}
     */
    protected function _convert(array $convertedValues, array $originalvalues, $entityName)
    {
        if ($entityName == 'object') {
            $convertedValues['video_id'] = Dalten_Export_Helper_YoutubeIdExtractor::extractYoutubeId($originalvalues['nemovitost_virtualni_prohlidka']);
            $youtubeId = Dalten_Export_Helper_YoutubeIdExtractor::extractYoutubeId($originalvalues['nemovitost_url_videoprohlidka']);
            if ($youtubeId) {
                $convertedValues['video_id'] = $youtubeId;
            }
            $convertedValues['virtualtour_id'] = '';
            $matterportId = Dalten_Export_Helper_MatterportIdExtractor::extractMatterportId($originalvalues['nemovitost_virtualni_prohlidka']);
            if ($matterportId) {
                $convertedValues['virtualtour_id'] = $originalvalues['nemovitost_virtualni_prohlidka'];
            }
            $matterportId = Dalten_Export_Helper_MatterportIdExtractor::extractMatterportId($originalvalues['nemovitost_url_virtualni_prohlidka']);
            if ($matterportId) {
                $convertedValues['virtualtour_id'] = $originalvalues['nemovitost_url_virtualni_prohlidka'];
            }

            $convertedValues = $this->_convertTopeni($convertedValues, $originalvalues);

            $convertedValues['adv_school'] = // škola nebo školka:
                $this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 0) ||
                $this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 1);

            $convertedValues['adv_hospital'] = $this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 2);
            $convertedValues['adv_bus'] = $this->_isMultiChecked($originalvalues, 'nemovitost_doprava', 3);

            $convertedValues['adv_shopping'] = // supermarket a kompletní síť obchodů a služeb
                $this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 4) ||
                $this->_isMultiChecked($originalvalues, 'nemovitost_obcanska_vybavenost', 5);

            $convertedValues['adv_silence'] = $this->_isMultiChecked($originalvalues, 'nemovitost_umisteni_objektu', 2);

        }

        return parent::_convert($convertedValues, $originalvalues, $entityName);
    }

    /**
     * Převede údaje o topení. Rozlišuje mezi ústředním a lokálním.
     *
     * @param array $convertedValues Pole převedených hodnot entity.
     * @param array $originalvalues  Pole původních (nepřevedených) hodnot entity.
     *
     * @return mixed Upravené hodnoty s přidaným topením.
     */
    protected function _convertTopeni($convertedValues, $originalvalues)
    {
        $nemovitost_topeni = $originalvalues['nemovitost_topeni'];

        $convertedValues['heating_local'] = 0;
        $convertedValues['heating_central'] = 0;

        if (substr($nemovitost_topeni, 0, 1) == "1" || substr($nemovitost_topeni, 1, 1) == "1" || substr($nemovitost_topeni, 2, 1) == "1") {
            $convertedValues['heating_local'] = 1;
        }
        if (substr($nemovitost_topeni, 3, 1) == "1" || substr($nemovitost_topeni, 4, 1) == "1" || substr($nemovitost_topeni, 5, 1) == "1" || substr($nemovitost_topeni, 6, 1) == "1") {
            $convertedValues['heating_central'] = 1;
        }

        return $convertedValues;
    }
}
