<?php
/**
 * Rozhraní Http klienta.
 *
 * @category Dalten
 * @package  Http
 */
interface Dalten_Http_ClientInterface
{
	/**
	 * Stáhne obsah z URL metodou GET.
	 *
	 * @param string $url URL kterou chceme stáhnout.
	 *
	 * @return string Stažený obsah.
	 */
	public function get($url);

	/**
	 * Pošle data na URL metodou POST, jako kdyby se posílal formulář.
	 *
	 * @param string $url   URL kam chceme posílat.
	 * @param array  $data  Pole dat která chceme poslat.
	 * @param array  $files Pole absolutních cest k souborům na odeslání. Nemusí být vyplněno.
	 *
	 * @return string Co vrátil server.
	 */
	public function post($url, array $data, $files=array());

	/**
	 * Nastaví uživatelské jméno a heslo pro zaheslované stránky.
	 *
	 * @param string $login    Uživatelské jméno.
	 * @param string $password Heslo.
	 *
	 * @return Dalten_Http_ClientInterface Fluent interface.
	 */
	public function setAuth($login, $password);

	/**
	 * Nastaví HTTP hlavičku posílanou tímto HTTP klientem.
	 *
	 * POZOR! Pokud se používá autorizace, přidává vlastní hlavičku.
	 *
	 * @param string      $name  Jméno HTTP hlavičky.
	 * @param string|null $value Obsah HTTP hlavičky. Pokud není vyplněno, klient hlavičku odnastaví.
	 *
	 * @return Dalten_Http_ClientInterface Fluent interface.
	 */
	public function setHeader($name, $value=null);
}
