<?php
/**
 * XML šablona pro export na globální Remax.
 *
 * POZOR! Tahle šablona zároveň funguje jako normální XML element.
 *
 * @category Dalten
 * @package  Xml
 */
class Dalten_Xml_Template_RexTranslations extends Dalten_Xml_Template_Element
{
	/**
	 * @var array Převodní tabulka kódů jazyků - od nás k nim.
	 */
	protected $_kodyJazyku = array(
		8 =>1, //English
		12 => 2, //French
		6 => 3, //German
		//4, //Dutch
		36 => 6, //Hebrew
		14 => 8, //Italian
		22 => 9, //Portuguese
		23 => 9, //Portuguese
		9 => 12, //Spanish
		30 => 13, //Turkish
		31 => 14, //Greek
		19 => 15, //Norwegian
		28 => 16, //Swedish
		// 17, //Cantonese
		13 => 18, //Croatian
		// 19, //Farsi
		// 20, //Gaelic
		//21, //Indian
		//22, //Catalau
		5 => 23, //Danish
		27 => 24, //Finnish
		42 => 25, //Gujarati
		// 26, //Hindi
		16 => 28, //Latvian
		52 => 29, //Korean
		17 => 30, //Lithuanian
		47 => 31, //Malayalam
		// 32, //Maltese
		// 33, //Mandarin
		// 34, //Swati
		// 35, //Filipino
		// 36, //Persian
		// 37, //Punjabi
		33 => 38, //Serbian
		18 => 39, //Hungarian
		24 => 40, //Romanian
		// 41, //Shanghainese
		// 42, //Shingala
		21 => 43, //Polish
		32 => 44, //Russian
		// 45, //Sotho
		51 => 47, //Japanese
		25 => 49, //Slovak
		48 => 50, //Thai
		// 51, //Xhosa
		// 54, //Yiddish
		/// 56, //Zulu
		// 57, //Afrikaans
		38 => 58, //Arabic
		// 59, //Armenian
		35 => 64, //Bulgarian
		50 => 66, //Chinese
		4 => 67, //Czech
		15 => 69, //Icelandic
		44 => 75, //Tamil
		// 81, //Sign Language
		49 => 82, //Taiwanese
		34 => 83, //Ukranian
		29 => 84, //Vietnamese
		// 85, //Yugoslavian
		// 86, //Luxembourgish
		// 87, //Urdu
		// 88, //Canadian French
		// 89, //Kanada
		// 90, //Sinhalese
		// 91, //Macedonian
		// 92, //Spanish (Argentina)
		// 93, //Serbian - Serbia (Latin)
		26 => 94, //Slovenian
		7 => 95, //Estonian
		// 96, //Albanian
		// 97, //Montenegrin
		// 98, //Bosnian - Bosnia
	);

	/**
	 * Převede pole překladů na odpovídající tagy.
	 *
	 * Vstupní pole je v proměné $data['translations'] je ve stejném tvaru jako tabulka nabidka_preklad.
	 *
	 * POZOR! Tahle šablona zároveň funguje jako normální XML element.
	 *
	 * @param SimpleXMLElement $rootElement Rodičovský element.
	 * @param array            $data        Vstupní data.
	 *
	 * @return null|SimpleXMLElement Výsledný tag s překlady.
	 */
	public function fill(SimpleXMLElement $rootElement, array $data)
	{
		$translations = array();

		if (isset($data[$this->_variableName])) {
			$this->_forcedPresence = true;
			$translations = $data[$this->_variableName];
		}

		$childElement = $rootElement->addChild($this->_name);

		foreach ($this->_attributes as $attribute) {
			/**  @var $attribute Dalten_Xml_Template_Attribute */
			$attribute->fill($childElement, $data);
		}

		foreach ($this->_children as $child) {
			/** @var $child Dalten_Xml_Template_Element */
			$child->fill($childElement, $data);
		}

		if (count($translations)>0) {
			foreach ($translations as $row) {
				if (!empty($row['nemovitost_popis_detailni']) && isset($this->_kodyJazyku[$row['id_jazyk']])) {
					$kod = $this->_kodyJazyku[$row['id_jazyk']];
					$description = $childElement->addChild('PropertyDescription');
					$description->addChild('LanguageID')->addAttribute('LanguageID', $kod);
					$description->addChild('DescriptionText', $row['nemovitost_popis_detailni'] );
				}
			}
		}



		return $childElement;
	}

}