<?php
/**
 * Převodník z adresního sytému Irestů (UIR) do adresního systému používaného globálním RE/MAXem.
 *
 * @category Dalten
 * @package  AdressConverter
 */
interface Dalten_AddressConverter_Rex_Interface extends Dalten_AddressConverter_Interface
{
	/**
	 * Vrátí, zda jsme schopni tuto adresu převést.
	 *
	 * Vrací false, pokud pro daný stát nemáme číselníky.
	 *
	 * @param array $input (Původní) informace o nemovitosti.
	 *
	 * @return bool Jsme schopni tuto adresu převést?
	 */
	function isValidRegion(array $input);

	/**
	 * Převede adresu a vrátí CityID.
	 *
	 * @param array $originalData Pole které obsahuje prvky adresy
	 *                            (nemovitost_uir_okres_kod a nemovitost_uir_obec_kod).
	 *
	 * @return int Převedené CityID.
	 */
	function convertCityID(array $originalData);
}