<?php
/**
 * Pomocná třída rozšiřující SimpleXML o některé užitečné funkce.
 *
 * @category Dalten
 * @package  Xml
 */
class Dalten_Xml_SimpleXml extends SimpleXMLElement
{
	/**
	 * Přidá CDATA sekci na XML uzel. Zdroj {@link http://coffeerings.posterous.com/php-simplexml-and-cdata}
	 *
	 * @param string $cdataText Text který bude vložen do sekce CDATA
	 */
	public function addCData($cdataText)
	{
		$node = dom_import_simplexml($this);
		$no = $node->ownerDocument;
		$node->appendChild($no->createCDATASection($cdataText));
	}

	/**
	 * Přidá potomka XML uzlu. Na rozdíl od originální funkce naší nevadí znak '&'.
	 *
	 * @param string $name      Název nového uzlu.
	 * @param null   $value     Hodnota nového uzlu (nebo null pokud chcete prázdný).
	 * @param null   $namespace Namespace
	 *
	 * @return Dalten_Xml_SimpleXml
	 */
	public function addChild($name, $value = null, $namespace = null)
	{
		$child = parent::addChild($name, null, $namespace);
		if ($value !== null) {
			$child[0] = $value;
		}
		return $child;
	}

	/**
	 * Uloží XML na více řádků. To se může hodit na validaci.
	 *
	 * @param string $fileName Jméno souboru kam ukládáme.
	 *
	 * @return bool Zda se povedlo uložit.
	 */
	public function saveMultilineXML($fileName)
	{
		$formattedXML = $this->getMultilineXml();
		$written = file_put_contents($fileName, $formattedXML);
		if ($written === false) {
			return false;
		}
		return true;
	}

	/**
	 * Vrací zformátované XML.
	 *
	 * @return string Zformátované XML.
	 */
	public function getMultilineXml()
	{
		$data = $this->asXML();
		$dom = new DOMDocument();
		$dom->loadXML($data);
		$dom->formatOutput = true;
		return $dom->saveXML();
	}
}
