<?php
// tento sestaví dokumentaci číselníků pro nehnutelnosti.sk
// (dokumentaci číselníků převedeme z xml na markdown)
$apiKey = '1ab92deaac3fd72e2183ef3c554f3fdf80';

require dirname(__FILE__) . '/../../lib/Serenity/Common/ClassLoader.php';

$classLoader = new Serenity_Common_ClassLoader();
$classLoader->addClassDir(dirname(__FILE__) . '/../../lib');
$classLoader->enableAutoloading(true);

class dragonSyndrome
{
	protected  $_cachePath = '';

	function __construct($cachePath)
	{
		if (!file_exists($cachePath)) {
			mkdir($cachePath, 0777, true);
		}
		$this->_cachePath = $cachePath;
	}

	function down($URL)
	{
		$localPath = $this->_cachePath . '/' . urlencode($URL);
		if (file_exists($localPath)) {
			return file_get_contents($localPath);
		}
		$ctx = file_get_contents($URL);
		if ($ctx) {
			file_put_contents($localPath, $ctx);
		}
		return $ctx;
	}
}

$categoriesMatcher = Atrox\Matcher::multi('//lookuptable', array(
	'idCategory' => 'idCategory',
	'name' => 'name'
))->fromXml();

$paramsMatcher = Atrox\Matcher::multi('//lookuptable', array(
	'param' => 'param',
	'idParam' => 'idParam',
	'name' => 'name',
	'mandatory' => 'mandatory'
))->fromXml();

$paramsValuesMatcher = Atrox\Matcher::multi('//lookuptable', array(
	'idVal' => 'idVal',
	'name' => 'name'
))->fromXml();

$dragon = new dragonSyndrome(dirname(__FILE__) . '/cache');

$categoriesXML = $dragon->down('http://www.nehnutelnosti.sk/api/export/'.$apiKey.'/categories');

$categories = $categoriesMatcher($categoriesXML);

foreach ($categories as $category) {
	echo ' - ' . $category['name'] . PHP_EOL;
}
echo '---'. PHP_EOL;

$moo = array();

foreach ($categories as $category) {
	$parametersXML = $dragon->down('http://www.nehnutelnosti.sk/api/export/'.$apiKey.'/categoryParameters/'. $category['idCategory']);

	echo '# ' . $category['name'] . '(' . $category['idCategory'] . ')' . PHP_EOL . PHP_EOL;

	$parameters = $paramsMatcher($parametersXML);

	foreach ($parameters as $param) {

		$moo[$param['name']][$category['name']] = $param['idParam'];

		echo '## ' . $param['name'] . ($param['mandatory']? '\\*' : '') .   ' (param'.$param['param'].')' . PHP_EOL . PHP_EOL;

		if ($param['idParam']==102) {
			// přeskakujeme výpis okresů
			echo '...' . PHP_EOL;
			continue;
		}

		$paramValuesXML = $dragon->down('http://www.nehnutelnosti.sk/api/export/'.$apiKey.'/parameterValues/'.$param['idParam']);
		if (!empty($paramValuesXML)) {
			$paramValues = $paramsValuesMatcher($paramValuesXML);

			foreach ($paramValues as $val) {
				echo ' - ' .$val['idVal'] . ' - ' . $val['name'] . PHP_EOL;
			}

			echo PHP_EOL;
		}
	}

	echo '---' . PHP_EOL . PHP_EOL;

}

echo '<table><tr><td></td>';
foreach ($categories as $category) {
	echo '<th>' .$category['name'] . '</th>';
}
echo '</tr>';
foreach ($moo as $param=>$byCategories) {
	echo '<tr>';
	echo '<td>' . $param .  '</td>';
	foreach ($categories as $category) {
		if (isset($byCategories[$category['name']])) {
			echo '<td>'.$byCategories[$category['name']].'</td>';
		} else {
			echo '<td></td>';
		}
	}
	echo '</tr>';
}
echo '</table>';
