% Exportní rozhraní pro Realitniprostor.cz

## Rozdíly

Veškeré metody zmíněné v původní dokumentaci zůstávají nezměněné s dvěma výjimkami:

- Metoda `addNabidka` nyní neposílá pole `priloha` s informacemi o fotografiích. Místo toho se s fotografiemi zachází
  pomocí metod `listPhoto`, `addPhoto` a `delPhoto`, pokud chcete importovat fotografie, musíte implementovat tyto metody.
- Metoda `addUzivatel` je zdokumentována. Fotografie makléře je součástí požadavku, posílá se zakódovaná v base64

## Chování exportu fotografií

Export si po vyexportování nabídky nejprve vypíše fotografie na portále pomocí metody `listPhoto` a srovná je
s fotografiemi přítomnými v Irestu. Pokud se liší, provede pomocí volání metod `addPhoto` a `delPhoto` synchronizaci.

## Metody

Odpověď každé metody zmíněné v tomto dokumentu má následující strukturu:

- `status as int` - pokud proběhla metoda úspěšně, hodnotou je číslo `200`
- `statusMessage as string` - chybová hláška
- `output` - závislé na typu metody

### listPhoto

`listPhoto(session_id as string, nabidka_id as int) as struct`

Vrací strukturu odpovědi s položkou `output`, ve které je pole struktur fotografií u dané nabídky. Každá struktura
fotografie obsahuje následující položky:

 - `photo_id as int` - ID fotografie předané předtím z Irestu

Fotografie v odpovědi jsou seřazeny podle pořadí v galerii.

### addPhoto

`addPhoto(session_id as string, nabidka_id as int, photo as struct) as struct`

Přidá fotografii k dané nabídce. Struktura fotografie má následující položky:

- `photo_id as int` - ID fotografie z Irestu
- `poradi as int` - pořadí fotografie v galerii
- `popis as string` - popisek fotografie
- `data as base64` - fotografie ve formátu JPEG zakódovaná jako base64.

Pokud fotografie s daným `photo_id` již existuje, je aktualizována.

### delPhoto

`delPhoto(session_id as string, photo_id as int) as struct`

Smaže danou fotografii z portálu.

### addUzivatel

`addUzivatel(session_id as string, uzivatel as struct) as struct`

Přidá uživatele. Struktura uživatele má následující položky:

- `id as string` - ID uživatele v Irestu
- `id_pobocka as string` - ID pobočky v Irestu
- `id_uroven as string` - ID úrovně uživatele v Irestu
- `email as string` - exportovaný e-mail
- `telefon as string` - telefoní číslo makléře
- `uzivatel_os_jmeno as string` - křestní jméno makléře
- `uzivatel_os_prijmeni as string` - příjmení makléře
- `exportovat_foto as string` - příznak, zda exportuje fotografie makléře. Posílá se `1` pokud se exportuje, `0` pokud
  se neexportuje.
- `foto as base64` - fotografie makléře zakódovaná jako base64. Pozor - foto nemusí být přítomno.

Pokud uživatel s daným `id` již existuje, je aktualizován.

Změna proti původnímu exportu na vlastní: fotografie je součástí požadavku, posílá se zakódovaná v base64.

## Ukázka komunikace

V tomto příkladu si po aktualizaci údajů nabídky č. 149 nechá export vypsat seznam fotografií.

Následně odebere fotografii č. 418 a přidá fotografie č. 420. Fotografie č. 417, která byla na serveru přítomná již
dříve, zůstává beze změny.

```
METHOD CALL: listPhoto called @ 27.6.2014 10:46:30
METHOD DATA:
<?xml version="1.0" encoding="UTF-8"?>
<methodCall>
<methodName>listPhoto</methodName>
<params>
 <param>
  <value>
   <struct>
    <member>
     <name>session_id</name>
     <value>
      <string>3f2093d46e7839b76e725cd66f58e3a6</string>
     </value>
    </member>
    <member>
     <name>nabidka_id</name>
     <value>
      <int>149</int>
     </value>
    </member>
   </struct>
  </value>
 </param>
</params>
</methodCall>

==========

SERVER RESPONSE: listPhoto retrieved @ 27.6.2014 10:46:30
RESPONSE DATA  :
<?xml version="1.0" ?>
<methodResponse>
	<params>
		<param>
			<value>
				<struct>
					<member>
						<name>status</name>
						<value>
							<int>200</int>
						</value>
					</member>
					<member>
						<name>statusMessage</name>
						<value>
							<string>OK</string>
						</value>
					</member>
					<member>
						<name>output</name>
						<value>
							<array>
								<data>
									<value>
										<struct>
											<member>
												<name>photo_id</name>
												<value>
													<int>418</int>
												</value>
											</member>
										</struct>
									</value>
									<value>
										<struct>
											<member>
												<name>photo_id</name>
												<value>
													<int>417</int>
												</value>
											</member>
										</struct>
									</value>
								</data>
							</array>
						</value>
					</member>
				</struct>
			</value>
		</param>
	</params>
</methodResponse>

==========

METHOD CALL: delPhoto called @ 27.6.2014 10:46:30
METHOD DATA:
<?xml version="1.0" encoding="UTF-8"?>
<methodCall>
<methodName>delPhoto</methodName>
<params>
 <param>
  <value>
   <struct>
    <member>
     <name>session_id</name>
     <value>
      <string>3f2093d46e7839b76e725cd66f58e3a6</string>
     </value>
    </member>
    <member>
     <name>photo_id</name>
     <value>
      <int>418</int>
     </value>
    </member>
   </struct>
  </value>
 </param>
</params>
</methodCall>

==========

SERVER RESPONSE: delPhoto retrieved @ 27.6.2014 10:46:30
RESPONSE DATA  :
<?xml version="1.0" ?>
<methodResponse>
	<params>
		<param>
			<value>
				<struct>
					<member>
						<name>status</name>
						<value>
							<int>200</int>
						</value>
					</member>
					<member>
						<name>statusMessage</name>
						<value>
							<string>OK</string>
						</value>
					</member>
				</struct>
			</value>
		</param>
	</params>
</methodResponse>

==========

METHOD CALL: addPhoto called @ 27.6.2014 10:46:30
METHOD DATA:
<?xml version="1.0" encoding="UTF-8"?>
<methodCall>
<methodName>addPhoto</methodName>
<params>
 <param>
  <value>
   <struct>
    <member>
     <name>session_id</name>
     <value>
      <string>3f2093d46e7839b76e725cd66f58e3a6</string>
     </value>
    </member>
    <member>
     <name>nabidka_id</name>
     <value>
      <int>149</int>
     </value>
    </member>
    <member>
     <name>photo</name>
     <value>
      <struct>
       <member>
        <name>photo_id</name>
        <value>
         <string>420</string>
        </value>
       </member>
       <member>
        <name>poradi</name>
        <value>
         <int>1</int>
        </value>
       </member>
       <member>
        <name>popis</name>
        <value>
         <string>celkový pohled</string>
        </value>
       </member>
       <member>
        <name>data</name>
        <value>
         <base64>/9j/4AAQSkZJRgABAQAAAQABAAD//gA7Q1JFQVRPUjogZ2QtanBlZyB2MS4wICh1c2luZyBJ
... (zkráceno) ...
j8aXc3dVoooAN3qooJz1oooA//Z
</base64>
        </value>
       </member>
      </struct>
     </value>
    </member>
   </struct>
  </value>
 </param>
</params>
</methodCall>

==========

SERVER RESPONSE: addPhoto retrieved @ 27.6.2014 10:46:30
RESPONSE DATA  :
<?xml version="1.0" ?>
<methodResponse>
	<params>
		<param>
			<value>
				<struct>
					<member>
						<name>status</name>
						<value>
							<int>200</int>
						</value>
					</member>
					<member>
						<name>statusMessage</name>
						<value>
							<string>OK</string>
						</value>
					</member>
				</struct>
			</value>
		</param>
	</params>
</methodResponse>

==========

```



