<?php

/**
 * Jednoduchý logger, který vyechuje volání do konzole.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Backend
 */
class Dalten_Export_Api_Backend_Logger_Echo implements Dalten_Export_Api_Backend_Logger_LoggerInterface
{
	/**
	 * Zaloguje volání vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName Název volané metody.
	 * @param mixed  $data       Data se kterými je metoda volána.
	 */
	public function logRemoteCall($methodName, $data)
	{
		echo 'METHOD CALL: ', $methodName, ' called @ ', date('j.n.Y H:i:s'), PHP_EOL;
		echo 'METHOD DATA: ', PHP_EOL, print_r($data, true);
		echo PHP_EOL, '==========', PHP_EOL, PHP_EOL;
	}

	/**
	 * Zaloguje odpověď vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName  Název volané metody.
	 * @param mixed  $reponseData Odpověď serveru.
	 */
	public function logRemoteResponse($methodName, $reponseData)
	{
		echo 'SERVER RESPONSE: ', $methodName, ' retrieved @ ', date('j.n.Y H:i:s'), PHP_EOL;
		echo 'RESPONSE DATA  :', PHP_EOL, print_r($reponseData, true);
		echo PHP_EOL, '==========', PHP_EOL, PHP_EOL;
	}
}
