<?php

class Dalten_Export_Helper_MatterportIdExtractor
{
    /**
     * Získá matterport id z url.
     *
     * Pokud url není na matterport, vrátí prázdný string.
     *
     * @param mixed $url
     *
     * @return string
     */
    public static function extractMatterportId($url)
    {
        if (empty($url) || !is_string($url)) {
            return '';
        }

        if (strpos($url, 'http') === false) {
			$url = sprintf('http://%s', $url);
		}

        // https://my.matterport.com/show/?m=pGSH9wuaKZH
        $parsedUrl = parse_url($url);
        if ($parsedUrl['host'] == 'my.matterport.com' && trim($parsedUrl['path'], '/') == 'show') {
            $parameters = [];
            parse_str($parsedUrl['query'], $parameters);
            if (!empty($parameters['m'])) {
                return $parameters['m'];
            }
        }

        return '';
    }

    /**
     * Normalizuje matterport url.
     *
     * Pokud url není na matterport, vrátí prázdný string.
     *
     * @param mixed $url
     *
     * @return string
     */
    public static function normalizeMatterportUrl($url)
    {
        $id = self::extractMatterportId($url);

        return $id ? sprintf('https://my.matterport.com/show/?m=%s', $id) : '';
    }
}
