<?php
/**
 * Export do formátu reality.cz.
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_RealityCzNew extends Dalten_Export_RealityCz
{
	/**
	 * Umožňuje exportu upravit položky po jejich převedení pomocí processeru..
	 *
	 * @param array  $convertedValues Pole převedených hodnot entity.
	 * @param array  $originalvalues  Pole původních (nepřevedených) hodnot entity.
	 * @param string $entityName      Název entity.
	 *
	 * @return array Výsledné pole hodnot.
	 */
	protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if (isset($convertedValues['vsBaseParameters']['Z_DRUH_NEMOVITOSTI_0'])) {
			$typeVal = $convertedValues['vsBaseParameters']['Z_DRUH_NEMOVITOSTI_0'];
			switch($typeVal) {
				case 333:
					$subType = (int) $originalvalues['nemovitost_druh_pozemku'];
					if (\in_array($subType, array(3, 4, 5, 6, 7))) {
						$typeVal = 1;
					} elseif ($subType === 1) {
						$typeVal = 4;
					} else {
						$typeVal = 3;
					}
					break;
				case 444:
					$area = (int) $originalvalues['nemovitost_plocha_celkova'];

					if ($area > 85) {
						$typeVal = 7;
					} elseif ($area > 45) {
						$typeVal = 6;
					} else {
						$typeVal = 5;
					}

					break;
				case 555:
					$subType = (int) $originalvalues['nemovitost_ucel_budovy'];

					if (in_array($subType, array(1, 2, 6))) { // sklad, výroba, jiný
						$typeVal = 18;
						 // živnostenské provozovny, servisy, jednotlivé výrobní a skladovací objekty včetně zemědělských
					} elseif (in_array($subType, array(3, 4, 7))) { // oc, nc, adm. budova
						$typeVal = 16;
						// administrativní budovy, obchodní budovy a jiné objekty tzv. občanské vybavenosti včetně kultury, sportu, školství, zdravotnictví apod.
					} elseif (in_array($subType, array(5))) { // prům. areál
						$typeVal = 19;
						// větší výrobní celky zpravidla s objekty různých funkcí zajišťující ucelený výrobní proces, skladové areály apod.
					}

					break;
				case 999:
					$subType = (int) $originalvalues['nemovitost_druh_prostor'];
					if (\in_array($subType, array(3, 5))) {
						$typeVal = 17;
					} else {
						$typeVal = 14;
					}
					break;
				default:
					break;
			}

			$convertedValues['vsBaseParameters']['Z_DRUH_NEMOVITOSTI_0'] = $typeVal;
		}

		//  Z_CENA_PRODEJE_JEDNOTKA
		if (isset($convertedValues['vsOptionalParameters']['Z_CENA_PRODEJE_JEDNOTKA'])) {
			// prevod je nese 1 => 1; 2 => 3
			$finalUnit = 2;
			$unit = (int) $convertedValues['vsOptionalParameters']['Z_CENA_PRODEJE_JEDNOTKA'];
			if ($unit === 3) {
				$finalUnit = 1;
			}
			// podle meny pricteme pro USD +4; EUR + 6
			$currency = (int) $originalvalues['nemovitost_mena'];
			switch ($currency) {
				case 2:
					$finalUnit = $finalUnit + 4;
					break;
				case 3:
					$finalUnit = $finalUnit + 6;
					break;
				default:
					break;
			}

			$convertedValues['vsOptionalParameters']['Z_CENA_PRODEJE_JEDNOTKA'] = $finalUnit;
		}

		//  Z_CENA_PRONAJMU_JEDNOTKA
		if (isset($convertedValues['vsOptionalParameters']['Z_CENA_PRONAJMU_JEDNOTKA'])) {
			$finalUnit = 1;
			$unit = (int) $convertedValues['vsOptionalParameters']['Z_CENA_PRONAJMU_JEDNOTKA'];
			$trans = array(
				2 => 4,
				4 => 2,
				5 => 1,
				6 => 3
			);
			if (isset($trans[$unit])) {
				$finalUnit = $trans[$unit];
			}
			// podle meny pricteme pro USD +8; EUR + 12
			$currency = (int) $originalvalues['nemovitost_mena'];
			if ($currency === 2) {
				$finalUnit = $finalUnit + 8;
			}
			if ($currency === 3) {
				$finalUnit = $finalUnit + 12;
			}
			$convertedValues['vsOptionalParameters']['Z_CENA_PRONAJMU_JEDNOTKA'] = $finalUnit;
		}

		$convertedValues['vsOptionalParameters']['Z_MISTO_ZEME'] = strtolower($originalvalues['nemovitost_uir_stat']);

		$convertedValues['vsOptionalParameters']['Z_GARAZ'] =
			$this->_areasCombo($originalvalues['nemovitost_garaz'], $originalvalues['nemovitost_garaz_plocha']);

		$convertedValues['vsOptionalParameters']['Z_SKLEP'] =
			$this->_areasCombo($originalvalues['nemovitost_sklep'], $originalvalues['nemovitost_sklep_plocha']);

		if (isset($originalvalues['nemovitost_parkovaci_stani'])) {
			$convertedValues['vsOptionalParameters']['Z_PARKOVANI'] =
				$this->_areasCombo(
					$originalvalues['nemovitost_parkovaci_stani'],
					$originalvalues['nemovitost_parkovaci_stani_plocha']
				);
		}

        $matterportId = Dalten_Export_Helper_MatterportIdExtractor::extractMatterportId($originalvalues['nemovitost_virtualni_prohlidka']);
        if ($matterportId) {
            $convertedValues['vsOptionalParameters']['VIRT_PROHLIDKA_KOD'] = $matterportId;
            $convertedValues['vsOptionalParameters']['VIRT_PROHLIDKA_TYP'] = 9;

        }

        $youtubeId = Dalten_Export_Helper_YoutubeIdExtractor::extractYoutubeId($originalvalues['nemovitost_video_prohlidka']);
        if ($youtubeId) {
		    $convertedValues['vsOptionalParameters']['YOUTUBE_ID'] = $youtubeId;

        }

		return $convertedValues;
	}

	/**
	 * Zformátuje údeje typu Ano/Ne + Plocha do lidsky čitelné podoby.
	 *
	 * @param int $param Zda prvek plochu obsahuje.
	 * @param int $area  Kolik je případná plocha prvku.
	 *
	 * @return string Zformátovaná plocha, například "Ano (62m2)" či "" pokud plocha není vyplněna.
	 */
	private function _areasCombo($param, $area)
	{
		$value = '';
		if ($param == 1) {
			$value = 'Ano';
			if ($area) {
				$value .= ' (' . $area . ' m2)';
			}
		}

		return $value;
	}
}
