<?php
/**
 * Šablona XML elementu pro export na Remax/global.
 *
 * Opt uzly u globálního remaxu jsou vlastně obyčejné uzly ve tvaru:
 *
 * <code>
 * &lt;name name="value"/&gt
 * </code>
 *
 * @category Dalten
 * @package  Xml
 */
class Dalten_Xml_Template_Opt extends Dalten_Xml_Template_Attribute
{
	/**
	 * {@inheritdoc}
	 */
	public function fill(SimpleXMLElement $rootElement, array $data)
	{
		if ($this->_hasEmptyValue($data)) {
			return null;
		}
		$container = $rootElement->addChild($this->_name);
		$container->addAttribute($this->_name, $this->_guardFloatIfNeeded($data[$this->_variableName]) );
		return $container;
	}
}