<?php

class ToprealityskTest extends \PHPUnit\Framework\TestCase
{
    private $export = null;

    /**
     * @var Serenity_Config_Config
     */
    private $entities = null;

    private $data = array(
        'id' => 1,
        'id_nabidka' => '1',
        'id_uzivatel' => 56943,
        'id_team' => 1,
        'id_pobocka' => 1,
        'id_firma' => 1,
        'id_projekt' => 0,
        'cislo' => '1',
        'kod' => 'N00001',
        'id_klient' => '1',
        'nemovitost_anuita' => '0',
        'nemovitost_anuita_mena' => '0',
        'nemovitost_balkon_plocha' => '0',
        'nemovitost_balkon' => '0',
        'nemovitost_bazen_plocha' => '0',
        'nemovitost_bazen' => '0',
        'nemovitost_bezbarierovy' => '-1',
        'nemovitost_bytu_celkem' => '0',
        'nemovitost_bytu_pocet' => '0',
        'nemovitost_cena_poznamka' => '',
        'nemovitost_cena_prodej' => '1.50',
        'nemovitost_cena_prodej_jednotka' => '1',
        'nemovitost_cena_pronajem' => '12000.50',
        'nemovitost_cena_pronajem_jednotka' => '2',
        'nemovitost_cena_datum_snizeni' => '',
        'nemovitost_charakter_zastavby' => '0',
        'nemovitost_dalsi_nebytove_prostory' => '',
        'nemovitost_datum_nastehovani' => '2011-01-01',
        'nemovitost_delka' => '0',
        'nemovitost_dispozice' => '4',
        'nemovitost_doprava' => '0001',
        'nemovitost_druh_bytu' => '0',
        'nemovitost_druh_objektu' => '3',
        'nemovitost_druh_pozemku' => '0',
        'nemovitost_druh_prostor' => '0',
        'nemovitost_druh_stavby' => '0',
        'nemovitost_elektrina' => '',
        'nemovitost_garaz_plocha' => '0',
        'nemovitost_garaz' => '-1',
        'nemovitost_parkovaci_stani' => '-1',
        'nemovitost_parkovaci_stani_plocha' => '0',
        'nemovitost_inzenyrske_site' => '0110',
        'nemovitost_komunikace' => '0',
        'nemovitost_konstrukcni_prvky' => '',
        'nemovitost_lodzie_plocha' => '10',
        'nemovitost_lodzie' => '1',
        'nemovitost_makler_poznamka' => '',
        'nemovitost_mena' => '1',
        'nemovitost_obcanska_vybavenost' => '',
        'nemovitost_odpad' => '',
        'nemovitost_ostatni' => '11111111111',
        'nemovitost_ostatni_nebytove_prosotry_popis' => '',
        'nemovitost_ostatni_rozvody' => '',
        'nemovitost_ostatni_vybavenost' => '',
        'nemovitost_plocha_celkova' => '80',
        'nemovitost_plocha_dalsi_nebytove_prostory' => '0',
        'nemovitost_plocha_dalsi_zelene' => '0',
        'nemovitost_plocha_dilna' => '0',
        'nemovitost_plocha_dilny' => '0',
        'nemovitost_plocha_jine' => '0',
        'nemovitost_plocha_jine_popis' => '',
        'nemovitost_plocha_kancelari' => '0',
        'nemovitost_plocha_nebytovych_prostor' => '0',
        'nemovitost_plocha_nejmensi' => '0',
        'nemovitost_plocha_nejvetsi' => '0',
        'nemovitost_plocha_obchodni' => '0',
        'nemovitost_plocha_obchodu' => '0',
        'nemovitost_plocha_obestavena' => '0',
        'nemovitost_plocha_parcely' => '0',
        'nemovitost_plocha_provozni' => '0',
        'nemovitost_plocha_skladu' => '0',
        'nemovitost_plocha_terasa' => '0',
        'nemovitost_plocha_uzitna' => '100',
        'nemovitost_plocha_uzitna_podkrovi' => '0',
        'nemovitost_plocha_uzitna_prizemi' => '0',
        'nemovitost_plocha_vnejsich_komunikaci' => '0',
        'nemovitost_plocha_vyrobni' => '0',
        'nemovitost_plocha_zahrada' => '6',
        'nemovitost_plocha_zastavena' => '0',
        'nemovitost_plochy_jine_popis' => '',
        'nemovitost_plyn' => '',
        'nemovitost_pocet_bytu_volnych' => '0',
        'nemovitost_pocet_kancelari' => '0',
        'nemovitost_pocet_luzek' => '0',
        'nemovitost_pocet_mist' => '0',
        'nemovitost_pocet_obchodu' => '0',
        'nemovitost_pocet_podlazi' => '10',
        'nemovitost_pocet_podlazi_pod_zemi' => '0',
        'nemovitost_pocet_volnych_kancelari' => '0',
        'nemovitost_podlazi_cislo' => '2',
        'nemovitost_poloha_objektu' => '0',
        'nemovitost_popis_detailni' => 'popis',
        'nemovitost_popis_zakladni' => 'zakldni popis',
        'nemovitost_prodej_vcelku' => '0',
        'nemovitost_pudni_vestavba' => '-1',
        'nemovitost_rok_kolaudace' => '0',
        'nemovitost_rok_rekonstrukce' => '0',
        'nemovitost_rok_vystavby' => '0',
        'nemovitost_schodiste' => '',
        'nemovitost_sirka' => '0',
        'nemovitost_sklep_plocha' => '0',
        'nemovitost_sklep' => '-1',
        'nemovitost_socialni_zarizeni' => '0',
        'nemovitost_socialni_zarizeni_popis' => '',
        'nemovitost_stavba_na_pozemku' => '',
        'nemovitost_stav_objektu' => '2',
        'nemovitost_stromy' => '0',
        'nemovitost_telekomunikace' => '01',
        'nemovitost_terasa_plocha' => '0',
        'nemovitost_terasa' => '0',
        'nemovitost_titulek' => 'Pronájem útulné ropné plošiny v Přerově & přilehlé rafinerie (testovací nabídka)',
        'nemovitost_topeni' => '011',
        'nemovitost_typ' => '4',
        'nemovitost_typ_domu' => '0',
        'nemovitost_typ_zarizeni' => '0',
        'nemovitost_ucel_budovy' => '2',
        'nemovitost_umisteni_objektu' => '0',
        'nemovitost_umisteni_v_chranenych_lokalitach' => '',
        'nemovitost_velikost_bytu' => '',
        'nemovitost_vlastnictvi' => '1',
        'nemovitost_vlastni_pozemek' => '0',
        'nemovitost_voda' => '',
        'nemovitost_vybaveni_byt' => '0',
        'nemovitost_vybaveni_kancelari' => '0',
        'nemovitost_vybaveni_kancelari_popis' => '',
        'nemovitost_vybaveni_komercnich_prostor' => '0',
        'nemovitost_vybaveni_komercnich_prostor_popis' => '',
        'nemovitost_vybaveno' => '1',
        'nemovitost_vybaveno_popis' => '',
        'nemovitost_vyska' => '0',
        'nemovitost_vyska_stropu' => '0',
        'pocet_mist_k_parkovani' => '0',
        'podlazi' => '0',
        'zakazka_datum_editace' => '2010-04-13',
        'zakazka_datum_vlozeno' => '2010-04-13',
        'zakazka_makler' => '0',
        'zakazka_makler_upravil' => '1719',
        'zakazka_stav' => '10',
        'zakazka_typ' => '2',
        'zakazka_obchodovat' => '20',
        'zakazka_obchodovat_provize_castka' => '0.00',
        'zakazka_obchodovat_provize_procenta' => '0.000',
        'zakazka_provize_celkem' => '15000.00',
        'zakazka_provize_procenta' => '107.140',
        'zakazka_provize_typ' => '1',
        'nemovitost_uir_cobce_kod' => '',
        'nemovitost_uir_cobce_text' => '',
        'nemovitost_uir_kraj_kod' => '4',
        'nemovitost_uir_kraj_text' => 'Nitriansky',
        'nemovitost_uir_mcast_kod' => '',
        'nemovitost_uir_mcast_text' => '',
        'nemovitost_uir_obec_kod' => '501026',
        'nemovitost_uir_obec_text' => 'Komárno',
        'nemovitost_uir_okres_kod' => '401',
        'nemovitost_uir_okres_text' => 'Komárno',
        'nemovitost_uir_pobvod_kod' => '0',
        'nemovitost_uir_pobvod_text' => '',
        'nemovitost_uir_ulice_kod' => '501026135',
        'nemovitost_uir_ulice_text' => 'Priemyselná',
        'nemovitost_uir_cp' => '',
        'nemovitost_uir_co' => '',
        'nemovitost_uir_stat' => 'SK',
        'nemovitost_objekt' => '',
        'zakazka_interni_cislo_developera' => '',
        'zakazka_pouzit_foto_projektu' => '0',
        'zakazka_typ_smlouvy' => '20',
        'zakazka_neverejna_poznamka' => '',
        'nemovitost_kauce' => '',
        'smazano' => '0',
        'nabidka_gps_x' => '10.423432',
        'nabidka_gps_y' => '20.13213',
        'nabidka_gps_presnost' => '-1',
        'interni_cislo' => '',
        'zakazka_obchodovani_zpusob' => '0111',
        'nabidka_typ_nabidky' => '',
        'preklad_status' => '0',
        'nastaveni_exportu' => '',
		//'zakazka_detail_url' => ''
		'zakazka_detail_url' => 'http://strajt9.sweb.cz/'
    );

    private $user = array(
        'id' => '123',
        'uzivatel_os_jmeno' => 'D&lten',
        'uzivatel_os_prijmeni' => 'Matlák',
        'sreality_login' => 'bubububububu@seznam.cz',
        'telefon' => '777123456',
        'email' => 'info@dalten.cz',
        'moto' => 'Kdo nekrade, je vůl.',
        'foto' => './assets/lama.jpg'
    );

    private $images = array(
        'statfjord_1.jpg' => array(
            'id' => 1,
            'popis' => 'Foto 1',
            'soubor' => './assets/statfjord_1.jpg',
            'url' => 'http://www.quido.cz/stavby/obrazky/statfjord_2.jpg',
            'poradi' => 1
        ),

        'statfjord_2.jpg' => array(
            'id' => 2,
            'popis' => 'Foto 2',
            'soubor' => './assets/statfjord_2.jpg',
            'url' => 'http://www.quido.cz/stavby/obrazky/statfjord_2.jpg',
            'poradi' => 2
        )
    );

    private $adresaVCechach = array(
        'nemovitost_uir_cobce_kod' => '414255',
        'nemovitost_uir_cobce_text' => 'Přerov I-Město',
        'nemovitost_uir_kraj_kod' => '124',
        'nemovitost_uir_kraj_text' => 'Olomoucký',
        'nemovitost_uir_mcast_kod' => '0',
        'nemovitost_uir_mcast_text' => '',
        'nemovitost_uir_obec_kod' => '511382',
        'nemovitost_uir_obec_text' => 'Přerov',
        'nemovitost_uir_okres_kod' => '3808',
        'nemovitost_uir_okres_text' => 'Přerov',
        'nemovitost_uir_pobvod_kod' => '0',
        'nemovitost_uir_pobvod_text' => '',
        'nemovitost_uir_ulice_kod' => '522554',
        'nemovitost_uir_ulice_text' => 'Kosmákova',
        'nemovitost_uir_cp' => '',
        'nemovitost_uir_co' => '',
        'nemovitost_uir_stat' => 'CZ'
    );

    public function setUp(): void
    {
        $adresar = parse_ini_file(CONFIG_PATH . DIRECTORY_SEPARATOR . 'adresy_toprealitysk.ini', true);
        $iniParser = new Serenity_Config_Parser_Ini();
        $codebooks = new Serenity_Config_Config(CONFIG_PATH . DIRECTORY_SEPARATOR . 'codebooks.ini', $iniParser);
        $this->entities = new Serenity_Config_Config(CONFIG_PATH . DIRECTORY_SEPARATOR . 'toprealitysk.ini', $iniParser);
        $this->export = new Dalten_Export_Toprealitysk($codebooks, $this->entities, null, $adresar);
    }

    public function testExportAndDelete()
    {
        $backend = new Dalten_Export_Api_Backend_Toprealitysk('http://realityexport.sk/import/');
        $api = new Dalten_Export_Api_Toprealitysk($this->export, $this->entities, $backend);

		$loger=new Dalten_Export_Api_Backend_Logger_Echo();

		$api->setLogger($loger);

        $api->openConnection('remaxtest', 'test');

        $response = $api->addListing($this->data, $this->user, $this->images);
        $this->assertTrue($response->wasSuccessful(), $response->getMessage());
        $response = $api->deleteListing($this->data);
        $this->assertTrue($response->wasSuccessful(), $response->getMessage());
    }


	public function testExportHiddenPrice()
	{
		$backend = new Dalten_Export_Api_Backend_Toprealitysk('http://realityexport.sk/import/');
		$api = new Dalten_Export_Api_Toprealitysk($this->export, $this->entities, $backend);

		$loger=new Dalten_Export_Api_Backend_Logger_Echo();

		$api->setLogger($loger);

		$api->openConnection('remaxtest', 'test');

		$response = $api->addListing($this->data, $this->user, $this->images, array( 'listing'=>array('hide_price'=>1) ));
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());
		$response = $api->deleteListing($this->data);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());
	}

    public function testExportDoSpatnehoStatu()
    {
        $backend = new Dalten_Export_Api_Backend_Toprealitysk('http://realityexport.sk/import/');
        $api = new Dalten_Export_Api_Toprealitysk($this->export, $this->entities, $backend);

        $api->openConnection('remaxtest', 'test');

        $data = array_merge_recursive($this->data, $this->adresaVCechach);
        $response = $api->addListing($data, $this->user, $this->images);
        $this->assertFalse($response->wasSuccessful(), $response->getMessage());
    }

	public function testPrevodDat()
	{
		$data=$this->data;
		$data['zakazka_typ']=2; //když je pronájem
		$data['nemovitost_cena_pronajem_jednotka']=7; //a platí se denně
		$data['nemovitost_cena_pronajem']=1; //tak by se cena měla přepočítat na měsíční
		$data['nemovitost_elektrina']='0101';

		$prevedeno = $this->export->convertEntityValues('obj',$data,$this->entities->obj);

		$this->assertEquals(30.5,$prevedeno['price']);
		$this->assertEquals(3,$prevedeno['price_unit']);
		$this->assertEquals(2,$prevedeno['electric']);

		//tohle půjde do jiného testu
		//$this->assertEquals(1,$prevedeno['garden']);


	}

	public function testPrevodUrl(){
		$data=$this->data;

		$prevedeno = $this->export->convertEntityValues('obj',$data,$this->entities->obj);
		$this->assertEquals('http://strajt9.sweb.cz/',$prevedeno['detail_url']);

		$data['zakazka_detail_url'] = 'strajt9.sweb.cz/';
		$prevedeno2 = $this->export->convertEntityValues('obj',$data,$this->entities->obj);
		$this->assertEquals('http://strajt9.sweb.cz/',$prevedeno2['detail_url']);

		$data['zakazka_detail_url'] = '';
		$prevedeno3 = $this->export->convertEntityValues('obj',$data,$this->entities->obj);
		$this->assertFalse(isset($prevedeno3['detail_url']),'Nefunguje unset u detailu url.');
	}

	public function testDesetinneTecky(){
		$originalLocales = setlocale(LC_NUMERIC,0);
		$jsmeVCZ = setlocale(LC_NUMERIC,'cs_CZ');

		$data=$this->data;
		$data['nemovitost_cena_pronajem']=pi();

		$this->assertEquals('cs_CZ',$jsmeVCZ,'Nelze testovat chybu s desetinou tecku/carkou, nemas ceska locale!');

		$prevedeno = $this->export->convertEntityValues('obj',$data,$this->entities->obj);

		$this->assertEquals(sprintf('%F',pi()),$prevedeno['price']);
		$this->assertFalse(strpos($prevedeno['price'],','),'Ochrana desetinne tecky u ceny selhala!');
		setlocale(LC_NUMERIC,$originalLocales);
	}

	public function testFixPlochy(){
		$data=$this->data;

		$data['nemovitost_typ'] = 3;


		$prevedeno = $this->export->convertEntityValues('obj',$data,$this->entities->obj);
		$this->assertEquals($data['nemovitost_plocha_celkova'],$prevedeno['plot_area'], 'Nefunguje fix plochy! Pri pozemku musi byt vyplnena plot_area!');
	}
}

