<?php

/**
 * @category cojako
 */
class Params
{
	/**
	 * Drzak pro data nemovitosti.
	 *
	 * @var array
	 */
	public static $n;

	/**
	 * Držák pro DB
	 *
	 * @var Irest_Database
	 */
	public static $db;

	/**
	 * String reprezentace false
	 *
	 * @var string
	 */
	const FALSE = 'false';

	/**
	 * String reprezentace true
	 *
	 * @var string
	 */
	const TRUE = 'true';

	/**
	 * Seznam typu predmetu nabidky.
	 *
	 * @var array
	 */
	public static $types = array(
		'APARTMENTS',
		'OBJECTS_FOR_LIVING_AND_RECREATION',
		'OBJECTS_FOR_BUSINESS_AND_SERVICES',
		'BUSINESS_PREMISES',
		'SERVICE_OBJECTS',
		'PREMISES',
		'OTHER_PREMISES',
		'BUILDING_SITES',
		'FARM_LANDS'
	);

	/**
	 * 1st level parametry inzeratu
	 *
	 * @var array
	 */
	public static $firstLevelParams = array(
		'adReference',
		'assignedAgentEmail',
		'automaticCancelationDate',
		'containsFloorPlan',
		'exclusive',
		'informationForMls',
		'nextPresentationUrl',
		'noteToPrice',
		'price',
		'priceMeasure',
		'propertyAddress',
		'propertyAvailableFrom',
		'propertyState',
		'propertySubType',
		'providePartOfCommission',
		'providePrice',
		'uniqueIdentifier',
	);

	/**
	 * Datovy typy pro hodnoty 'characteristics'
	 * Ano je to hruza mit duplicitni kod :)
	 *
	 * @var array
	 */
	public static $dataTypes = array(
		'amountOfUnpaidCreadit' => 'decimal',
		'approvalWithExtractionOfAgriculturalLand' => 'boolean',
		'approvedBuildingHeight' => 'decimal',
		'apron' => 'decimal',
		'areaForSport' => 'decimal',
		'balcony' => 'boolean',
		'balconyArea' => 'decimal',
		'basin' => 'boolean',
		'basinLength' => 'decimal',
		'bulkOfBuiding' => 'decimal',
		'busStation' => 'decimal',
		'cableTV' => 'boolean',
		'coniferousForest' => 'decimal',
		'consolidatedDumpingArea' => 'decimal',
		'consolidatedGround' => 'decimal',
		'deciduousForest' => 'decimal',
		'drivewayHeight' => 'integer',
		'drivewayWidth' => 'integer',
		'dwellingPartArea' => 'decimal',
		'elevator' => 'boolean',
		'elevatorLoadRating' => 'integer',
		'entireEstateArea' => 'decimal',
		'entireFloorArea' => 'decimal',
		'entireUsageArea' => 'decimal',
		'expertReport' => 'decimal',
		'fireplace' => 'boolean',
		'firstFloorLoadCapacity' => 'decimal',
		'fitness' => 'boolean',
		'fitnessArea' => 'decimal',
		'floor' => 'integer',
		'floorFrom' => 'integer',
		'frontageWidth' => 'decimal',
		'garage' => 'boolean',
		'gardenHouse' => 'boolean',
		'gardenHouseArea' => 'decimal',
		'greenery' => 'boolean',
		'greeneryArea' => 'decimal',
		'groundInvestigation' => 'boolean',
		'groundOfCovarage' => 'decimal',
		'highway' => 'decimal',
		'installedOutput' => 'integer',
		'internet' => 'boolean',
		'landQuality' => 'integer',
		'liftingCapacityOfCraneBridge' => 'decimal',
		'loadingPlatform' => 'decimal',
		'loggia' => 'boolean',
		'loggiaArea' => 'decimal',
		'lot' => 'decimal',
		'mainRoad' => 'decimal',
		'mixedForest' => 'decimal',
		'natureReservation' => 'boolean',
		'nonResidentialArea' => 'decimal',
		'numberOfAboveGroundFloors' => 'integer',
		'numberOfApartments' => 'integer',
		'numberOfBedrooms' => 'integer',
		'numberOfEmployees' => 'integer',
		'numberOfGarageParkingSpots' => 'integer',
		'numberOfLandParts' => 'integer',
		'numberOfParkingSpots' => 'integer',
		'numberOfRooms' => 'integer',
		'numberOfSublevels' => 'integer',
		'numberOfVacationFlats' => 'integer',
		'onusOfRent' => 'boolean',
		'premisesForBreedingOfAnimals' => 'decimal',
		'preservationOfMonuments' => 'boolean',
		'priceOfBuilding' => 'decimal',
		'priceOfLot' => 'decimal',
		'productionArea' => 'decimal',
		'propellantOutlayPerYear' => 'decimal',
		'protectedZone' => 'decimal',
		'railwayStation' => 'decimal',
		'rentalReturn' => 'decimal',
		'riverPort' => 'decimal',
		'safetyEquipment' => 'boolean',
		'saleSpace' => 'decimal',
		'sauna' => 'boolean',
		'secondFloorLoadCapacity' => 'decimal',
		'separateAccess' => 'boolean',
		'serviceAndPowerCosts' => 'decimal',
		'storageSpace' => 'decimal',
		'technicalBackgroundArea' => 'decimal',
		'terrace' => 'boolean',
		'terraceArea' => 'decimal',
		'thermalInsulationOfBuilding' => 'boolean',
		'thirdFloorLoadCapacity' => 'decimal',
		'totalNumberOfObjects' => 'integer',
		'tramStation' => 'decimal',
		'winterGarden' => 'boolean',
		'winterGardenArea' => 'decimal',
		'workshop' => 'boolean',
		'workshopArea' => 'decimal',
		'yearOfConstruction' => 'integer',
		'yearOfLastReconstruction' => 'integer',
	);

	/**
	 * Ciselnik typu a podtypu.
	 *
	 * @return array
	 */
	private static function types()
	{
		$dial = array();
		$dial[1][0] = array('SERVICE_OBJECTS', 'BREEDINGOBJCT'); //Zemědělské objekty
		$dial[2][1] = array('SERVICE_OBJECTS', 'STORAGEOBJCT');  //Komerční objekty Sklad
		$dial[2][2] = array('SERVICE_OBJECTS', 'PRODUCOBJCT');  //Komerční objekty Výroba
		$dial[2][3] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'SHOPPINSPACE');  //Komerční objekty Obchodní centrum
		$dial[2][4] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'SHOPPINSPACE');  //Komerční objekty Nákupní středisko
		$dial[2][5] = array('SERVICE_OBJECTS ', 'OTHERSEROBJCT');  //Komerční objekty Průmyslový areál
		$dial[2][6] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'OTHERBUSSER'); //Komerční objekty Jiný
		$dial[2][7] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'OFFICEHS');  //Komerční objekty Administrativní budova
		$dial[3][1] = array('BUILDING_SITES', 'COMMZONE'); //Pozemky Pro komerční výstavbu
		$dial[3][2] = array('BUILDING_SITES', 'RESIDENLOT'); //Pozemky Pro bydlení
		$dial[3][3] = array('FARM_LANDS', 'ARABLELAND'); //Pozemky Zemědělská
		$dial[3][4] = array('FARM_LANDS', 'FORESTLAND'); //Pozemky Les
		$dial[3][5] = array('FARM_LANDS', 'MEADOW'); //Pozemky Trvalý travní porost
		$dial[3][6] = array('FARM_LANDS', 'GARDEN'); //Pozemky Zahrada
		$dial[3][7] = array('BUILDING_SITES', 'OTHERBUSITE'); //Pozemky Ostatní
		$dial[4][1] = array('APARTMENTS', 'GARSONIER'); //Byty Garsoniéra
		$dial[4][2] = array('APARTMENTS', '1BEDAPART'); //Byty 1+kk
		$dial[4][3] = array('APARTMENTS', '2BEDAPART'); //Byty 2+kk
		$dial[4][4] = array('APARTMENTS', '3BEDAPART'); //Byty 3+kk
		$dial[4][5] = array('APARTMENTS', '4BEDAPART'); //Byty 4+kk
		$dial[4][6] = array('APARTMENTS', '5BEDAPART'); //Byty 5+kk
		$dial[4][7] = array('APARTMENTS', '6BEDAPART'); //Byty 6+kk
		$dial[4][8] = array('APARTMENTS', '7BEDAPART'); //Byty 7+kk
		$dial[4][9] = array('APARTMENTS', '1BEDAPART'); //Byty 1+1
		$dial[4][10] = array('APARTMENTS', '2BEDAPART'); //Byty 2+1
		$dial[4][11] = array('APARTMENTS', '3BEDAPART'); //Byty 3+1
		$dial[4][12] = array('APARTMENTS', '4BEDAPART'); //Byty 4+1
		$dial[4][13] = array('APARTMENTS', '5BEDAPART'); //Byty 5+1
		$dial[4][14] = array('APARTMENTS', '6BEDAPART'); //Byty 6+1
		$dial[4][15] = array('APARTMENTS', '7BEDAPART'); //Byty 7+1
		$dial[4][16] = array('APARTMENTS', 'OTHERAPART'); //Byty Atypický
		$dial[4][17] = array('APARTMENTS', 'OTHERAPART'); //Byty Jiný
		$dial[5][1] = array('OTHER_PREMISES', 'HISTORYOBJCT'); //Historické objekty Dřevěná
		$dial[5][2] = array('OTHER_PREMISES', 'HISTORYOBJCT'); //Historické objekty Cihlová
		$dial[5][3] = array('OTHER_PREMISES', 'HISTORYOBJCT'); //Historické objekty Kamenná
		$dial[5][4] = array('OTHER_PREMISES', 'HISTORYOBJCT'); //Historické objekty Montovaná
		$dial[5][5] = array('OTHER_PREMISES', 'HISTORYOBJCT'); //Historické objekty Panelová
		$dial[5][6] = array('OTHER_PREMISES', 'HISTORYOBJCT'); //Historické objekty Skeletová
		$dial[5][7] = array('OTHER_PREMISES', 'HISTORYOBJCT'); //Historické objekty Smíšená
		$dial[6][1] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'FAMILYHS'); //Domy a vily Řadový
		$dial[6][2] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'FAMILYHS'); //Domy a vily Rohový
		$dial[6][3] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'FAMILYHS'); //Domy a vily V bloku
		$dial[6][4] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'FAMILYHS'); //Domy a vily Samostatný
		$dial[7][1] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'HOTELPENSION'); //Hotely, penziony a restaurace Hotel
		$dial[7][2] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'HOTELPENSION'); //Hotely, penziony a restaurace Penzion
		$dial[7][3] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'RESTAURANT'); //Hotely, penziony a restaurace Restaurace
		$dial[8][0] = array('OBJECTS_FOR_BUSINESS_AND_SERVICES', 'RENTALHS'); //Nájemní domy
		$dial[9][1] = array('BUSINESS_PREMISES', 'OFFICES'); //Komerční prostory Kanceláře
		$dial[9][2] = array('BUSINESS_PREMISES', 'BUSINPREM'); //Komerční prostory Obchodní
		$dial[9][3] = array('BUSINESS_PREMISES', 'OTHERBUSPREM'); //Komerční prostory Skladovací
		$dial[9][4] = array('BUSINESS_PREMISES', 'OTHERBUSPREM'); //Komerční prostory Jiné
		$dial[9][5] = array('BUSINESS_PREMISES', 'OTHERBUSPREM'); //Komerční prostory Výrobní
		$dial[10][1] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'COTTAGEHS'); //Chaty a rekreační objekty Řadový
		$dial[10][2] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'COTTAGEHS'); //Chaty a rekreační objekty Rohový
		$dial[10][3] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'COTTAGEHS'); //Chaty a rekreační objekty V bloku
		$dial[10][4] = array('OBJECTS_FOR_LIVING_AND_RECREATION', 'COTTAGEHS'); //Chaty a rekreační objekty Samostatný
		$dial[11][1] = array('OTHER_PREMISES', 'BARNGARAGE'); //Malé objekty, garáže Řadový
		$dial[11][2] = array('OTHER_PREMISES', 'BARNGARAGE'); //Malé objekty, garáže Rohový
		$dial[11][3] = array('OTHER_PREMISES', 'BARNGARAGE'); //Malé objekty, garáže V bloku
		$dial[11][4] = array('OTHER_PREMISES', 'SINGLEGARAGE'); //Malé objekty, garáže Samostatný

		return $dial;
	}

	/**
	 * Matrix required, optional a restricted params.]
	 *
	 * @return array
	 */
	public static function matrix()
	{
		return array(
			'containsFloorPlan' =>							array(2,2,2,2,2,2,2,2,2),
			'providePrice' =>								array(1,1,1,1,1,1,1,1,1),
			'providePartOfCommission' =>					array(1,1,1,1,1,1,1,1,1),
			'propertyAvailableFrom' =>						array(2,2,2,2,2,2,2,2,2),
			'price' =>										array(1,1,1,1,1,1,1,1,1),
			'noteToPrice' =>								array(2,2,2,2,2,2,2,2,2),
			'nextPresentationUrl' =>						array(2,2,2,2,2,2,2,2,2),
			'informationForMls' =>							array(2,2,2,2,2,2,2,2,2),
			'exclusive' =>									array(1,1,1,1,1,1,1,1,1),
			'automaticCancelationDate' =>					array(2,2,2,2,2,2,2,2,2),
			'adReference' =>								array(2,2,2,2,2,2,2,2,2),
			'priceMeasure' =>								array(2,2,2,2,2,2,2,2,2),
			'propertySubType' =>							array(1,1,1,1,1,1,1,1,1),
			'propertyType' =>								array(1,1,1,1,1,1,1,1,1),
			'transactionType' =>							array(1,1,1,1,1,1,1,1,1),
			'propertyState' =>								array(2,2,2,2,2,2,2,2,2),
			'assignedAgentEmail' =>							array(2,2,2,2,2,2,2,2,2),
			'uniqueIdentifier' =>							array(2,2,2,2,2,2,2,2,2),
			'winterGarden' =>								array(0,2,2,0,0,0,2,0,0),
			'separateAccess' =>								array(0,0,0,0,0,0,0,2,0),
			'yearOfLastReconstruction' =>					array(2,2,2,2,2,2,2,0,0),
			'railwayStation' =>								array(0,0,2,0,2,2,2,2,0),
			'secondFloorLoadCapacity' =>					array(0,0,0,0,2,2,0,0,0),
			'serviceAndPowerCosts' =>						array(2,2,2,2,2,2,2,0,0),
			'groundOfCovarage' =>							array(0,0,2,0,2,0,2,0,0),
			'firstFloorLoadCapacity' =>						array(0,0,0,0,2,2,0,0,0),
			'coniferousForest' =>							array(0,0,0,0,0,0,0,0,2),
			'bulkOfBuiding' =>								array(0,2,2,0,2,0,2,0,0),
			'nonResidentialArea' =>							array(0,2,0,0,0,0,0,0,0),
			'terraceArea' =>								array(2,2,2,0,0,0,2,0,0),
			'loggiaArea' =>									array(2,0,0,0,0,0,0,0,0),
			'balconyArea' =>								array(2,0,0,0,0,0,0,0,0),
			'entireFloorArea' =>							array(1,2,1,1,1,1,1,2,2),
			'yearOfConstruction' =>							array(2,2,2,2,2,0,2,0,0),
			'workshopArea' =>								array(0,2,2,0,0,0,2,0,0),
			'workshop' =>									array(0,2,2,0,0,0,2,0,0),
			'winterGardenArea' =>							array(0,2,2,0,0,0,2,0,0),
			'tramStation' =>								array(0,0,2,0,2,2,2,2,0),
			'totalNumberOfObjects' =>						array(0,2,2,0,2,0,2,0,0),
			'thirdFloorLoadCapacity' =>						array(0,0,0,0,2,2,0,0,0),
			'thermalInsulationOfBuilding' =>				array(2,2,0,0,0,0,0,0,0),
			'terrace' =>									array(1,2,2,0,0,0,2,0,0),
			'technicalBackgroundArea' =>					array(0,0,0,2,2,2,2,0,0),
			'storageSpace' =>								array(0,0,0,0,2,2,0,0,0),
			'sauna' =>										array(0,2,2,0,0,0,2,0,0),
			'saleSpace' =>									array(0,0,0,2,0,0,0,0,0),
			'safetyEquipment' =>							array(0,2,2,2,2,2,2,0,0),
			'riverPort' =>									array(0,0,0,0,0,0,0,2,0),
			'rentalReturn' =>								array(0,0,2,0,2,2,2,2,0),
			'protectedZone' =>								array(0,0,0,0,2,0,0,2,2),
			'propellantOutlayPerYear' =>					array(0,0,0,0,2,0,0,0,0),
			'productionArea' =>								array(0,0,0,0,2,2,0,0,0),
			'priceOfLot' =>									array(0,2,0,0,0,0,0,0,0),
			'priceOfBuilding' =>							array(0,2,0,0,0,0,0,0,0),
			'preservationOfMonuments' =>					array(0,0,2,0,2,0,2,0,0),
			'premisesForBreedingOfAnimals' =>				array(0,0,0,0,2,2,0,0,0),
			'onusOfRent' =>									array(0,0,2,0,2,2,2,2,2),
			'numberOfVacationFlats' =>						array(0,0,0,0,2,0,2,0,0),
			'numberOfSublevels' =>							array(0,2,2,0,2,0,2,0,0),
			'numberOfRooms' =>								array(0,0,0,2,0,2,0,0,0),
			'numberOfParkingSpots' =>						array(2,0,2,2,2,2,2,0,0),
			'numberOfLandParts' =>							array(0,0,0,0,0,0,0,2,2),
			'numberOfGarageParkingSpots' =>					array(2,2,2,2,2,2,2,0,0),
			'numberOfEmployees' =>							array(0,0,0,0,2,2,0,0,0),
			'numberOfBedrooms' =>							array(0,2,0,0,0,0,2,0,0),
			'numberOfApartments' =>							array(0,2,0,0,2,0,2,0,0),
			'numberOfAboveGroundFloors' =>					array(0,2,2,0,2,0,2,0,0),
			'natureReservation' =>							array(0,0,0,0,0,0,0,2,2),
			'mixedForest' =>								array(0,0,0,0,0,0,0,0,2),
			'mainRoad' =>									array(0,0,2,0,2,2,2,2,0),
			'lot' =>										array(0,0,0,0,2,0,2,0,0),
			'loggia' =>										array(1,0,0,0,0,0,0,0,0),
			'loadingPlatform' =>							array(0,0,0,2,2,2,0,0,0),
			'liftingCapacityOfCraneBridge' =>				array(0,0,0,0,2,2,0,0,0),
			'landQuality' =>								array(0,0,0,0,0,0,0,2,2),
			'internet' =>									array(2,2,2,2,2,0,2,0,0),
			'installedOutput' =>							array(0,0,0,0,0,0,2,0,0),
			'highway' =>									array(0,0,2,0,2,2,2,2,0),
			'groundInvestigation' =>						array(0,0,0,0,0,0,0,2,0),
			'greeneryArea' =>								array(0,2,2,0,0,0,2,0,0),
			'greenery' =>									array(0,2,2,0,0,0,2,0,0),
			'gardenHouseArea' =>							array(0,2,2,0,0,0,2,0,0),
			'gardenHouse' =>								array(0,2,2,0,0,0,2,0,0),
			'garage' =>										array(0,2,2,0,0,0,2,0,0),
			'frontageWidth' =>								array(0,0,0,0,0,0,0,2,0),
			'floorFrom' =>									array(2,0,0,0,0,0,0,0,0),
			'floor' =>										array(2,0,0,0,0,0,0,0,0),
			'fitnessArea' =>								array(0,2,2,0,0,0,2,0,0),
			'fitness' =>									array(0,2,2,0,0,0,2,0,0),
			'fireplace' =>									array(0,2,2,0,0,0,2,0,0),
			'expertReport' =>								array(2,2,2,0,2,0,2,2,2),
			'entireUsageArea' =>							array(0,1,0,0,0,0,0,0,0),
			'entireEstateArea' =>							array(0,1,2,0,2,0,2,1,1),
			'elevatorLoadRating' =>							array(0,0,0,0,2,2,2,0,0),
			'elevator' =>									array(1,0,0,2,0,0,0,0,0),
			'dwellingPartArea' =>							array(0,1,0,0,0,0,0,0,0),
			'drivewayWidth' =>								array(0,0,0,0,2,2,0,2,0),
			'drivewayHeight' =>								array(0,0,0,0,2,2,0,2,0),
			'deciduousForest' =>							array(0,0,0,0,0,0,0,0,2),
			'consolidatedGround' =>							array(0,0,2,0,2,0,2,2,0),
			'consolidatedDumpingArea' =>					array(0,0,0,0,2,0,0,0,0),
			'cableTV' =>									array(2,2,2,2,2,0,2,0,0),
			'busStation' =>									array(0,0,2,0,2,2,2,2,0),
			'basinLength' =>								array(0,2,2,0,0,0,2,0,0),
			'basin' =>										array(0,2,2,0,0,0,2,0,0),
			'balcony' =>									array(1,0,0,0,0,0,0,0,0),
			'areaForSport' =>								array(0,0,0,0,0,0,2,0,0),
			'apron' =>										array(0,0,0,0,2,0,0,0,0),
			'approvedBuildingHeight' =>						array(0,0,0,0,0,0,0,2,0),
			'approvalWithExtractionOfAgriculturalLand' =>	array(0,0,0,0,0,0,0,2,0),
			'amountOfUnpaidCreadit' =>						array(0,0,2,0,2,0,2,2,2),
			'energyEfficiencyRatingHeating' =>				array(2,2,2,2,2,2,2,0,0),
			'energEfficiencRatingLighting' =>				array(2,2,2,2,2,2,2,0,0),
			'buildingEnergyRatingCertificate' =>			array(2,2,2,2,2,2,2,0,0),
			'energyEfficiencyRatingVentilation' =>			array(2,2,2,2,2,2,2,0,0),
			'energyEfficiencyRatingWaterHeating' =>			array(2,2,2,2,2,2,2,0,0),
			'apartmentCategory' =>							array(2,0,0,0,0,0,0,0,0),
			'buildingStructure' =>							array(1,0,0,0,0,0,0,0,0),
			'carriageDriveway' =>							array(0,2,2,2,2,2,2,2,0),
			'circuitBreaker' =>								array(0,2,2,0,2,0,2,0,0),
			'currentUsage' =>								array(0,2,0,0,0,0,0,0,0),
			'demarcationInTerrain' =>						array(0,0,0,0,0,0,0,2,2),
			'drinkingWater' =>								array(0,2,0,0,0,0,0,0,0),
			'electricCurrent' =>							array(0,2,2,2,2,2,2,0,0),
			'electricalRate' =>								array(0,2,2,2,2,2,2,0,0),
			'enlargementPossibilities' =>					array(0,0,2,2,2,2,2,0,0),
			'fireWater' =>									array(0,0,2,2,2,2,2,0,0),
			'formOfOwnership' =>							array(2,2,2,2,2,2,2,2,2),
			'groundType' =>									array(0,2,0,0,0,0,0,2,0),
			'heatingMethod' =>								array(2,2,2,2,2,2,2,0,0),
			'heatingSource' =>								array(2,2,2,2,2,2,2,0,0),
			'inputPower' =>									array(0,0,0,0,2,2,0,2,0),
			'levelOfQuality' =>								array(0,1,0,0,0,0,0,0,0),
			'objectStatus' =>								array(2,2,2,2,2,2,2,0,0),
			'overheadFloor' =>								array(1,0,0,0,0,0,0,0,0),
			'predominantBuildingStructure' =>				array(0,2,2,2,2,2,2,0,0),
			'presentOperation' =>							array(0,0,2,2,2,2,2,0,0),
			'siteDevelopment' =>							array(0,0,0,0,0,0,0,1,0),
			'usagePossibilities' =>							array(0,2,0,0,0,0,0,0,0),
			'warmWaterPreparation' =>						array(2,2,2,2,2,2,2,0,0),
			'wasteWater' =>									array(0,2,2,2,2,2,2,0,0),
			'waterServicePipe' =>							array(0,0,0,0,0,0,0,1,0),
			'electricConnection' =>							array(0,0,0,0,0,0,0,1,0),
			'sewerConnection' =>							array(0,0,0,0,0,0,0,1,0),
			'gasConnection' =>								array(0,0,0,0,0,0,0,1,0),
			'yearOfBuildingApproval' =>						array(2,2,0,0,0,0,0,0,0),
			'propertyAddress' =>							array(1,1,1,1,1,1,1,1,1),
		);
	}

	/**
	 * Zda obsahuje pudorys.
	 *
	 * @return string
	 */
	public static function containsFloorPlan()
	{
		return self::FALSE;
	}

	/**
	 * Zda publikovat cenu.
	 *
	 * @return string
	 */
	public static function providePrice()
	{
		return self::TRUE;
	}

	/**
	 * Distribuce inzeratu k jakymusi MLS? nevedeme, nemame, takze false, pac je to required
	 *
	 * @return string
	 */
	public static function providePartOfCommission()
	{
		return self::FALSE;
	}

	// nemame
	public static function nextPresentationUrl() {return null;}
	public static function informationForMls() {return null;}
	public static function automaticCancelationDate() {return null;}
	public static function winterGarden() {return null;}
	public static function separateAccess() {return null;}
	public static function railwayStation() {return null;}
	public static function secondFloorLoadCapacity() {return null;}
	public static function serviceAndPowerCosts() {return null;}
	public static function firstFloorLoadCapacity() {return null;}
	public static function coniferousForest() {return null;}
	public static function nonResidentialArea() {return null;}
	public static function workshopArea() {return null;}
	public static function workshop() {return null;}
	public static function winterGardenArea() {return null;}
	public static function tramStation() {return null;}
	public static function totalNumberOfObjects() {return null;}
	public static function thirdFloorLoadCapacity() {return null;}
	public static function thermalInsulationOfBuilding() {return null;}
	public static function sauna() {return null;}
	public static function saleSpace() {return null;}
	public static function safetyEquipment() {return null;}
	public static function riverPort() {return null;}
	public static function rentalReturn() {return null;}
	public static function protectedZone() {return null;}
	public static function propellantOutlayPerYear() {return null;}
	public static function priceOfLot() {return null;}
	public static function priceOfBuilding() {return null;}
	public static function preservationOfMonuments() {return null;}
	public static function premisesForBreedingOfAnimals() {return null;}
	public static function onusOfRent() {return null;}
	public static function numberOfSublevels() {return null;}
	public static function numberOfLandParts() {return null;}
	public static function numberOfGarageParkingSpots() {return null;}
	public static function numberOfEmployees() {return null;}
	public static function numberOfBedrooms() {return null;}
	public static function numberOfAboveGroundFloors() {return null;}
	public static function natureReservation() {return null;}
	public static function mixedForest() {return null;}
	public static function mainRoad() {return null;}
	public static function lot() {return null;}
	public static function loadingPlatform() {return null;}
	public static function liftingCapacityOfCraneBridge() {return null;}
	public static function landQuality() {return null;}
	public static function installedOutput() {return null;}
	public static function highway() {return null;}
	public static function groundInvestigation() {return null;}
	public static function greeneryArea() {return null;}
	public static function greenery() {return null;}
	public static function gardenHouseArea() {return null;}
	public static function gardenHouse() {return null;}
	public static function frontageWidth() {return null;}
	public static function fitnessArea() {return null;}
	public static function fitness() {return null;}
	public static function fireplace() {return null;}
	public static function expertReport() {return null;}
	public static function elevatorLoadRating() {return null;}
	public static function drivewayWidth() {return null;}
	public static function drivewayHeight() {return null;}
	public static function deciduousForest() {return null;}
	public static function consolidatedGround() {return null;}
	public static function consolidatedDumpingArea() {return null;}
	public static function busStation() {return null;}
	public static function basinLength() {return null;}
	public static function areaForSport() {return null;}
	public static function apron() {return null;}
	public static function approvedBuildingHeight() {return null;}
	public static function approvalWithExtractionOfAgriculturalLand() {return null;}
	public static function amountOfUnpaidCreadit() {return null;}
	public static function energyEfficiencyRatingHeating() {return null;}
	public static function energEfficiencRatingLighting() {return null;}
	public static function buildingEnergyRatingCertificate() {return null;}
	public static function energyEfficiencyRatingVentilation() {return null;}
	public static function energyEfficiencyRatingWaterHeating() {return null;}
	public static function apartmentCategory() {return null;}
	public static function carriageDriveway() {return null;}
	public static function circuitBreaker() {return null;}
	public static function currentUsage() {return null;}
	public static function demarcationInTerrain() {return null;}
	public static function drinkingWater() {return null;}
	public static function electricalRate() {return null;}
	public static function enlargementPossibilities() {return null;}
	public static function fireWater() {return null;}
	public static function groundType() {return null;}
	public static function heatingMethod() {return null;}
	public static function heatingSource() {return null;}
	public static function inputPower() {return null;}
	public static function presentOperation() {return null;}
	public static function siteDevelopment() {return null;}
	public static function usagePossibilities() {return null;}
	public static function warmWaterPreparation() {return null;}
	public static function wasteWater() {return null;}

	/**
	 * Datum mozneho nastehovani.
	 *
	 * @return string
	 */
	public static function propertyAvailableFrom()
	{
		if (self::$n['nemovitost_datum_nastehovani'] && false === strpos('0000', self::$n['nemovitost_datum_nastehovani'])) {
			return self::formatDate(self::$n['nemovitost_datum_nastehovani']);
		}
	}

	/**
	 * Cena.
	 *
	 * @return float
	 */
	public static function price()
	{
		return (float) self::$n['cena'];
	}

	/**
	 * Poznamka k cene.
	 *
	 * @return string
	 */
	public static function noteToPrice()
	{
		if (self::$n['nemovitost_cena_poznamka']) {
			return self::$n['nemovitost_cena_poznamka'];
		}
	}

	/**
	 * Exclusivita smlouvy
	 *
	 * @return string
	 */
	public static function exclusive()
	{
		return self::$n['zakazka_typ_smlouvy'] == 10 ? self::TRUE : self::FALSE;
	}

	/**
	 * Kod zakazky
	 *
	 * @return string
	 */
	public static function adReference()
	{
		return self::$n['kod'];
	}

	/**
	 * Merna jednotka ceny.
	 *
	 * @return string
	 */
	public static function priceMeasure()
	{
		//EUR_M2
		//EUR_M2_MONTH
		//EUR_M2_WEEK
		//EUR_M2_YEAR
		//EUR_WEEK
		//EUR_MONTH
		//EUR_YEAR
		//EUR

		// jednotka ceny
		if(!self::$n['cena_jednotka']) {
			if(self::$n['zakazka_typ'] == 1) {
				// prodej
				self::$n['cena_jednotka'] = self::$n['nemovitost_cena_prodej_jednotka'] ? self::$n['nemovitost_cena_prodej_jednotka'] : 1;
			} else {
				// pronajem
				self::$n['cena_jednotka'] = self::$n['nemovitost_cena_pronajem_jednotka'] ? self::$n['nemovitost_cena_pronajem_jednotka'] : 2;
			}
		}

		// prepocitat a pridat poznamku do poznamky o cene??
		$type = (int) self::$n['zakazka_typ'];
		$unit = (int) self::$n['cena_jednotka'];

		$dial = array();

		// prodej
		$dial[1][1] = 'EUR'; // za nemovitost
		$dial[1][3] = 'EUR_M2'; // za m2

		// pronajem
		$dial[2][2] = 'EUR_MONTH'; // za mesic
		$dial[2][4] = 'EUR_M2_MONTH'; // m2/měsíc
		$dial[2][5] = 'EUR_M2_YEAR'; // m2/rok
		$dial[2][6] = 'EUR_YEAR'; // rok
		// $dial[2][7] = ''; // den snad to nebude nikdo chtit, jinak se musi prepocitat cena, ble

		return $dial[$type][$unit];
	}

	/**
	 * Typ nemovitosti.
	 *
	 * @return string
	 */
	public static function propertyType()
	{
		$types = self::types();
		$all = $types[(int) self::$n['nemovitost_typ']][(int) self::$n['nemovitost_podtyp']];
		return $all[0];
	}

	/**
	 * Podtyp nemovitosti.
	 *
	 * @return string
	 */
	public static function propertySubType()
	{
		$types = self::types();
		$all = $types[(int) self::$n['nemovitost_typ']][(int) self::$n['nemovitost_podtyp']];
		return $all[1];
	}

	/**
	 * Typ transakce (prodej|pronajem)
	 *
	 * @return string
	 */
	public static function transactionType()
	{
		$type = self::$n['zakazka_typ'];

		if ($type == 1) {
			return 'SALE';
		}
		if ($type == 2) {
			return 'HIREOUT';
		}
		return null;
	}

	/**
	 * Stav zakazky
	 *
	 * @return string
	 */
	public static function propertyState()
	{
		$val = (int) self::$n['zakazka_stav'];
		switch ($val) {
			case 20 :
				return 'VALREC';
			case 30 :
				return 'RESERV';
			default :
				return null;
		}
	}

	/**
	 * Email maklere.
	 *
	 * @return string
	 */
	public static function assignedAgentEmail()
	{
		$q = 'SELECT jmeno_cele AS jmeno, email, telefon FROM uzivatel WHERE id = ' . (int) self::$n['id_uzivatel'];
		$makler = self::$db->fetchOne($q);

		if ($makler) {
//			$makler['jmeno'];
//			$makler['telefon'];
			return $makler['email'];
		}
		return null;
	}

	/**
	 * uId pridelovane realitysk.
	 *
	 * @return string
	 */
	public static function uniqueIdentifier()
	{
		return null;
	}


	public static function levelOfQuality()
	{
		/* @NOTE do tohodle se vejdeme dost blbe:
			ABVSTNDMAT = nadštandardné materiály/atyp
			CLASSICMAT = RD z klasických materiálov
			PREFHOUSE = montovaný dom
			COUNTHOUS = Vidiecky dom
		 */
		if (self::$n['nemovitost_druh_objektu'] && self::$n['nemovitost_druh_objektu'] == 4) {
			return 'PREFHOUSE';
		}

		return 'CLASSICMAT';
	}

	/**
	 * Rok posledni rekonstrukce.
	 *
	 * @return integer
	 */
	public static function yearOfLastReconstruction()
	{
		if (self::$n['nemovitost_rok_rekonstrukce']) {
			return (int) self::$n['nemovitost_rok_rekonstrukce'];
		}
		return null;
	}

	/**
	 * Zastavena plocha
	 *
	 * @return float
	 */
	public static function groundOfCovarage()
	{
		if (self::$n['nemovitost_plocha_zastavena']) {
			return (float) self::$n['nemovitost_plocha_zastavena'];
		}
		return null;
	}

	/**
	 * Zastavena plocha.
	 *
	 * @return float
	 */
	public static function bulkOfBuiding()
	{
		if (self::$n['nemovitost_plocha_obestavena']) {
			return (float) self::$n['nemovitost_plocha_obestavena'];
		}
		return null;
	}

	/**
	 * Mame terasu?
	 *
	 * @return string
	 */
	public static function terrace()
	{
		if (self::$n['nemovitost_terasa']) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Plocha terasy.
	 *
	 * @return float
	 */
	public static function terraceArea()
	{
		if (self::$n['nemovitost_terasa_plocha']) {
			return (float) self::$n['nemovitost_terasa_plocha'];
		}
		return null;
	}

	/**
	 * Plocah lodzie.
	 *
	 * @return float
	 */
	public static function loggiaArea()
	{
		if (self::$n['nemovitost_lodzie_plocha']) {
			return (float) self::$n['nemovitost_lodzie_plocha'];
		}
		return null;
	}

	/**
	 * Plocha balkonu.
	 *
	 * @return float
	 */
	public static function balconyArea()
	{
		if (self::$n['nemovitost_balkon_plocha']) {
			return (float) self::$n['nemovitost_balkon_plocha'];
		}
		return null;
	}

	/**
	 * Celkova podlahova plocha.
	 *
	 * @return float
	 */
	public static function entireFloorArea()
	{
		$type = (int) self::$n['nemovitost_typ'];
		switch ($type) {
			case 2 :
			case 4 :
				return (float) self::$n['nemovitost_plocha_celkova'];
				break;
			case 1 :
			case 5 :
			case 6 :
			case 7 :
			case 8 :
			case 10 :
				return (float) self::$n['nemovitost_plocha_uzitna'];
				break;
			case 9 :
				return (float) self::$n['nemovitost_plocha_kancelari'];
				break;
			case 11 :
				return (float) self::$n['nemovitost_plocha_zastavena'];
				break;
		}
		return null;
	}

	/**
	 * Rok vystavby.
	 *
	 * @return int
	 */
	public static function yearOfConstruction()
	{
		if (self::$n['nemovitost_rok_vystavby']) {
			return (int) self::$n['nemovitost_rok_vystavby'];
		}
		return null;
	}

	public static function technicalBackgroundArea(){return null;}

	/**
	 * Plocha skaldu.
	 *
	 * @return float
	 */
	public static function storageSpace()
	{
		if (self::$n['nemovitost_plocha_skladu']) {
			return (float) self::$n['nemovitost_plocha_skladu'];
		}
		return null;
	}

	/**
	 * Plocha pro vyrobu.
	 *
	 * @return float
	 */
	public static function productionArea()
	{
		if (self::$n['nemovitost_plocha_vyrobni']) {
			return (float) self::$n['nemovitost_plocha_vyrobni'];
		}
		return null;
	}

	/**
	 * Pocet volnych bytu.
	 *
	 * @return int
	 */
	public static function numberOfVacationFlats()
	{
		if (self::$n['nemovitost_pocet_bytu_volnych']) {
			return (int) self::$n['nemovitost_pocet_bytu_volnych'];
		}
		return null;
	}

	/**
	 * Pocet kancelari.
	 *
	 * @return int
	 */
	public static function numberOfRooms()
	{
		if (self::$n['nemovitost_pocet_kancelari']) {
			return (int) self::$n['nemovitost_pocet_kancelari'];
		}
		return null;
	}

	/**
	 * Pocet parkovacich mist.
	 *
	 * @return int
	 */
	public static function numberOfParkingSpots()
	{
		if (self::$n['pocet_mist_k_parkovani']) {
			return (int) self::$n['pocet_mist_k_parkovani'];
		}
		return null;
	}

	/**
	 * Pocet bytu v nemovitosti.
	 *
	 * @return int
	 */
	public static function numberOfApartments()
	{
		if (self::$n['nemovitost_bytu_celkem']) {
			return (int) self::$n['nemovitost_bytu_celkem'];
		}
		return null;
	}

	/**
	 * Lodzie?
	 *
	 * @return string
	 */
	public static function loggia()
	{
		if (self::$n['nemovitost_lodzie']) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Zavedeny internet?
	 *
	 * @return string
	 */
	public static function internet()
	{
		if (self::$n['nemovitost_telekomunikace'] && self::$n['nemovitost_telekomunikace']{1} == 1) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Mame garaz?
	 *
	 * @return string
	 */
	public static function garage()
	{
		if (self::$n['nemovitost_garaz'] || (self::$n['nemovitost_ostatni'] && self::$n['nemovitost_ostatni']{3} == 1)) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Umisteni patra v dome
	 *
	 * @return string
	 */
	public static function overheadFloor()
	{
		if (self::floorFrom() === self::floor()) {
			return 'ATTICFL';
		}
		// @todo je prizemi 0?
		if (0 === self::floor()) {
			return 'GRNDFL';
		}
		// jinak vracime jine podlazi
		return 'OTHRFL';
	}

	/**
	 * Pocet nadzemnich podlazi.
	 *
	 * @return int
	 */
	public static function floorFrom()
	{
		if (self::$n['nemovitost_pocet_podlazi']) {
			return (int) self::$n['nemovitost_pocet_podlazi'];
		}
		return null;
	}

	/**
	 * Podlazi.
	 *
	 * @return int
	 */
	public static function floor()
	{
		if (self::$n['podlazi']) {
			return (int) self::$n['podlazi'];
		}
		return null;
	}

	/**
	 * Celkova užitna plocha.
	 *
	 * @return float
	 */
	public static function entireUsageArea()
	{
		if (self::$n['nemovitost_plocha_uzitna']) {
			return (float) self::$n['nemovitost_plocha_uzitna'];
		}
		return null;
	}

	/**
	 * Celkova plocha parely.
	 *
	 * @return float
	 */
	public static function entireEstateArea()
	{
		// pozor pro pozemky to je jinac
		if (self::$n['nemovitost_plocha_parcely']) {
			return (float) self::$n['nemovitost_plocha_parcely'];
		}
		// @TODO zkontrolovat
		if (self::propertyType() == 'BUILDING_SITES') {
			return (float) self::$n['nemovitost_plocha_celkova'];
		}
		return null;
	}

	/**
	 * Vytah?
	 *
	 * @return string
	 */
	public static function elevator()
	{
		if (self::$n['nemovitost_ostatni'] && self::$n['nemovitost_ostatni']{4} == 1) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Uzitna plocha.
	 *
	 * @return float
	 */
	public static function dwellingPartArea()
	{
		// obytnou plochu nemame - pouzijeme uzitnou plochou
		if (self::$n['nemovitost_plocha_uzitna']) {
			return (float) self::$n['nemovitost_plocha_uzitna'];
		}
		return null;
	}

	/**
	 * Kabelovka?
	 *
	 * @return string
	 */
	public static function cableTV()
	{
		if (self::$n['nemovitost_ostatni_rozvody'] && (self::$n['nemovitost_ostatni_rozvody']{0} == 1 )) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Bazen?
	 *
	 * @return string
	 */
	public static function basin()
	{
		if (self::$n['nemovitost_bazen']) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Balkon?
	 *
	 * @return string
	 */
	public static function balcony()
	{
		if (self::$n['nemovitost_balkon']) {
			return self::TRUE;
		}
		return self::FALSE;
	}

	/**
	 * Druh struktury objektu.
	 *
	 * @return string
	 */
	public static function buildingStructure()
	{
		if (self::$n['nemovitost_druh_objektu']) {

			$type = (int) self::$n['nemovitost_druh_objektu'];
			switch ($type) {
				case 2 :
					return 'BRICK';
				case 5 :
					return 'PANEL';
				default :
					return 'MIXED';
			}
		}
		return null;
	}

	// jde jeste dohledat
	public static function electricCurrent()
	{
		return null;
	}

	/**
	 * Forma vlastnicktvi.
	 *
	 * @return string
	 */
	public static function formOfOwnership()
	{
		if (self::$n['nemovitost_vlastnictvi']) {
			$type = (int) self::$n['nemovitost_vlastnictvi'];
			switch ($type) {
				case 1 :
					return 'PERSONAL';
				case 2 :
					return 'COOPERAT';
				default :
					return 'OTHEROWN';
			}
		}
		return null;
	}

	public static function objectStatus()
	{
		return null;
	}

	/**
	 * Druh objektu.
	 *
	 * @return string
	 */
	public static function predominantBuildingStructure()
	{
		if (self::$n['nemovitost_druh_objektu']) {

			$type = (int) self::$n['nemovitost_druh_objektu'];
			switch ($type) {
				case 2 :
					return 'BRICK';
				case 5 :
					return 'PANEL';
				default :
					return 'MIXED';
			}
		}
		return null;
	}

	/**
	 * Rok kolaudace.
	 *
	 * @return string
	 */
	public static function yearOfBuildingApproval()
	{
		if (self::$n['nemovitost_rok_kolaudace']) {

			$year = (int) self::$n['nemovitost_rok_kolaudace'];
			$range = array(
				2016 => 2018,
				2013 => 2015,
				2010 => 2012,
				2007 => 2009,
				2003 => 2006,
				1995 => 2002,
				1970 => 1994,
				1946 => 1969,
				1900 => 1945,
			);

			foreach ($range as $from => $to) {
				if ($year >= $from && $to >= $year) {
					return $from . '_' . $to;
				}
			}

		}

		return null;
	}

	/**
	 * Pripojeni vody - potrebne pro pozemky.
	 *
	 * @return string
	 */
	public static function waterServicePipe()
	{
		/*
			ONLAND = na pozemku
			WTHNLAND = v dosahu
			NONE = nie je
		*/

		// vodovod - tj voda na pozemku
		if (self::$n['nemovitost_inzenyrske_site'] && self::$n['nemovitost_inzenyrske_site']{0} == 1) {
			return 'ONLAND';
		}

		if(self::$n['nemovitost_voda']) {
			// zdroj pro cely objekt a rozvod studene a teple znaci ze tam je primo
			if (self::$n['nemovitost_voda']{0} == 1 || self::$n['nemovitost_voda']{2} == 1) {
				return 'ONLAND';
			}
			// dalkovy rozvod
			if (self::$n['nemovitost_voda']{1} == 1) {
				return 'WTHNLAND';
			}
		}

		return 'NONE';
	}

	/**
	 * Pripojeni elektricky.
	 *
	 * @return string
	 */
	public static function electricConnection()
	{
		$e = (int) self::$n['nemovitost_elektrina'];
		if ((self::$n['nemovitost_inzenyrske_site'] && self::$n['nemovitost_inzenyrske_site']{3} == 1) || $e !== 0) {
			return 'ONLAND';
		}
		return 'NONE';
	}

	/**
	 * Kanzalizace.
	 *
	 * @return string
	 */
	public static function sewerConnection()
	{
		$s = (int) self::$n['nemovitost_odpad'];
		if ((self::$n['nemovitost_inzenyrske_site'] && self::$n['nemovitost_inzenyrske_site']{1} == 1) || $s !== 0) {
			return 'ONLAND';
		}
		return 'NONE';
	}

	/**
	 * Plynova pripojka.
	 *
	 * @return string
	 */
	public static function gasConnection()
	{
		$g = (int) self::$n['nemovitost_plyn'];
		if ((self::$n['nemovitost_inzenyrske_site'] && self::$n['nemovitost_inzenyrske_site']{2} == 1) || $g !== 0) {
			return 'ONLAND';
		}
		return 'NONE';
	}

	/**
	 * Vraci komplet adresu
	 *
	 * @return array
	 */
	public static function propertyAddress()
	{
		// ukazatel, zda je adresa "spinava"
		$a = array();

		$a['state'] = trim(self::$n['nemovitost_uir_stat']);

		$a['city'] = (int) self::$n['nemovitost_uir_obec_kod'];
		$a['cityName'] = self::$n['nemovitost_uir_obec_text'];

		// u ulice neni kod nepovinny
		$streetCode = (int) self::$n['nemovitost_uir_ulice_kod'];
		if (0 !== $streetCode) {
			$a['street'] = $streetCode;
		}

		$a['streetName'] = self::$n['nemovitost_uir_ulice_text'];
		$a['streetNumber'] = self::$n['nemovitost_uir_cp']; // cislo popisne

		// kdyz neni ulice, mame problem, ale jeste je sance to vyresit podle nazvu a mesta


		return $a;
	}

	/**
	 * Vrati lokalizovane nazvy a popisy inzeratu.
	 *
	 * @return array
	 */
	public static function descriptions()
	{
		// prapodivny zapis - to kdyby nahodou jsme meli jeste nejake dalsi jazyky
		$d = array(
			'language' => strtolower(trim(self::$n['nemovitost_uir_stat'])),
			'title' => self::$n['nemovitost_titulek'],
			'description' => (self::$n['nemovitost_popis_zakladni'] ? self::$n['nemovitost_popis_zakladni'] . ' ' : '') . self::$n['nemovitost_popis_detailni'],
		);

		$ds = array();
		$ds[] = $d;

		return $ds;
	}

	/**
	 * Pripravi polozku obrazku z nasich dat
	 *
	 * @param array $img
	 * @param int $position
	 * @return array
	 */
	public static function image(array $img, $position)
	{
		$i = array();
		$i['first'] = $position === 0 ? Params::TRUE : Params::FALSE;
		$i['position'] = $position; // oni cisluji od nuly

		$h = fopen($img['foto'], "r");
		$binary = fread($h, filesize($img['foto']));
		$i['bytes'] = base64_encode($binary);
		fclose($h);

		$i['description'] = $img['popis'];

		$i['name'] = self::imageName($img['foto']);

		// pri zmene, je potreba znat vyexportovane obrazky, abychom vedeli, jakou akci chceme provest
		// new – vytvoriť nový, delete – vymazať existujúci, change – zmeniť existujúci

		return $i;
	}

	/**
	 * Vysosne filename z cesty.
	 *
	 * @param string $path
	 * @return string
	 */
	public static function imageName($path)
	{
		preg_match('~.*/([_a-z0-9\.]*)$~', $path, $matches);
		return $matches[1];
	}

	/**
	 * Pomocna metoda prevadejici datum ana spravny format pro export
	 *
	 * @param string $date
	 * @return string datum v ISO8601 formatu
	 */
	public static function formatDate($date)
	{
		$date = new DateTime($date);
		return $date->format(DateTime::W3C);
	}

	/**
	 * Vrati datovy typ podle nazvu paramtru
	 *
	 * @return string
	 */
	public static function getType($paramName)
	{
		if (isset(self::$dataTypes[$paramName])) {
			return self::$dataTypes[$paramName];
		}
		return 'string';
	}

}
