<?php

class Dalten_Config_Processer_DefaultFunctionsTest extends \PHPUnit\Framework\TestCase
{
	/** @var Dalten_Config_Processer_DefaultFunctions */
	private $_functions;

	public function setUp(): void
	{
		$this->_functions = new Dalten_Config_Processer_DefaultFunctions();
	}

	public function testSumDoesTheRightCalculations()
	{
		$this->assertEquals(10, $this->_functions->sum(1, 2, 3, 4));
		$this->assertEquals(10, $this->_functions->sum(4, 3, 2, 1));
	}

	public function testMaxPickTheRightValue()
	{
		$this->assertEquals(5, $this->_functions->max(2, 4, 1, 5));
		$this->assertEquals(5, $this->_functions->max(array(2, 4, 1, 5)));
	}

	public function testReplaceReallyReplaces()
	{
		$this->assertEquals('', $this->_functions->replace('test', '', 'test'));
	}

	public function testReplaceCanUseRegularExpression()
	{
		$this->assertEquals('t_es_t', $this->_functions->replace('([es]+)', '_$1_', 'test'));
	}

	public function testSubstrReallySlicingString()
	{
		$this->assertEquals('456', $this->_functions->substr('123456', 3));
		$this->assertEquals('5', $this->_functions->substr('123456', 4, 1));
	}

	public function testDateFormatsDatesCorrectly()
	{
		$this->assertEquals('01.01.1970', $this->_functions->date('d.m.Y', '1970-01-01'));
		$this->assertEquals('05.12.1999', $this->_functions->date('d.m.Y', '1999-12-05'));
	}

	public function testReturnsEmptyStringOnIncorrectDates()
	{
		$this->assertNull($this->_functions->date('d.m.Y', 'test'));
		$this->assertNull($this->_functions->date('d.m.Y', 'ihned'));
		$this->assertNull($this->_functions->date('d.m.Y', 'teď'));
	}

	public function testInListCanFindItemInList()
	{
		$this->assertTrue((bool) $this->_functions->inList(1, array(1, 3, 5, 7)));
		$this->assertTrue((bool) $this->_functions->inList(1, 2, 1, array(2, 3, 5, 7)));
		$this->assertTrue((bool) $this->_functions->inList(1, 2, array(2, 3, 5, 7, 1)));
		$this->assertFalse((bool) $this->_functions->inList(1, 2, array(2, 3, 5, 7)));
	}

	public function testDegToFloatConvertsValuesCorrectlyAndAlwaysReturnsString()
	{
		$this->assertSame('-11.998750', $this->_functions->degToFloat('11°59\'55.5"S'));
	}

	public function testUrlEncodeEncodesUrlValues()
	{
		$text = "bagr jede & jede";
		$this->assertSame(urlencode($text), $this->_functions->urlEncode($text));
	}

	public function testStrPadIsWorkingAsExpected()
	{
		$this->assertEquals('aaa000',$this->_functions->strPad('aaa',6,'0'));
		$this->assertEquals(str_pad(1,3,0),$this->_functions->strPad(1,3,0));
	}
}
