<?php
class Dalten_Export_Ingatlannethu extends Dalten_Export_AbstractExport{
	private $_adresar=array();

	function __construct(Serenity_Config_Config $codebooks,
						 Serenity_Config_Config $entities,
						 Dalten_Config_Processer_ProcesserInterface $processer = null,
						 array $adresar)
	{
		//posílám parametry rodičovi a nestarám se co bylo v nich
		parent::__construct($codebooks, $entities, $processer);
		//beru si jen adresář
		$this->_adresar = $adresar;
	}

	public function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if ($entityName=="property"){
			$cityCode = $convertedValues['city_code'];
			if ($cityCode==1){
				$convertedValues['city_code']=sprintf('32%02d',$originalvalues['nemovitost_uir_mcast_kod']);
			}else{
				$convertedValues['city_code'] = (
				isset($this->_adresar['region'][$cityCode]) ?
					$this->_adresar['region'][$cityCode] :
					0
				);
				if ($convertedValues['city_code']==0){
					throw new Dalten_Export_Exception_HumanReadable('Address not found!');
				}
			}
		}
		return $convertedValues;
	}
}