<?php
class Dalten_AddressConverter_Sreality_Ruian implements Dalten_AddressConverter_Sreality_Interface
{
	// hodnoty nabidka_uroven_znepresneni_adresy
	const LISTING_LOCALITY_SHOW_ALL = 1;
	const LISTING_LOCALITY_SHOW_STREET = 2;
	const LISTING_LOCALITY_SHOW_MUNICIPALITY_PART = 3;
	const LISTING_LOCALITY_SHOW_MUNICIPALITY = 4;

	// hodnoty locality_inaccuracy_level / nabidka_gps_presnost
	const INACCURACY_ACCURATE = 1;
	const INACCURACY_ONE_LEVEL = 2;
	const INACCURACY_TWO_LEVELS = 2;

	function convertAddress(array $input)
	{
		// pokud máme nabidka_uroven_znepresneni_adresy, řídíme se tím
		if (isset($input['nabidka_uroven_znepresneni_adresy'])) {

			$mameAdresu = !empty($input['ruian_adresa_kod']);
			$mameUlici = !empty($input['nemovitost_uir_ulice_kod']);
			$mameCobce = !empty($input['nemovitost_uir_cobce_kod']);

			$chcemeUlici = $input['nabidka_uroven_znepresneni_adresy']==self::LISTING_LOCALITY_SHOW_STREET;
			$chcemeCobce = $input['nabidka_uroven_znepresneni_adresy']==self::LISTING_LOCALITY_SHOW_MUNICIPALITY_PART;
			$chcemeObec = $input['nabidka_uroven_znepresneni_adresy']==self::LISTING_LOCALITY_SHOW_MUNICIPALITY;

			// adresu zobrazíme přesně
			$input['locality_inaccuracy_level'] = self::INACCURACY_ACCURATE;
			// nebo znepřesníme v následujících případech:

			if ($mameAdresu) {
				if ($chcemeUlici) {
					$input['locality_inaccuracy_level'] = self::INACCURACY_ONE_LEVEL;
				}
				if ($chcemeCobce) {
					$input['locality_inaccuracy_level'] = self::INACCURACY_TWO_LEVELS;
				}
				if ($chcemeObec) {
					unset($input['ruian_adresa_kod']);
					$input['locality_inaccuracy_level'] = self::INACCURACY_ONE_LEVEL;
				}
			}

			if ($mameUlici) {
				if ($chcemeCobce) {
					$input['locality_inaccuracy_level'] = self::INACCURACY_ONE_LEVEL;
				}
				if ($chcemeObec) {
					$input['locality_inaccuracy_level'] = self::INACCURACY_TWO_LEVELS;
				}
			}

			if ($mameCobce && $chcemeObec) {
				$input['locality_inaccuracy_level'] = self::INACCURACY_ONE_LEVEL;
			}

		// pokud nemáme nabidka_uroven_znepresneni_adresy, řídíme se nabidka_gps_presnost
		} else {
			$input['locality_inaccuracy_level'] = (int) $input['nabidka_gps_presnost'];
		}

		// nastavíme správný RUIAN kód a level
		if (!empty($input['ruian_adresa_kod'])) {
			$input['locality_ruian_level'] = 11;
			$input['locality_ruian'] = (int) $input['ruian_adresa_kod'];
		} elseif (!empty($input['nemovitost_uir_ulice_kod'])) {
			$input['locality_ruian_level'] = 7;
			$input['locality_ruian'] = (int) $input['nemovitost_uir_ulice_kod'];
		} elseif (!empty($input['nemovitost_uir_mcast_kod'])) {
			$input['locality_ruian_level'] = 17;
			$input['locality_ruian'] = (int) $input['nemovitost_uir_mcast_kod'];
		} elseif (!empty($input['nemovitost_uir_cobce_kod'])) {
			$input['locality_ruian_level'] = 5;
			$input['locality_ruian'] = (int) $input['nemovitost_uir_cobce_kod'];
		} elseif (!empty($input['nemovitost_uir_obec_kod'])) {
			$input['locality_ruian_level'] = 3;
			$input['locality_ruian'] = (int) $input['nemovitost_uir_obec_kod'];
		} elseif (!empty($input['nemovitost_uir_okres_kod'])) {
			$input['locality_ruian_level'] = 1;
			$input['locality_ruian'] = (int) $input['nemovitost_uir_okres_kod'];
		}

		return $input;
	}
}