<?php

/**
 * Vytovoří z pole xml soubor podle pravidel idnes.
 */
class Dalten_Export_Api_Backend_Idnes2_Xml
{
	/**
	 * Pole dat ze kterých budeme sestavovat xml.
	 *
	 * @var array
	 */
	private $_data = array();

	/**
	 * Hlavička a tělo prázndého xml souboru pro idnes.
	 *
	 * @var string
	 */
	private static $_xmlBody = '<?xml version="1.0" encoding="utf-8"?><nemovitost></nemovitost>';

	/**
	 * Nastaví objektu hodnoty.
	 *
	 * @param array $data
	 */
	public function __construct(array $data)
	{
		$this->_data = $data;
	}

	/**
	 * Vrátí vytvořené xml.
	 *
	 * @return string
	 */
	public function build()
	{
		$xml = new SimpleXMLElement(self::$_xmlBody);
		foreach ($this->_data as $node => $value) {
			if ($node === 'images') {
                $this->_addImageFiles($xml, $value);
            } elseif ($node == 'videos') {
			    $this->_addVideoFiles($xml, $value);
			} elseif (is_array($value)) {
				foreach ($value as $val) {
					$xml->addChild($node, $val);
				}
			} elseif(is_bool($value)) {
				$xml->addChild($node, $value ? '1' : '0');
			} else {
				$xml->addChild($node, \htmlspecialchars($value, \ENT_COMPAT, 'UTF-8', false));
			}
		}

		return $xml->saveXML();
	}

	/**
	 * Přidá do xml uzly s obrázky.
	 *
	 * @param SimpleXMLElement $xml      Instance xml dokumentu.
	 * @param array            $files    Pole souborů, které chceme přidat.
	 */
	private function _addImageFiles(SimpleXMLElement $xml, $files)
	{
		if (empty($files)) {
			return;
		}
		$parent = $xml->addChild('images');
		foreach ($files as $values) {
			$kid = $parent->addChild('image');
			$kid->addChild('ord', $values['ord']);
			$kid->addChild('hash', $values['hash']);
			$kid->addChild('filename', $values['filename']);
		}
	}

    /**
     * Přidá do xml uzly s videem.
     *
     * @param SimpleXMLElement $xml      Instance xml dokumentu.
     * @param array            $files    Pole souborů, které chceme přidat.
     */
    private function _addVideoFiles(SimpleXMLElement $xml, $files)
    {
        if (empty($files)) {
            return;
        }
        $parent = $xml->addChild('videos');
        foreach ($files as $values) {
            $kid = $parent->addChild('video');
            $kid->addChild('ord', $values['ord']);
            $kid->addChild('hash', $values['hash']);
            $kid->addChild('filename', $values['filename']);
        }
    }
}
