<?php

/**
 * Vylepšená verze
 */
class Dalten_Export_Api_Backend_RealityCzNew extends Dalten_Export_Api_Backend_RealityCz
{

    public function sendEstate(array $advertData, array $userData, array $images, array $additionalParams)
    {
        if (
            empty($advertData['vsBaseParameters']['RUIAN_ADRESA_KOD']) &&
            empty($advertData['vsBaseParameters']['RUIAN_PARCELA_KOD'])
        ) {
            return new Dalten_Export_Api_ServerResponse(
                false,
                500,
                'Chybí určení části obce u adresy nemovitosti.
				(Pokud je část obce vyplněná, prosím, přeuložte celou nabídku a zadejte export znovu.)'
            );
        }

        // přidáme uživatele, pokud ho máme
        if (!empty($userData['realityid'])) {
            $advertData['vsOptionalParameters']['MAKLER_ID'] = strval($userData['realityid']);
            $advertData['vsOptionalParameters']['MAKLER_UKAZ'] = 1;
            // TODO - do budoucna bychom mohli makléře posílat metodou SendSeller
        }

        $params = $this->_getSoapParams($advertData);

        // odesleme nabidku
        try {
            $this->_call('SendEstateSimple', $params);
        } catch (\Dalten_Export_Api_Backend_Exception_ResponseError $e) {
            if (stripos('exkluziv', $e->getMessage())) {
                // Když si bude stěžovat na exluzivitu, dáme mu DATUM_2 0000-00-00
                $params['vsOptionalParameters']['DATUM_2'] = '0000-00-00';
                try {
                    $this->_call('SendEstateSimple', $params);
                } catch (\Dalten_Export_Api_Backend_Exception_ResponseError $e) {
                    return new Dalten_Export_Api_ServerResponse(false, 500, $e->getMessage());
                }
            } else {
                return new Dalten_Export_Api_ServerResponse(false, 500, $e->getMessage());
            }
        }

        $tooMuchPhotos = false;
        if (count($images) >= 30) {
            $images = array_slice($images, 0, 30);
            $tooMuchPhotos = true;
        }

        // ted pridame fotky

        // ale nejdrive vsechny smazem
        try {
            $params = $this->_getBaseSoapParams($advertData);
            $params['viPictureOrder'] = 99; // smazem vsechny
            $this->_call('DeleteEstatePicture', $params);
        } catch (\Dalten_Export_Api_Backend_Exception_ResponseError $e) {
            return new Dalten_Export_Api_ServerResponse(false, 500, $e->getMessage());
        }

        // ted je jednu po druhe pridame.
        $i = 1;
        foreach ($images as $image) {
            if (file_exists($image['soubor'])) {

                try {

                    $params = $this->_getBaseSoapParams($advertData);
                    $params['viPictureOrder'] = $i;
                    $params['voPicture'] = file_get_contents($image['soubor']);
                    $params['vsDescription'] = $image['popis'];

                    $this->_call('SendEstatePicture', $params);

                    $i++;

                } catch (\Dalten_Export_Api_Backend_Exception_ResponseError $e) {
                    return new Dalten_Export_Api_ServerResponse(false, 500, $e->getMessage());
                }
            }
        }

        // a nakonec vse pustime ke zpracovani
        try {
            $response = $this->_call('ProcessEstate', array('vsConnectionHandle' => $this->_connectionHandle));
        } catch (\Dalten_Export_Api_Backend_Exception_ResponseError $e) {
            return new Dalten_Export_Api_ServerResponse(false, 500, $e->getMessage());
        }

        // vysledek poslem jako hlasku
        $message = $this->_parseSoapMessage($response->ProcessEstateResult);
        if ($tooMuchPhotos) {
            $message .= PHP_EOL . 'Počet fotografií byl omezen na max. počet podporovaný serverem reality.cz = 30.';
        }

        $ret = new Dalten_Export_Api_ServerResponseVerifiable(true, 200, $message);
        $ret->setVerificationStatus(false);
        if ($tooMuchPhotos) {
            $ret->setData(array('importNotice'=>'Počet fotografií byl omezen na max. počet podporovaný serverem reality.cz = 30.'));
        }

        return $ret;
    }

    /**
     * Srovná parametry pro volání soap funkcí podle správného pořadí. (To co vrací config není spolehlivé).
     *
     * @param array $data Zkonvertěná data nabídky.
     *
     * @return array
     */
    protected function _getSoapParams(array $data)
    {
        $params = $this->_getBaseSoapParams($data);

        $baseParameters = '<baseParameters>' . PHP_EOL;
        foreach ($data['vsBaseParameters'] as $name => $val) {
            $baseParameters .= '<param name="' . $name . '">' .
                htmlspecialchars($val, ENT_NOQUOTES) .
                '</param>' . PHP_EOL;
        }
        $baseParameters .= '</baseParameters>' . PHP_EOL;
        $params['vsBaseParameters'] = $baseParameters;

        // vsOptionalParameters je string v podobě níže seskládaného XML.
        if (isset($data['vsOptionalParameters'])) {
            $optionals = '<optionalParameters>' . PHP_EOL;
            foreach ($data['vsOptionalParameters'] as $name => $val) {
                if (is_array($val)) {
                    $val = implode(', ', $val);
                }
                $optionals .= '<param name="' . $name . '">' .
                    htmlspecialchars($val, ENT_NOQUOTES) .
                    '</param>' . PHP_EOL;
            }
            $optionals .= '</optionalParameters>' . PHP_EOL;
            $params['vsOptionalParameters'] = $optionals;
        }

        return $params;
    }

    /**
     * Stáhne dotazy k nabídkám.
     *
     * @param DateTime $dateTime Datum ke kterému se vztahujeme (typicky dnešek).
     *
     * @return Dalten_Export_Api_ServerResponse Odpověď serveru. V případě úspěchu vracíme v outputu zparsované XML.
     */
    public function ListFeedbacks(DateTime $dateTime)
    {
        try {
            $beforeOneDay = clone $dateTime;
            $beforeOneDay->modify('-1 day');
            $vsReport = sprintf('ListFeedbacksXML[%s][%s]', $beforeOneDay->format('Y-m-d'), $dateTime->format('Y-m-d'));

            $response = $this->_call('GetReport', array('vsConnectionHandle' => $this->_connectionHandle, 'vsReport'=>$vsReport));
            $rawXMl =  $this->_parseSoapMessage($response->GetReportResult);
			$xml = @simplexml_load_string($rawXMl);
			if ($xml) {
				return new Dalten_Export_Api_ServerResponse(true, 200, 'OK', $xml);
			} else {
				return new Dalten_Export_Api_ServerResponse(false, 500, $rawXMl);
			}
        } catch (\Dalten_Export_Api_Backend_Exception_ResponseError $e) {
            return new Dalten_Export_Api_ServerResponse(false, 500, $e->getMessage());
        }
    }

    /**
     * Vytopuje nabídku.
     *
     * @param array $data Podklady pro topování.
     *
     * @return Dalten_Export_Api_ServerResponse|Dalten_Export_Api_ServerResponseVerifiable
     */
    public function topListing($data)
    {
        try {
            $response = $this->_call('TopEstate', array('vsConnectionHandle' => $this->_connectionHandle, 'vsCisloZakazky'=>$data['vsCisloZakazky']));
            $rawXMl =  $this->_parseSoapMessage($response->GetReportResult);
            $xml = @simplexml_load_string($rawXMl);
            if ($xml) {
                return new Dalten_Export_Api_ServerResponse(true, 200, 'OK', $xml);
            } else {
                return new Dalten_Export_Api_ServerResponse(false, 500, $rawXMl);
            }
        } catch (\Dalten_Export_Api_Backend_Exception_ResponseError $e) {
            return new Dalten_Export_Api_ServerResponse(false, 500, $e->getMessage());
        }
    }

    protected function _call($method, array $params = array())
    {
        if ($this->_logger instanceof Dalten_Export_Api_Backend_Logger_LoggerInterface) {
            $logParams = $params;
            if ($method=='SendEstatePicture') {
                $logParams['voPicture'] = '... (binary data removed from log) ...';
            }
            $this->_logger->logRemoteCall($method, $logParams);
        }

        try {
            $result = $this->_client->__soapCall($method, array($params));
        } catch (\SoapFault $e) {
            $error = self::_parseSoapMessage($e->getMessage());
            throw new Dalten_Export_Api_Backend_Exception_ResponseError($error);
        } catch (\Exception $e) {
            throw new Dalten_Export_Api_Backend_Exception_ResponseError($e->getMessage());
        }

        if ($this->_logger instanceof Dalten_Export_Api_Backend_Logger_LoggerInterface) {
            $this->_logger->logRemoteResponse($method, $result);
        }

        return $result;
    }


}
