<?php

/**
 * Export do formátu RealityMixu.
 *
 * @category   Dalten
 * @package    Export
 */
class Dalten_Export_RealityMix extends Dalten_Export_AbstractExport
{
	/**
	 * Doplní do převedených hodnot položky uir a uir_level.
	 *
	 * Dále převede ty hodnoty, které byly původně datum na xml-rpc typ datum (druhá část hacku).
	 *
	 * @param array  $convertedValues Pole převedených hodnot entity.
	 * @param array  $originalvalues  Pole původních (nepřevedených) hodnot entity.
	 * @param string $entityName      Název entity.
	 *
	 * @return array Výsledné pole hodnot.
	 */
	protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if ($entityName === 'basic') {
			if (!empty($originalvalues['ruian_adresa_kod'])) {
				$convertedValues['uir_level'] = 11;
				$convertedValues['uir'] = (int)$originalvalues['ruian_adresa_kod'];
			} elseif (!empty($originalvalues['nemovitost_uir_mcast_kod'])) {
				$convertedValues['uir_level'] = 17;
				$convertedValues['uir'] = (int)$originalvalues['nemovitost_uir_mcast_kod'];
			} elseif (!empty($originalvalues['nemovitost_uir_cobce_kod'])) {
				$convertedValues['uir_level'] = 5;
				$convertedValues['uir'] = (int)$originalvalues['nemovitost_uir_cobce_kod'];
			} elseif (!empty($originalvalues['nemovitost_uir_obec_kod'])) {
				$convertedValues['uir_level'] = 3;
				$convertedValues['uir'] = (int)$originalvalues['nemovitost_uir_obec_kod'];
			} elseif (!empty($originalvalues['nemovitost_uir_okres_kod'])) {
				$convertedValues['uir_level'] = 1;
				$convertedValues['uir'] = (int)$originalvalues['nemovitost_uir_okres_kod'];
			} elseif (!empty($originalvalues['nemovitost_uir_stat']) && $originalvalues['nemovitost_uir_stat']!='CZ') {
				$krajText = [];
				foreach (['nemovitost_uir_kraj_text', 'nemovitost_uir_okres_text', 'nemovitost_uir_obec_text', 'nemovitost_uir_cobce_text', 'nemovitost_uir_mcast_text', 'nemovitost_uir_ulice_text'] as $uirText) {
					if (!empty($originalvalues[$uirText])) {
						$krajText[] = $originalvalues[$uirText];
					}
				}

				$convertedValues['fa_state'] = $originalvalues['nemovitost_uir_stat'];
				$convertedValues['fa_kraj'] = implode(', ', $krajText);
			}

		}

		if ($entityName === 'type_4') {
            $garaz = $parkovani = 0;
			if ($originalvalues['nemovitost_garaz']==1) {
				$garaz = 1;
			}
            if ($originalvalues['pocet_mist_k_parkovani']>0) {
                $parkovani = 1;
            }
            $convertedValues['flat_facilities'] = sprintf('%d0%d', $garaz, $parkovani);
		}

		foreach ($this->_entities->$entityName as $itemName=>$itemConfig) {
			if (isset($convertedValues[$itemConfig->column])) {
				if (isset($itemConfig->original_type) and $itemConfig->original_type=="date") {
					xmlrpc_set_type($convertedValues[$itemConfig->column],'datetime');
				}
			}
		}


		return parent::_convert($convertedValues, $originalvalues, $entityName);
	}

	/**
	 * Projde proměnné, zamaskuje datumy jako stringy a označí je stranou. První část hacku.
	 *
	 * V php není žádný typ date, ale v XML-RPC je. Settype v Adamově knihovně by tedy padal. Zároveň je však nutné
	 * zachovat XML-RPC typ, protože jinak by padalo rozhraní na serveru.
	 *
	 * @param array|mixed $values     Pole nepřevedených hodnot.
	 * @param object      $config     Objekt s nastavením.
	 * @param string      $entityName Název entity
	 *
	 * @return array|mixed Pole hodnot.
	 */
	protected function _format(array $values, $config, $entityName) {
		foreach ($config as $name=>$item) {
			if (isset($item->type) and $item->type == "date") {
				$config->$name->type = "string";
				$config->$name->original_type = "date";
			}
		}

		return $values;
	}
}
