<?php

/**
 * Viareality nepodporujou nulové hodnoty u multicheckboxů, takže je potřeba je odstranit.
 */
class Dalten_Export_Viareality extends Dalten_Export_Sreality
{
    public function convertEntityValues($name, array $originalValues, $config)
    {
        $values = parent::convertEntityValues($name, $originalValues, $config);
        $values['locality_street'] = (string) $originalValues['nemovitost_uir_ulice_text'];
        $values['locality_citypart'] = (string) $originalValues['nemovitost_uir_cobce_text'];

        // nefunguje znepřesnění, proto skrýváme údaje co nechceme zobrazit
        if ($values['locality_inaccuracy_level']==2) {
            $values['locality_cp'] = '';
            $values['locality_co'] = '';
        }

        if ($values['locality_inaccuracy_level']==3) {
            $values['locality_cp'] = '';
            $values['locality_co'] = '';
            $values['locality_street'] = '';
        }

        foreach ($values as $key => $value) {
            if (is_array($value)) {
                // odstraníme hodnotu 0
                $values[$key] = array_values(array_diff($value, ['0']));
                // když je pak celý pole prázdné, tak ho odstraníme
                if (count($values[$key]) == 0) {
                    unset($values[$key]);
                }
            }
        }

        return $values;
    }

}
