<?php
/**
 * Rozhraní pro pro nahravani souboru pomoci ftp protokolu.
 *
 * @category Dalten
 * @package  Ftp
 */
interface Dalten_Ftp_ConnectorInterface extends Dalten_Export_Api_Backend_LoggableBackendInterface
{
	/**
	 * Vrati resource s pripojenim na ftp server.
	 *
	 * Pri prvni pozadavku, se spojeni vytvori s aktualnim nastavenim, takze na pozdejsi
	 * zmeny jiz nebude bran ohled.
	 *
	 * @return resource
	 *
	 * @throws Dalten_Ftp_Exception_Connect            Pokud se nepovede spojit se serverem.
	 * @throws Dalten_Ftp_Exception_BadLoginOrPassword Pokud se nepovede prihlasit pomoci loginu a hesla.
	 *
	 */
	public function getConnection();

	/**
	 * Nahraje na ftp soubor z lokální cesty.
	 *
	 * @param string $file        Lokální cesta k souboru který chceme nahrát na server.
	 * @param string $destination Cesta na serveru kam budeme soubor nahrávat.
	 * @param int    $mode        Mod s jakym se maji soubory pouzivat.
	 * @param int    $startpos    Pozice v nahravanem souboru.
	 */
	public function put($file, $destination, $mode = FTP_ASCII, $startpos = 0);

	/**
	 * Nahraje na server obsah do souboru.
	 *
	 * @param string $content     Obsah souboru.
	 * @param string $destination Nazev souboru na serveru.
	 * @param string $mode        Transfer mod.
	 * @param int    $startpos    Pozice v nahravanem souboru.
	 *
	 * @return bool
	 */
	public function putContent($content, $destination, $mode = FTP_ASCII, $startpos = 0);

	/**
	 * Vrati hodnotu casu pro vyprseni spojeni.
	 *
	 * @return int
	 */
	public function getTimeout();

	/**
	 * Nastavi cas vyprseni spojeni se serverem.
	 *
	 * @param int $timeout Cas pro vyprseni spojeni.
	 *
	 * @return Dalten_Ftp_Connector
	 */
	public function setTimeout($timeout);
}
