<?php

class RealitySkTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var Dalten_Export_RealitySk
	 */
	private $export = null;

	/**
	 * @var Serenity_Config_Config
	 */
	private $entities = null;

	/**
	 * Testovaci data pro komercni prostor.
	 *
	 * @var array
	 */
	private $_mockData = array(
		'id_firma' => 2,
		'id_team' => 2,
		'id_uzivatel' => 7,
		'cislo' => 17,
		'id' => 17,
		'zakazka_datum_vlozeno' => '2012-01-05 17:20:46',
		'zakazka_datum_editace' => '2012-01-05 17:20:46',
		'zakazka_provize_celkem' => 3000,
		'zakazka_provize_procenta' => '60',
		'zakazka_typ_smlouvy' => '10',
		'nemovitost_cena_pronajem' => 5000,
		'nemovitost_mena' => 2,
		'nemovitost_cena_poznamka' => 'bez enérgií',
		'nemovitost_cena_pronajem_jednotka' => 2,
		'zakazka_neverejna_poznamka' => '',
		'zakazka_stav' => 10,
		'nemovitost_titulek' => 'SK - testovací nabídka - PRENÁJOM DOMU ( kancelárske priestory)',
		'zakazka_typ' => 2,
		'nemovitost_rok_kolaudace' => 0,
		'nemovitost_anuita' => 0,
		'nemovitost_anuita_mena' => 2,
		'nemovitost_kauce' => '0 EUR',
		'nemovitost_balkon' => 1,
		'nemovitost_balkon_plocha' => 10,
		'nemovitost_pocet_luzek' => 0,
		'nemovitost_plocha_nejvetsi' => 0,
		'nemovitost_plocha_zastavena' => 110,
		'nemovitost_stav_objektu' => 8,
		'nemovitost_druh_objektu' => 2,
		'nemovitost_plocha_obestavena' => 0,
		'nemovitost_vyska_stropu' => 0,
		'nemovitost_sklep' => 0,
		'nemovitost_sklep_plocha' => 0,
		'nemovitost_vybaveni_komercnich_prostor' => 0,
		'nemovitost_vybaveni_komercnich_prostor_popis' => '',
		'nemovitost_ucel_budovy' => 0,
		'nemovitost_konstrukcni_prvky' => '',
		'nemovitost_popis_detailni' => 'SK - testovací nabídka - Ponúkame na prenájom tehlový (zateplený) RD (novostavba), vybavený ako kancelárske priestory pre sídlo firmy.
Celkový výmer podlahovej plochy predstavuje 212,80 m2, z toho:
Suterén : 68,22 m2 z toho: kancelárie 29,50 m2
Prízemie: 72,57 m2 kancelárie 43,52 m2
Poschodie: 72,01 m2 kancelárie 43,47 m2
Vnútorné vybavenie domu: plastové okná, plávajúce podlahy, klimatizácia, kuchynka (kompl. vybavená), WC (na každom poschodí), 2 x kúpelňa.
Pozemok je uzavretý a opatrený bránou na diaľkové ovládanie. Na vydlaždenom pozemku je možnosť bezproblémového parkovania pre 3 motorové vozidlá + dobré možnosti vonkajšieho verejného parkovania.
RD je vybavený samostatným plynovým kúrením a napojený na všetky energie vrátane optického kábla na vysokorýchlostný internet.
Dom je zabezpečený mrežami a moderným bezpečnostným systémom.
Zástavka MHD je vo vzdialenosti 50 m. Dobrá dostupnosť na dialničnú prípojku na Gagarinovej ul. V blízkosti
možnosť stravovania v niekoľkých stravovacích zariadeniach.',
		'nemovitost_bezbarierovy' => 0,
		'nemovitost_elektrina' => '0110',
		'nemovitost_inzenyrske_site' => '0000',
		'nemovitost_vybaveno' => 1,
		'nemovitost_vybaveno_popis' => '',
		'nemovitost_vlastni_pozemek' => 0,
		'nemovitost_stavba_na_pozemku' => 0,
		'nemovitost_druh_pozemku' => 0,
		'nemovitost_obcanska_vybavenost' => '000000',
		'nemovitost_bytu_pocet' => 0,
		'nemovitost_dispozice' => 0,
		'nemovitost_pocet_podlazi' => 2,
		'nemovitost_podlazi_cislo' => 0,
		'nemovitost_pocet_bytu_volnych' => 0,
		'nemovitost_pocet_volnych_kancelari' => 0,
		'nemovitost_garaz' => 0,
		'nemovitost_garaz_plocha' => 0,
		'nemovitost_plocha_zahrada' => 0,
		'nemovitost_pudni_vestavba' => 0,
		'nemovitost_plyn' => '01',
		'nemovitost_plocha_dalsi_zelene' => 0,
		'nemovitost_topeni' => '00000010',
		'nemovitost_vyska' => 0,
		'nemovitost_typ_zarizeni' => 0,
		'nemovitost_delka' => 0,
		'nemovitost_uir_stat' => 'SK',
		'nemovitost_uir_kraj_text' => 'Bratislavský',
		'nemovitost_uir_kraj_kod' => 1,
		'nemovitost_uir_okres_text' => 'Bratislava II',
		'nemovitost_uir_okres_kod' => 102,
		'nemovitost_uir_obec_text' => 'Bratislava - Ružinov',
		'nemovitost_uir_obec_kod' => 529320,
		'nemovitost_uir_cobce_text' => 'Nivy',
		'nemovitost_uir_cobce_kod' => 804274,
		'nemovitost_uir_mcast_text' => '',
		'nemovitost_uir_mcast_kod' => 0,
		'nemovitost_uir_pobvod_text' => '',
		'nemovitost_uir_pobvod_kod' => 0,
		'nemovitost_uir_ulice_text' => 'Mierová',
		'nemovitost_uir_ulice_kod' => 529320131,
		'nemovitost_objekt' => 0,
		'nemovitost_uir_co' => '',
		'nemovitost_uir_cp' => '',
		'nabidka_gps_presnost' => 1,
		'nabidka_gps_x' => 0,
		'nabidka_gps_y' => 0,
		'nemovitost_lodzie' => 0,
		'nemovitost_lodzie_plocha' => 0,
		'nemovitost_ostatni_rozvody' => '1111',
		'nemovitost_plocha_dalsi_nebytove_prostory' => 0,
		'nemovitost_dalsi_nebytove_prostory' => '',
		'nemovitost_ostatni_nebytove_prosotry_popis' => '0011',
		'nemovitost_poloha_objektu' => 0,
		'nemovitost_umisteni_objektu' => 0,
		'nemovitost_typ_domu' => 2,
		'nemovitost_pocet_kancelari' => 0,
		'nemovitost_vybaveni_kancelari' => 0,
		'nemovitost_vybaveni_kancelari_popis' => '',
		'nemovitost_druh_prostor' => 1,
		'nemovitost_plocha_kancelari' => 117,
		'nemovitost_plocha_provozni' => 0,
		'nemovitost_ostatni' => '000000000000',
		'nemovitost_plocha_jine' => 0,
		'nemovitost_plochy_jine_popis' => '',
		'nemovitost_ostatni_vybavenost' => '',
		'nemovitost_plocha_vnejsich_komunikaci' => 0,
		'nemovitost_vlastnictvi' => 1,
		'pocet_mist_k_parkovani' => 0,
		'nemovitost_plocha_parcely' => 1000,
		'nemovitost_bazen' => 0,
		'nemovitost_bazen_plocha' => 0,
		'nemovitost_plocha_vyrobni' => 0,
		'nemovitost_umisteni_v_chranenych_lokalitach' => '000',
		'nemovitost_rok_rekonstrukce' => 0,
		'nemovitost_druh_bytu' => 0,
		'nemovitost_komunikace' => 0,
		'nemovitost_pocet_mist' => 0,
		'nemovitost_pocet_obchodu' => 0,
		'nemovitost_plocha_obchodu' => 0,
		'nemovitost_plocha_nejmensi' => 0,
		'nemovitost_socialni_zarizeni' => 1,
		'nemovitost_socialni_zarizeni_popis' => '',
		'nemovitost_schodiste' => '00000',
		'nemovitost_plocha_skladu' => 0,
		'nemovitost_charakter_zastavby' => 1,
		'nemovitost_telekomunikace' => '11',
		'nemovitost_terasa' => 1,
		'nemovitost_terasa_plocha' => 25,
		'nemovitost_plocha_celkova' => '220',
		'nemovitost_doprava' => '11111',
		'nemovitost_stromy' => 0,
		'nemovitost_typ' => '9',
		'nemovitost_pocet_podlazi_pod_zemi' => 0,
		'nemovitost_plocha_uzitna' => '150',
		'nemovitost_plocha_uzitna_podkrovi' => 0,
		'nemovitost_plocha_uzitna_prizemi' => 0,
		'nemovitost_voda' => '000',
		'nemovitost_sirka' => 0,
		'nemovitost_plocha_dilna' => 0,
		'id_pobocka' => 2,
		'kod' => 'P00017',
		'nemovitost_cena_prodej' => NULL,
		'nemovitost_cena_prodej_jednotka' => NULL,
	);

	/**
	 * Testovací data pro byt.
	 *
	 * @var array
	 */
	private $mockData = array(
		'id_firma' => 2,
		'id_team' => 2,
		'id_uzivatel' => 7,
		'cislo' => 16,
		'id' => 16,
		'zakazka_datum_vlozeno' => '2011-11-02 15:33:23',
		'zakazka_datum_editace' => '2011-11-29 16:01:01',
		'zakazka_provize_celkem' => 50,
		'zakazka_provize_procenta' => '5',
		'zakazka_typ_smlouvy' => '20',
		'nemovitost_cena_pronajem' => 1000,
		'nemovitost_mena' => 2,
		'nemovitost_cena_poznamka' => 'poznamka k cene',
		'nemovitost_cena_pronajem_jednotka' => 2,
		'zakazka_neverejna_poznamka' => 'Súkromná poznámka Súkromná poznámka',
		'zakazka_stav' => 20,
		'nemovitost_titulek' => 'ponuka pro testovani pro export na reality sk',
		'zakazka_typ' => 2,
		'nemovitost_rok_kolaudace' => 0,
		'nemovitost_anuita' => 0,
		'nemovitost_anuita_mena' => 2,
		'nemovitost_kauce' => '0 EUR',
		'nemovitost_balkon' => 1,
		'nemovitost_balkon_plocha' => 4,
		'nemovitost_pocet_luzek' => 0,
		'nemovitost_plocha_nejvetsi' => 0,
		'nemovitost_plocha_zastavena' => 0,
		'nemovitost_stav_objektu' => 2,
		'nemovitost_druh_objektu' => 2,
		'nemovitost_plocha_obestavena' => 0,
		'nemovitost_vyska_stropu' => 3,
		'nemovitost_sklep' => 1,
		'nemovitost_sklep_plocha' => 5,
		'nemovitost_vybaveni_komercnich_prostor' => 0,
		'nemovitost_vybaveni_komercnich_prostor_popis' => '',
		'nemovitost_ucel_budovy' => 0,
		'nemovitost_konstrukcni_prvky' => '',
		'nemovitost_popis_detailni' => 'tak nejaky text, at to neni tak prazdne',
		'nemovitost_bezbarierovy' => 0,
		'nemovitost_elektrina' => '0100',
		'nemovitost_inzenyrske_site' => '0000',
		'nemovitost_vybaveno' => 0,
		'nemovitost_vybaveno_popis' => '',
		'nemovitost_vlastni_pozemek' => 0,
		'nemovitost_stavba_na_pozemku' => 0,
		'nemovitost_druh_pozemku' => 0,
		'nemovitost_obcanska_vybavenost' => '111111',
		'nemovitost_bytu_pocet' => 0,
		'nemovitost_dispozice' => 10,
		'nemovitost_pocet_podlazi' => 6,
		'nemovitost_podlazi_cislo' => 3,
		'nemovitost_pocet_bytu_volnych' => 0,
		'nemovitost_pocet_volnych_kancelari' => 0,
		'nemovitost_garaz' => 1,
		'nemovitost_garaz_plocha' => 0,
		'nemovitost_plocha_zahrada' => 0,
		'nemovitost_pudni_vestavba' => 0,
		'nemovitost_plyn' => '01',
		'nemovitost_plocha_dalsi_zelene' => 0,
		'nemovitost_topeni' => '00000010',
		'nemovitost_vyska' => 0,
		'nemovitost_typ_zarizeni' => 0,
		'nemovitost_delka' => 0,
		'nemovitost_uir_stat' => 'SK',
		'nemovitost_uir_kraj_text' => 'Nitriansky',
		'nemovitost_uir_kraj_kod' => 4,
		'nemovitost_uir_okres_text' => 'Nitra',
		'nemovitost_uir_okres_kod' => 403,
		'nemovitost_uir_obec_text' => 'Nitra',
		'nemovitost_uir_obec_kod' => 500011,
		'nemovitost_uir_cobce_text' => 'Drazovce',
		'nemovitost_uir_cobce_kod' => 812854,
		'nemovitost_uir_mcast_text' => '',
		'nemovitost_uir_mcast_kod' => 0,
		'nemovitost_uir_pobvod_text' => '',
		'nemovitost_uir_pobvod_kod' => 0,
		'nemovitost_uir_ulice_text' => 'Ružová',
		'nemovitost_uir_ulice_kod' => 500011353,
		'nemovitost_objekt' => 0,
		'nemovitost_uir_co' => '0',
		'nemovitost_uir_cp' => '123',
		'nabidka_gps_presnost' => 2,
		'nabidka_gps_x' => 0,
		'nabidka_gps_y' => 0,
		'nemovitost_lodzie' => 0,
		'nemovitost_lodzie_plocha' => 0,
		'nemovitost_ostatni_rozvody' => '0100',
		'nemovitost_plocha_dalsi_nebytove_prostory' => 0,
		'nemovitost_dalsi_nebytove_prostory' => '',
		'nemovitost_ostatni_nebytove_prosotry_popis' => '000',
		'nemovitost_poloha_objektu' => 0,
		'nemovitost_umisteni_objektu' => 2,
		'nemovitost_typ_domu' => 0,
		'nemovitost_pocet_kancelari' => 0,
		'nemovitost_vybaveni_kancelari' => 0,
		'nemovitost_vybaveni_kancelari_popis' => '',
		'nemovitost_druh_prostor' => 0,
		'nemovitost_plocha_kancelari' => 0,
		'nemovitost_plocha_provozni' => 0,
		'nemovitost_ostatni' => '000101000001',
		'nemovitost_plocha_jine' => 0,
		'nemovitost_plochy_jine_popis' => '',
		'nemovitost_ostatni_vybavenost' => '',
		'nemovitost_plocha_vnejsich_komunikaci' => 0,
		'nemovitost_vlastnictvi' => 1,
		'pocet_mist_k_parkovani' => 1,
		'nemovitost_plocha_parcely' => 0,
		'nemovitost_bazen' => 0,
		'nemovitost_bazen_plocha' => 0,
		'nemovitost_plocha_vyrobni' => 0,
		'nemovitost_umisteni_v_chranenych_lokalitach' => '000',
		'nemovitost_rok_rekonstrukce' => 0,
		'nemovitost_druh_bytu' => 2,
		'nemovitost_komunikace' => 0,
		'nemovitost_pocet_mist' => 0,
		'nemovitost_pocet_obchodu' => 0,
		'nemovitost_plocha_obchodu' => 0,
		'nemovitost_plocha_nejmensi' => 0,
		'nemovitost_socialni_zarizeni' => 0,
		'nemovitost_socialni_zarizeni_popis' => '',
		'nemovitost_schodiste' => '00000',
		'nemovitost_plocha_skladu' => 0,
		'nemovitost_charakter_zastavby' => 2,
		'nemovitost_telekomunikace' => '11',
		'nemovitost_terasa' => 0,
		'nemovitost_terasa_plocha' => 0,
		'nemovitost_plocha_celkova' => '75',
		'nemovitost_doprava' => '00110',
		'nemovitost_stromy' => 0,
		'nemovitost_typ' => '4',
		'nemovitost_pocet_podlazi_pod_zemi' => 1,
		'nemovitost_plocha_uzitna' => '65',
		'nemovitost_plocha_uzitna_podkrovi' => 0,
		'nemovitost_plocha_uzitna_prizemi' => 0,
		'nemovitost_voda' => '000',
		'nemovitost_sirka' => 0,
		'nemovitost_plocha_dilna' => 0,
		'id_pobocka' => 2,
		'kod' => 'P00016',
		'nemovitost_cena_prodej' => NULL,
		'nemovitost_cena_prodej_jednotka' => NULL,
	);

	private $user = array(
		'id' => '123',
		'uzivatel_os_jmeno' => 'Dalten',
		'uzivatel_os_prijmeni' => 'Matlák',
		'telefon' => 'Nokia N8',
		'email' => 'info@dalten.cz',
		'moto' => 'Kdo nekrade, je vůl.',
		'foto' => '/matlak.jpg',
		'realitysk_login' => 'eowin.h2o@remax-slovakia.sk.xx',
		'realitysk_pass' => 'go2remax'
	);

	private $images = array(
		'fikoid.jpg' => array(
			'id' => 1,
			'popis' => 'Foto 1',
			'soubor' => '/fikoid.jpeg'
		),

		'fikoid1.jpg' => array(
			'id' => 2,
			'popis' => 'Foto 2',
			'soubor' => '/fikoid.jpeg'
		)
	);

	/**
	 * @var Dalten_Data_ArrayObject
	 */
	private $soapConfig = null;

	private $_userAgentId = 'RK-Remax';
	private $_userAgentPass = '@dUmU4Zqa#*jE0';

	/**
	 * Přídavná data pro editaci.
	 *
	 * @var array
	 */
	private $_additionalParams = array('result' => array(), 'listing' => array());

	public function setUp(): void
	{
		$this->soapConfig = new Dalten_Data_ArrayObject(array(
			'soap_wsdl' => 'http://wstest.reality.sk/services/realityService?wsdl',
			'authNameSpace' => 'http://security.ws.reality.sk',
			'authToken' => 'securityToken',
			'faultNameSpace' => 'http://fault.ws.reality.sk;'
		));

		$iniParser = new Serenity_Config_Parser_Ini();
		$codebooks = new Serenity_Config_Config(CONFIG_PATH . DIRECTORY_SEPARATOR . 'codebooks.ini', $iniParser);
		$this->entities = new Serenity_Config_Config(CONFIG_PATH . DIRECTORY_SEPARATOR . 'reality.sk.ini', $iniParser);

		$this->export = new Dalten_Export_RealitySk($codebooks, $this->entities);
	}

	public function testLogin()
	{
		$backend = new \Dalten_Export_Api_Backend_RealitySk($this->soapConfig);

		$api = new Dalten_Export_Api_RealitySk($this->export, $this->entities, $backend);

		$response = $api->openConnection($this->_userAgentId, $this->_userAgentPass, null, $this->_additionalParams);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());
	}

	/**
	 * Testování správného určení typu a podtypu nabídky.
	 */
	public function testTypesAndSubTypesConsistency()
	{
		$data = $this->mockData;
		$data['nemovitost_typ'] = '1';
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('SERVICE_OBJECTS', $c['propertyType']);
		$this->assertEquals('BREEDINGOBJCT', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '2';
		$data['nemovitost_ucel_budovy'] = 2;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('SERVICE_OBJECTS', $c['propertyType']);
		$this->assertEquals('PRODUCOBJCT', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '3';
		$data['nemovitost_druh_pozemku'] = 5;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('FARM_LANDS', $c['propertyType']);
		$this->assertEquals('MEADOW', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '4';
		$data['nemovitost_dispozice'] = 8;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('APARTMENTS', $c['propertyType']);
		$this->assertEquals('7BEDAPART', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '5';
		$data['nemovitost_druh_objektu'] = '1';
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OTHER_PREMISES', $c['propertyType']);
		$this->assertEquals('HISTORYOBJCT', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '6';
		$data['nemovitost_poloha_objektu'] = 3;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OBJECTS_FOR_LIVING_AND_RECREATION', $c['propertyType']);
		$this->assertEquals('FAMILYHS', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '7';
		$data['nemovitost_typ_zarizeni'] = 3;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OBJECTS_FOR_BUSINESS_AND_SERVICES', $c['propertyType']);
		$this->assertEquals('RESTAURANT', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '8';
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OBJECTS_FOR_BUSINESS_AND_SERVICES', $c['propertyType']);
		$this->assertEquals('RENTALHS', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '9';
		$data['nemovitost_druh_prostor'] = 2;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('BUSINESS_PREMISES', $c['propertyType']);
		$this->assertEquals('BUSINPREM', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '10';
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OBJECTS_FOR_LIVING_AND_RECREATION', $c['propertyType']);
		$this->assertEquals('COTTAGEHS', $c['propertySubType']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '11';
		$data['nemovitost_poloha_objektu'] = 4;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OTHER_PREMISES', $c['propertyType']);
		$this->assertEquals('SINGLEGARAGE', $c['propertySubType']);
	}

	public function testStatusObjectConsistency()
	{
		$data = $this->mockData;
		$data['nemovitost_typ'] = '11';
		$data['nemovitost_poloha_objektu'] = 4;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OTHER_PREMISES', $c['propertyType']);
		$this->assertArrayHasKey('characteristics', $c);
		$this->assertArrayNotHasKey('objectStatus', $c['characteristics']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = '4';
		$data['nemovitost_dispozice'] = 8;
		$data['nemovitost_stav_objektu'] = 3;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('APARTMENTS', $c['propertyType']);
		$this->assertArrayHasKey('objectStatus', $c['characteristics']);
		$this->assertEquals('ORIGINAL', $c['characteristics']['objectStatus']);

		$data['nemovitost_stav_objektu'] = 6;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('APARTMENTS', $c['propertyType']);
		$this->assertArrayHasKey('objectStatus', $c['characteristics']);
		$this->assertEquals('NEWBUILD', $c['characteristics']['objectStatus']);

		$data['nemovitost_stav_objektu'] = 9;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('APARTMENTS', $c['propertyType']);
		$this->assertArrayHasKey('objectStatus', $c['characteristics']);
		$this->assertEquals('COMPLETE', $c['characteristics']['objectStatus']);

		$data['nemovitost_typ'] = '6';
		$data['nemovitost_stav_objektu'] = 9;
		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OBJECTS_FOR_LIVING_AND_RECREATION', $c['propertyType']);
		$this->assertArrayHasKey('objectStatus', $c['characteristics']);
		$this->assertEquals('COMPLETE', $c['characteristics']['objectStatus']);
	}

	public function testGpsDegrees()
	{
		$data = $this->mockData;
		$data['nemovitost_typ'] = '11';
		$data['nemovitost_poloha_objektu'] = 4;
		$data['nabidka_gps_x'] = '48°8\'45.215"N';
		$data['nabidka_gps_y'] = '17°7\'37.739"E';

		$c = $this->export->convertEntityValues('listing', $data, $this->entities->listing);
		$this->assertEquals('OTHER_PREMISES', $c['propertyType']);
		$this->assertArrayHasKey('characteristics', $c);
		$this->assertArrayHasKey('lattitude', $c);
		$this->assertArrayHasKey('longitude', $c);
		$this->assertEquals(48.145893, $c['lattitude']);
		$this->assertEquals(17.127150, $c['longitude']);
	}

	/**
	 * V testu se exportuje nabidka jako nova a pak se pokusi jeste jednou preexportovat a následně smazat.
	 *
	 * @!!!POZOR!!! pokud začne tento test padat. Je možné, že došel kredit počtu možných exportů
	 * pro testovací účet 'eowin.h2o@remax-slovakia.sk.xx' na reality.sk. V tu chvíli je potřeba napsat na
	 * <admin@reality.sk> s žádostí o navýšení kreditů!
	 */
	public function testExportListing()
	{
		$backend = new Dalten_Export_Api_Backend_RealitySk($this->soapConfig);
		$api = new Dalten_Export_Api_RealitySk($this->export, $this->entities, $backend);

		$response = $api->openConnection($this->_userAgentId, $this->_userAgentPass, null, $this->_additionalParams);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());

		foreach ($this->images as $key => $image) {
			$this->images[$key]['soubor'] = realpath(ASSETS_PATH . $image['soubor']);
		}

		// nova nabidka
		$advertData = $this->mockData;
		$advertData['nabidka_gps_x'] = '48°8\'45.215"N';
		$advertData['nabidka_gps_y'] = '17°7\'37.739"E';
		$response = $api->addListing($advertData, $this->user, $this->images);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());

		$data = $response->getData();
		$this->assertArrayHasKey('uniqueIdentifier', $data);
		$this->assertArrayHasKey('images', $data);
		$this->assertArrayHasKey('userData', $data);

		sleep(3);

		// editace nabidky
		$this->images = \array_reverse($this->images); // prehodime poradi obrazků
		$response = $api->addListing($advertData, $this->user, $this->images, array('result' => $data));
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());

		$data = $response->getData();
		$this->assertArrayHasKey('uniqueIdentifier', $data);
		$this->assertArrayHasKey('images', $data);
		$this->assertArrayHasKey('userData', $data);

		sleep(5); // tož oni tam nésó zas tak rychlé s tím zprasováním ;)

		// smazani nabidky
		$response = $api->deleteListing($this->mockData, array('result' => $data));
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());
	}

}
