<?php

/**
 * Export do formátu Living.sk
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_Living extends Dalten_Export_AbstractExport
{
	/**
	 * Umožňuje exportu upravit položky ještě před jejich převedením pomocí processeru..
	 *
	 * @param array  $convertedValues Pole převedených hodnot entity.
	 * @param array  $originalValues  Pole původních (nepřevedených) hodnot entity.
	 * @param string $entityName      Název entity.
	 *
	 * @return array Výsledné pole hodnot.
	 */
	protected function _convert(array $convertedValues, array $originalValues, $entityName)
	{
		$convertedValues = $this->_addRoomNumberFields($originalValues, $convertedValues);

		return $convertedValues;
	}

	/**
	 * Přidá mezi hodnoty počet pokojů.
	 *
	 * @param array $originalValues          Původní (nepřevedené hodnoty).
	 * @param array $convertedValues Převedené hodnoty.
	 *
	 * @return array Převedené hodnoty s doplněnými klíči rooms_chambers a rooms_all.
	 */
	private function _addRoomNumberFields($originalValues, $convertedValues)
	{
		if (isset($originalValues['nemovitost_dispozice'])) {
			switch ($originalValues['nemovitost_dispozice']) {
				case 1: // Garzónka
				case 9: // 1-izb.
					$rooms = 1;
					break;
				case 10: // 2-izb.
					$rooms = 2;
					break;
				case 11: // 3
					$rooms = 3;
					break;
				case 12: // 4
					$rooms = 4;
					break;
				case 13: // 5+
					$rooms = 5;
					break;
				case 17: // jine
				default:
					$rooms = 0;
					break;
			}
			$convertedValues['rooms_chambers'] = $rooms;
			$convertedValues['rooms_all'] = $rooms;
			return $convertedValues;
		}

		return $convertedValues;
	}
}
